/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.lukhnos.portmobile.file.Files;
import org.lukhnos.portmobile.file.NoSuchFileException;
import org.lukhnos.portmobile.file.Path;

public final class FilesystemResourceLoader
implements ResourceLoader {
    private final Path baseDirectory;
    private final ResourceLoader delegate;

    public FilesystemResourceLoader(Path baseDirectory) {
        this(baseDirectory, new ClasspathResourceLoader());
    }

    public FilesystemResourceLoader(Path baseDirectory, ResourceLoader delegate) {
        if (baseDirectory == null) {
            throw new NullPointerException();
        }
        if (!Files.isDirectory((Path)baseDirectory)) {
            throw new IllegalArgumentException(baseDirectory + " is not a directory");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate ResourceLoader may not be null");
        }
        this.baseDirectory = baseDirectory;
        this.delegate = delegate;
    }

    @Override
    public InputStream openResource(String resource) throws IOException {
        try {
            return Files.newInputStream((Path)this.baseDirectory.resolve(resource));
        }
        catch (FileNotFoundException | NoSuchFileException fnfe) {
            return this.delegate.openResource(resource);
        }
    }

    @Override
    public <T> T newInstance(String cname, Class<T> expectedType) {
        return this.delegate.newInstance(cname, expectedType);
    }

    @Override
    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        return this.delegate.findClass(cname, expectedType);
    }
}

