/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.br;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.std40.StandardTokenizer40;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.lukhnos.portmobile.charset.StandardCharsets;

public final class BrazilianAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private CharArraySet excltable = CharArraySet.EMPTY_SET;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public BrazilianAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public BrazilianAnalyzer(CharArraySet stopwords) {
        super(stopwords);
    }

    public BrazilianAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        this(stopwords);
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer source = this.getVersion().onOrAfter(Version.LUCENE_4_7_0) ? new StandardTokenizer() : new StandardTokenizer40();
        TokenFilter result = new LowerCaseFilter((TokenStream)source);
        result = new StandardFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopwords);
        if (this.excltable != null && !this.excltable.isEmpty()) {
            result = new SetKeywordMarkerFilter((TokenStream)result, this.excltable);
        }
        return new Analyzer.TokenStreamComponents(source, (TokenStream)new BrazilianStemFilter((TokenStream)result));
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.getDecodingReader(BrazilianAnalyzer.class, (String)BrazilianAnalyzer.DEFAULT_STOPWORD_FILE, (Charset)StandardCharsets.UTF_8), "#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

