/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;

public final class SPIClassIterator<S>
implements Iterator<Class<? extends S>> {
    private static final Map<String, List<String>> hardCodedServices = new HashMap<String, List<String>>();
    private final Class<S> clazz;
    private final ClassLoader loader;
    private boolean loaded;
    private Iterator<String> linesIterator;

    public static <S> SPIClassIterator<S> get(Class<S> clazz) {
        return new SPIClassIterator<S>(clazz, Thread.currentThread().getContextClassLoader());
    }

    public static <S> SPIClassIterator<S> get(Class<S> clazz, ClassLoader loader) {
        return new SPIClassIterator<S>(clazz, loader);
    }

    public static boolean isParentClassLoader(ClassLoader parent, ClassLoader child) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    private SPIClassIterator(Class<S> clazz, ClassLoader loader) {
        this.clazz = clazz;
        List<String> classList = hardCodedServices.get(clazz.getName());
        if (classList == null || classList.isEmpty()) {
            throw new ServiceConfigurationError("Error loading SPI profiles for type " + clazz.getName() + " from hard-coded services");
        }
        this.loader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        this.linesIterator = Collections.emptySet().iterator();
        this.loaded = false;
    }

    private boolean loadNextProfile() {
        if (this.loaded) {
            return false;
        }
        this.loaded = true;
        this.linesIterator = hardCodedServices.get(this.clazz.getName()).iterator();
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.linesIterator.hasNext() || this.loadNextProfile();
    }

    @Override
    public Class<? extends S> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.linesIterator.hasNext());
        String c = this.linesIterator.next();
        try {
            return Class.forName(c, false, this.loader).asSubclass(this.clazz);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceConfigurationError(String.format(Locale.ROOT, "An SPI class of type %s with classname %s does not exist.", this.clazz.getName(), c));
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        hardCodedServices.put("org.apache.lucene.codecs.Codec", list);
        list.add("org.apache.lucene.codecs.lucene53.Lucene53Codec");
        list = new ArrayList();
        hardCodedServices.put("org.apache.lucene.codecs.DocValuesFormat", list);
        list.add("org.apache.lucene.codecs.lucene50.Lucene50DocValuesFormat");
        list = new ArrayList();
        hardCodedServices.put("org.apache.lucene.codecs.PostingsFormat", list);
        list.add("org.apache.lucene.codecs.lucene50.Lucene50PostingsFormat");
    }
}

