/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.wbases.stores;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.String_;
import gplx.core.envs.System_;
import gplx.core.logs.Gfo_log_wtr;
import gplx.langs.jsons.Json_doc;
import gplx.langs.jsons.Json_nde;
import gplx.xowa.Xoa_ttl;
import gplx.xowa.Xoae_page;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.xtns.wbases.Wdata_doc;
import gplx.xowa.xtns.wbases.Wdata_wiki_mgr;
import gplx.xowa.xtns.wbases.core.Wbase_pid;
import gplx.xowa.xtns.wbases.stores.Wbase_db_log_itm;
import gplx.xowa.xtns.wbases.stores.Wbase_doc_cache;
import gplx.xowa.xtns.wbases.stores.Wbase_doc_cache__hash;
import gplx.xowa.xtns.wbases.stores.Wbase_doc_cache__mru;
import gplx.xowa.xtns.wbases.stores.Wbase_doc_cache__null;
import gplx.xowa.xtns.wbases.stores.Wbase_qid_mgr;

public class Wbase_doc_mgr {
    private final Wdata_wiki_mgr wbase_mgr;
    private final Wbase_qid_mgr qid_mgr;
    private Wbase_doc_cache doc_cache;
    private final Object thread_lock = new Object();
    private final Ordered_hash wbase_db_hash = Ordered_hash_.New_bry();
    private final Gfo_log_wtr wbase_db_log;
    private boolean enabled;
    private static final byte[] Bry__redirect = Bry_.new_a7("redirect");

    public Wbase_doc_mgr(Wdata_wiki_mgr wdata_wiki_mgr, Wbase_qid_mgr wbase_qid_mgr) {
        this.wbase_mgr = wdata_wiki_mgr;
        this.qid_mgr = wbase_qid_mgr;
        this.doc_cache = new Wbase_doc_cache__hash();
        this.wbase_db_log = Gfo_log_wtr.New_dflt("wbase", "db_log_{0}.csv");
    }

    public void Enabled_(boolean bl) {
        this.enabled = bl;
    }

    public void Cache__init(String string, long l, long l2, long l3) {
        if (String_.Eq(string, "null")) {
            this.doc_cache = new Wbase_doc_cache__null();
        } else if (String_.Eq(string, "hash")) {
            this.doc_cache = new Wbase_doc_cache__hash();
        } else if (String_.Eq(string, "mru")) {
            this.doc_cache = new Wbase_doc_cache__mru(l, l2, l3);
        } else {
            throw Err_.new_unhandled_default(string);
        }
    }

    public void Cleanup() {
        this.doc_cache.Term();
        this.wbase_db_log__flush();
    }

    private void wbase_db_log__flush() {
        int n = this.wbase_db_hash.Len();
        Bry_bfr bry_bfr = Bry_bfr_.New();
        for (int i = 0; i < n; ++i) {
            Wbase_db_log_itm wbase_db_log_itm = (Wbase_db_log_itm)this.wbase_db_hash.Get_at(i);
            bry_bfr.Add(wbase_db_log_itm.Ttl());
            bry_bfr.Add_byte_pipe().Add_int_variable(wbase_db_log_itm.Count());
            bry_bfr.Add_byte_pipe().Add_int_variable(wbase_db_log_itm.Elapsed());
            bry_bfr.Add_byte_nl();
            this.wbase_db_log.Write(bry_bfr);
        }
        this.wbase_db_log.Flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear() {
        Object object = this.thread_lock;
        synchronized (object) {
            this.doc_cache.Clear();
        }
    }

    public Wdata_doc Get_by_ttl_or_null(Xowe_wiki xowe_wiki, Xoa_ttl xoa_ttl) {
        byte[] byArray = this.qid_mgr.Get_qid_or_null(xowe_wiki, xoa_ttl);
        return byArray == null ? null : this.Get_by_exact_id_or_null(byArray);
    }

    public Wdata_doc Get_by_xid_or_null(byte[] byArray) {
        return this.Get_by_loose_id_or_null(Wbase_pid.Prepend_property_if_needed(byArray));
    }

    public Wdata_doc Get_by_loose_id_or_null(byte[] byArray) {
        return this.Get_by_exact_id_or_null(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wdata_doc Get_by_exact_id_or_null(byte[] byArray) {
        Wdata_doc wdata_doc = null;
        Object object = this.thread_lock;
        synchronized (object) {
            wdata_doc = this.doc_cache.Get_or_null(byArray);
            if (wdata_doc == null) {
                wdata_doc = this.Load_wdoc_or_null(byArray);
                if (wdata_doc == null) {
                    return null;
                }
                this.Add(byArray, wdata_doc);
            }
        }
        return wdata_doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Wdata_doc Load_wdoc_or_null(byte[] byArray) {
        if (!this.enabled) {
            return null;
        }
        Wbase_db_log_itm wbase_db_log_itm = (Wbase_db_log_itm)this.wbase_db_hash.Get_by(byArray);
        if (wbase_db_log_itm == null) {
            wbase_db_log_itm = new Wbase_db_log_itm(byArray);
            this.wbase_db_hash.Add(byArray, wbase_db_log_itm);
        }
        long l = System_.Ticks();
        Wdata_doc wdata_doc = null;
        Object object = this.thread_lock;
        synchronized (object) {
            int n;
            byte[] byArray2 = byArray;
            for (n = -1; n < 2; ++n) {
                Xoa_ttl xoa_ttl = this.wbase_mgr.Wdata_wiki().Ttl_parse(byArray2);
                if (xoa_ttl == null) {
                    Gfo_usr_dlg_.Instance.Warn_many("", "", "invalid wbase ttl: orig=~{0} cur=~{1}", byArray, byArray2);
                    break;
                }
                Xoae_page xoae_page = this.wbase_mgr.Wdata_wiki().Data_mgr().Load_page_by_ttl(xoa_ttl);
                if (!xoae_page.Db().Page().Exists()) break;
                Json_doc json_doc = this.wbase_mgr.Jdoc_parser().Parse(xoae_page.Db().Text().Text_bry());
                if (json_doc == null) {
                    Gfo_usr_dlg_.Instance.Warn_many("", "", "invalid jdoc for ttl: orig=~{0} cur=~{1}", byArray, byArray2);
                    break;
                }
                Json_nde json_nde = json_doc.Root_nde();
                byte[] byArray3 = json_nde.Get_as_bry_or(Bry__redirect, null);
                if (byArray3 != null) {
                    byArray2 = byArray3;
                    continue;
                }
                wdata_doc = new Wdata_doc(this.wbase_mgr, json_doc, byArray2);
                break;
            }
            if (wdata_doc == null && n >= 2) {
                Gfo_usr_dlg_.Instance.Warn_many("", "", "too many redirects for ttl: orig=~{0} cur=~{1}", byArray, byArray2);
            }
        }
        wbase_db_log_itm.Update(System_.Ticks__elapsed_in_frac(l));
        return wdata_doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Add(byte[] byArray, Wdata_doc wdata_doc) {
        Object object = this.thread_lock;
        synchronized (object) {
            if (this.doc_cache.Get_or_null(byArray) == null) {
                this.doc_cache.Add(byArray, wdata_doc);
            }
        }
    }
}

