/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.scribunto.libs;

import gplx.Bry_;
import gplx.Err_;
import gplx.Hash_adp;
import gplx.Io_url;
import gplx.Keyval;
import gplx.Keyval_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.core.net.Gfo_protocol_itm;
import gplx.xowa.Xoa_ttl;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.addons.wikis.ctgs.Xoax_ctg_addon;
import gplx.xowa.addons.wikis.ctgs.Xoctg_ctg_itm;
import gplx.xowa.wikis.data.site_stats.Xowd_site_stats_mgr;
import gplx.xowa.wikis.domains.Xow_domain_itm;
import gplx.xowa.wikis.domains.Xow_domain_itm_;
import gplx.xowa.wikis.domains.Xow_domain_tid_;
import gplx.xowa.wikis.metas.Xow_wiki_props;
import gplx.xowa.wikis.nss.Xow_ns;
import gplx.xowa.wikis.nss.Xow_ns_mgr;
import gplx.xowa.wikis.xwikis.interwikis.Xow_interwiki_itm;
import gplx.xowa.wikis.xwikis.interwikis.Xow_interwiki_map;
import gplx.xowa.xtns.scribunto.Scrib_core;
import gplx.xowa.xtns.scribunto.Scrib_lib;
import gplx.xowa.xtns.scribunto.Scrib_lua_mod;
import gplx.xowa.xtns.scribunto.Scrib_lua_proc;
import gplx.xowa.xtns.scribunto.libs.Scrib_err;
import gplx.xowa.xtns.scribunto.procs.Scrib_proc_args;
import gplx.xowa.xtns.scribunto.procs.Scrib_proc_mgr;
import gplx.xowa.xtns.scribunto.procs.Scrib_proc_rslt;

public class Scrib_lib_site
implements Scrib_lib {
    private final Scrib_core core;
    private Scrib_lua_mod mod;
    private Scrib_lua_proc notify_wiki_changed_fnc;
    private final Scrib_proc_mgr procs = new Scrib_proc_mgr();
    private static final int Proc_getNsIndex = 0;
    private static final int Proc_pagesInCategory = 1;
    private static final int Proc_pagesInNs = 2;
    private static final int Proc_usersInGroup = 3;
    private static final int Proc_interwikiMap = 4;
    private static final int Proc_init_site_for_wiki = 5;
    public static final String Invk_getNsIndex = "getNsIndex";
    public static final String Invk_pagesInCategory = "pagesInCategory";
    public static final String Invk_pagesInNs = "pagesInNamespace";
    public static final String Invk_usersInGroup = "usersInGroup";
    public static final String Invk_interwikiMap = "interwikiMap";
    public static final String Invk_init_site_for_wiki = "init_site_for_wiki";
    private static final String[] Proc_names = String_.Ary("getNsIndex", "pagesInCategory", "pagesInNamespace", "usersInGroup", "interwikiMap", "init_site_for_wiki");

    public Scrib_lib_site(Scrib_core scrib_core) {
        this.core = scrib_core;
    }

    @Override
    public String Key() {
        return "mw.site";
    }

    public Scrib_lua_mod Mod() {
        return this.mod;
    }

    @Override
    public Scrib_lib Init() {
        this.procs.Init_by_lib(this, Proc_names);
        return this;
    }

    @Override
    public Scrib_lib Clone_lib(Scrib_core scrib_core) {
        return new Scrib_lib_site(scrib_core);
    }

    @Override
    public Scrib_lua_mod Register(Scrib_core scrib_core, Io_url io_url) {
        this.Init();
        this.mod = scrib_core.RegisterInterface(this, io_url.GenSubFil("mw.site.lua"), new Keyval[0]);
        this.notify_wiki_changed_fnc = this.mod.Fncs_get_by_key("notify_wiki_changed");
        return this.mod;
    }

    @Override
    public Scrib_proc_mgr Procs() {
        return this.procs;
    }

    @Override
    public boolean Procs_exec(int n, Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        switch (n) {
            case 0: {
                return this.GetNsIndex(scrib_proc_args, scrib_proc_rslt);
            }
            case 1: {
                return this.PagesInCategory(scrib_proc_args, scrib_proc_rslt);
            }
            case 2: {
                return this.PagesInNs(scrib_proc_args, scrib_proc_rslt);
            }
            case 3: {
                return this.UsersInGroup(scrib_proc_args, scrib_proc_rslt);
            }
            case 4: {
                return this.InterwikiMap(scrib_proc_args, scrib_proc_rslt);
            }
            case 5: {
                return this.Init_site_for_wiki(scrib_proc_args, scrib_proc_rslt);
            }
        }
        throw Err_.new_unhandled(n);
    }

    public boolean GetNsIndex(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        byte[] byArray = scrib_proc_args.Pull_bry(0);
        Xow_ns xow_ns = this.core.Wiki().Ns_mgr().Names_get_or_null(byArray, 0, byArray.length);
        return xow_ns == null ? scrib_proc_rslt.Init_ary_empty() : scrib_proc_rslt.Init_obj(xow_ns.Id());
    }

    public boolean PagesInCategory(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        byte[] byArray = scrib_proc_args.Pull_bry(0);
        String string = scrib_proc_args.Cast_str_or(1, "all");
        Xoa_ttl xoa_ttl = this.core.Wiki().Ttl_parse(14, byArray);
        if (xoa_ttl == null) {
            return scrib_proc_rslt.Init_obj(0);
        }
        byArray = xoa_ttl.Page_db();
        Xoax_ctg_addon xoax_ctg_addon = Xoax_ctg_addon.Get(this.core.Wiki());
        Xoctg_ctg_itm xoctg_ctg_itm = xoax_ctg_addon.Itms__get_or_null(byArray);
        if (xoctg_ctg_itm == null) {
            this.core.Increment_expensive_function_count();
            xoctg_ctg_itm = xoax_ctg_addon.Itms__load(byArray);
        }
        if (String_.Eq(string, "*")) {
            Keyval[] keyvalArray = new Keyval[]{Keyval_.new_("all", xoctg_ctg_itm.All), Keyval_.new_("pages", xoctg_ctg_itm.Pages), Keyval_.new_("subcats", xoctg_ctg_itm.Subcs), Keyval_.new_("files", xoctg_ctg_itm.Files)};
            return scrib_proc_rslt.Init_obj(keyvalArray);
        }
        int n = 0;
        if (String_.Eq(string, "all")) {
            n = xoctg_ctg_itm.All;
        } else if (String_.Eq(string, "pages")) {
            n = xoctg_ctg_itm.Pages;
        } else if (String_.Eq(string, "subcats")) {
            n = xoctg_ctg_itm.Subcs;
        } else if (String_.Eq(string, "files")) {
            n = xoctg_ctg_itm.Files;
        } else {
            throw Scrib_err.Make__err__arg(Invk_pagesInCategory, 2, string, "one of '*', 'all', 'pages', 'subcats', or 'files'");
        }
        return scrib_proc_rslt.Init_obj(n);
    }

    public boolean PagesInNs(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        int n = scrib_proc_args.Pull_int(0);
        Xow_ns xow_ns = this.core.Wiki().Ns_mgr().Ids_get_or_null(n);
        int n2 = xow_ns == null ? 0 : xow_ns.Count();
        return scrib_proc_rslt.Init_obj(n2);
    }

    public boolean UsersInGroup(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return scrib_proc_rslt.Init_obj(0);
    }

    public boolean InterwikiMap(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        String string = scrib_proc_args.Cast_str_or_null(0);
        int n = -1;
        if (String_.Eq(string, "local")) {
            n = 1;
        } else if (String_.Eq(string, "!local")) {
            n = 0;
        } else if (string != null) {
            throw Err_.new_wo_type("bad argument #1 to 'interwikiMap' (unknown filter '$filter')", "filter", string);
        }
        Hash_adp hash_adp = this.core.Wiki().Cache_mgr().Misc_cache();
        String string2 = "scribunto.interwikimap." + this.core.Wiki().Domain_str() + "." + string;
        Keyval[] keyvalArray = (Keyval[])hash_adp.Get_by(string2);
        if (keyvalArray == null) {
            Xow_interwiki_map xow_interwiki_map = this.core.Wiki().Xwiki_mgr().Interwiki_map();
            int n2 = xow_interwiki_map.Len();
            List_adp list_adp = List_adp_.New();
            for (int i = 0; i < n2; ++i) {
                boolean bl;
                Xow_interwiki_itm xow_interwiki_itm = xow_interwiki_map.Get_at(i);
                Xow_domain_itm xow_domain_itm = Xow_domain_itm_.parse(xow_interwiki_itm.Domain());
                boolean bl2 = bl = xow_domain_itm.Domain_type_id() != Xow_domain_tid_.Itm__other.Tid();
                if (n == 1 && !bl || n == 0 && bl) continue;
                String string3 = String_.new_u8(xow_interwiki_itm.Key());
                list_adp.Add(Keyval_.new_(string3, Scrib_lib_site.InterwikiMap_itm(string3, bl, String_.new_u8(xow_interwiki_itm.Url()))));
            }
            keyvalArray = (Keyval[])list_adp.To_ary_and_clear(Keyval.class);
            hash_adp.Add(string2, keyvalArray);
        }
        return scrib_proc_rslt.Init_obj(keyvalArray);
    }

    public static Keyval[] InterwikiMap_itm(String string, boolean bl, String string2) {
        boolean bl2 = false;
        int n = 7;
        if (bl2) {
            n += 2;
        }
        boolean bl3 = String_.Has_at_bgn(string2, "//");
        Keyval[] keyvalArray = new Keyval[n];
        keyvalArray[0] = Keyval_.new_("prefix", string);
        keyvalArray[1] = Keyval_.new_("url", string2);
        keyvalArray[2] = Keyval_.new_("isProtocolRelative", bl3);
        keyvalArray[3] = Keyval_.new_("isLocal", bl);
        keyvalArray[4] = Keyval_.new_("isTranscludable", false);
        keyvalArray[5] = Keyval_.new_("isCurrentWiki", false);
        keyvalArray[6] = Keyval_.new_("isExtraLanguageLink", bl2);
        if (bl2) {
            keyvalArray[7] = Keyval_.new_("displayText", "displayText_TODO");
            keyvalArray[7] = Keyval_.new_("tooltip", "tooltip_TODO");
        }
        return keyvalArray;
    }

    public void Notify_wiki_changed() {
        if (this.notify_wiki_changed_fnc != null) {
            this.core.Interpreter().CallFunction(this.notify_wiki_changed_fnc.Id(), Keyval_.Ary_empty);
        }
    }

    public boolean Init_site_for_wiki(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        Xowe_wiki xowe_wiki = this.core.Wiki();
        Keyval[] keyvalArray = new Keyval[7];
        this.Bld_info(keyvalArray);
        keyvalArray[5] = Keyval_.new_("namespaces", this.Bld_ns_ary(xowe_wiki));
        keyvalArray[6] = Keyval_.new_("stats", this.Bld_stats(xowe_wiki));
        return scrib_proc_rslt.Init_obj(keyvalArray);
    }

    private void Bld_info(Keyval[] keyvalArray) {
        Xow_wiki_props xow_wiki_props = this.core.Wiki().Props();
        keyvalArray[0] = Keyval_.new_("siteName", xow_wiki_props.Site_name());
        keyvalArray[1] = Keyval_.new_("server", Bry_.Add(Gfo_protocol_itm.Bry_relative, xow_wiki_props.Server_name()));
        keyvalArray[2] = Keyval_.new_("scriptPath", xow_wiki_props.Script_path());
        keyvalArray[3] = Keyval_.new_("stylePath", xow_wiki_props.Style_path());
        keyvalArray[4] = Keyval_.new_("currentVersion", xow_wiki_props.Current_version());
    }

    private Keyval[] Bld_ns_ary(Xowe_wiki xowe_wiki) {
        Xow_ns_mgr xow_ns_mgr = xowe_wiki.Ns_mgr();
        int n = xow_ns_mgr.Ids_len();
        Keyval[] keyvalArray = new Keyval[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Xow_ns xow_ns = xow_ns_mgr.Ids_get_at(i);
            if (xow_ns == null) continue;
            int n3 = xow_ns.Id();
            keyvalArray[n2++] = Keyval_.int_(n3, this.Bld_ns(xowe_wiki, xow_ns, n3));
        }
        return keyvalArray;
    }

    private Keyval[] Bld_ns(Xowe_wiki xowe_wiki, Xow_ns xow_ns, int n) {
        int n2 = 16;
        if (n < 0) {
            n2 = 14;
        } else if (n == 0) {
            n2 = 17;
        }
        Keyval[] keyvalArray = new Keyval[n2];
        keyvalArray[0] = Keyval_.new_("id", n);
        keyvalArray[1] = Keyval_.new_("name", xow_ns.Name_ui());
        keyvalArray[2] = Keyval_.new_("canonicalName", xow_ns.Name_db_str());
        keyvalArray[3] = Keyval_.new_("hasSubpages", xow_ns.Subpages_enabled());
        keyvalArray[4] = Keyval_.new_("hasGenderDistinction", xow_ns.Is_gender_aware());
        keyvalArray[5] = Keyval_.new_("isCapitalized", xow_ns.Is_capitalized());
        keyvalArray[6] = Keyval_.new_("isContent", xow_ns.Is_content());
        keyvalArray[7] = Keyval_.new_("isIncludable", xow_ns.Is_includable());
        keyvalArray[8] = Keyval_.new_("isMovable", xow_ns.Is_movable());
        keyvalArray[9] = Keyval_.new_("isSubject", xow_ns.Id_is_subj());
        keyvalArray[10] = Keyval_.new_("isTalk", xow_ns.Id_is_talk());
        keyvalArray[11] = Keyval_.new_("defaultContentModel", null);
        keyvalArray[12] = Keyval_.new_("aliases", xow_ns.Aliases_as_scrib_ary());
        if (n < 0) {
            keyvalArray[13] = Keyval_.new_("subject", n);
        } else {
            keyvalArray[13] = Keyval_.new_("subject", n);
            keyvalArray[14] = Keyval_.new_("talk", xow_ns.Id_talk_id());
            keyvalArray[15] = Keyval_.new_("associated", xow_ns.Id_alt_id());
            if (n == 0) {
                keyvalArray[16] = Keyval_.new_("displayName", xowe_wiki.Msg_mgr().Val_by_id(122));
            }
        }
        return keyvalArray;
    }

    private Keyval[] Bld_stats(Xowe_wiki xowe_wiki) {
        Xowd_site_stats_mgr xowd_site_stats_mgr = xowe_wiki.Stats();
        Keyval[] keyvalArray = new Keyval[]{Keyval_.new_("pages", xowd_site_stats_mgr.Num_pages()), Keyval_.new_("articles", xowd_site_stats_mgr.Num_articles()), Keyval_.new_("files", xowd_site_stats_mgr.Num_files()), Keyval_.new_("edits", xowd_site_stats_mgr.Num_edits()), Keyval_.new_("views", xowd_site_stats_mgr.Num_views()), Keyval_.new_("users", xowd_site_stats_mgr.Num_users()), Keyval_.new_("activeUsers", xowd_site_stats_mgr.Num_active()), Keyval_.new_("admins", xowd_site_stats_mgr.Num_admins())};
        return keyvalArray;
    }
}

