/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.scribunto.libs;

import gplx.Err_;
import gplx.Io_url;
import gplx.Keyval;
import gplx.Keyval_;
import gplx.String_;
import gplx.core.security.algos.Hash_algo;
import gplx.core.security.algos.Hash_algo_factory__composite;
import gplx.core.security.algos.Hash_algo_factory__php_;
import gplx.core.security.algos.Hash_algo_utl;
import gplx.xowa.xtns.scribunto.Scrib_core;
import gplx.xowa.xtns.scribunto.Scrib_lib;
import gplx.xowa.xtns.scribunto.Scrib_lua_mod;
import gplx.xowa.xtns.scribunto.procs.Scrib_proc_args;
import gplx.xowa.xtns.scribunto.procs.Scrib_proc_mgr;
import gplx.xowa.xtns.scribunto.procs.Scrib_proc_rslt;

public class Scrib_lib_hash
implements Scrib_lib {
    private Scrib_lua_mod mod;
    private final Scrib_proc_mgr procs = new Scrib_proc_mgr();
    private static final int Proc_listAlgorithms = 0;
    private static final int Proc_hashValue = 1;
    public static final String Invk_listAlgorithms = "listAlgorithms";
    public static final String Invk_hashValue = "hashValue";
    private static final String[] Proc_names = String_.Ary("listAlgorithms", "hashValue");
    private static final Hash_algo_factory__composite algo_factory = Hash_algo_factory__php_.New();
    private static final Keyval[] algo_keys = Scrib_lib_hash.Make_algo_keys(algo_factory);

    public Scrib_lib_hash(Scrib_core scrib_core) {
    }

    @Override
    public String Key() {
        return "mw.hash";
    }

    public Scrib_lua_mod Mod() {
        return this.mod;
    }

    @Override
    public Scrib_lib Init() {
        this.procs.Init_by_lib(this, Proc_names);
        return this;
    }

    @Override
    public Scrib_lib Clone_lib(Scrib_core scrib_core) {
        return new Scrib_lib_hash(scrib_core);
    }

    @Override
    public Scrib_lua_mod Register(Scrib_core scrib_core, Io_url io_url) {
        this.Init();
        this.mod = scrib_core.RegisterInterface(this, io_url.GenSubFil("mw.hash.lua"), new Keyval[0]);
        return this.mod;
    }

    @Override
    public Scrib_proc_mgr Procs() {
        return this.procs;
    }

    @Override
    public boolean Procs_exec(int n, Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        switch (n) {
            case 0: {
                return this.ListAlgorithms(scrib_proc_args, scrib_proc_rslt);
            }
            case 1: {
                return this.HashValue(scrib_proc_args, scrib_proc_rslt);
            }
        }
        throw Err_.new_unhandled(n);
    }

    public boolean ListAlgorithms(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return scrib_proc_rslt.Init_many_kvs(algo_keys);
    }

    public boolean HashValue(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        if (scrib_proc_args.Len() != 2) {
            return scrib_proc_rslt.Init_obj(null);
        }
        String string = scrib_proc_args.Xstr_str_or_null(0);
        byte[] byArray = scrib_proc_args.Xstr_bry_or_null(1);
        Hash_algo hash_algo = algo_factory.New_hash_algo(string);
        if (hash_algo == null) {
            throw Err_.new_wo_type("Hash_algo is unknown; key=" + string, new Object[0]);
        }
        return scrib_proc_rslt.Init_obj(String_.new_u8(Hash_algo_utl.Calc_hash_as_bry(hash_algo, byArray)));
    }

    private static Keyval[] Make_algo_keys(Hash_algo_factory__composite hash_algo_factory__composite) {
        String[] stringArray = hash_algo_factory__composite.Algo_keys();
        int n = stringArray.length;
        Keyval[] keyvalArray = new Keyval[n];
        for (int i = 0; i < n; ++i) {
            keyvalArray[i] = Keyval_.int_(i + 1, stringArray[i]);
        }
        return new Keyval[]{Keyval_.int_(1, keyvalArray)};
    }
}

