/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.scribunto.engines.process;

import gplx.Err_;
import gplx.String_;
import gplx.core.threads.Thread_adp_;
import gplx.xowa.xtns.scribunto.Scrib_xtn_mgr;
import gplx.xowa.xtns.scribunto.engines.Scrib_server;
import gplx.xowa.xtns.scribunto.engines.process.Process_server_gobbler_error;
import gplx.xowa.xtns.scribunto.engines.process.Process_server_gobbler_recv;
import gplx.xowa.xtns.scribunto.engines.process.Process_stream_rdr;
import java.io.OutputStream;

public class Process_server
implements Scrib_server {
    private Process process;
    private OutputStream stream_write;
    private Process_server_gobbler_recv stream_read;
    private byte[] bry_header = new byte[16];
    private byte[] bry_body = new byte[4096];
    private byte[] bry_error = new byte[4096];
    private Process_stream_rdr process_rdr;
    private Process_server_gobbler_error error_reader;
    int server_timeout = 8000;
    int server_timeout_polling = 1;
    int server_timeout_busy_wait = 250;
    private byte[] cmd_last;

    @Override
    public int Server_timeout() {
        return this.server_timeout;
    }

    @Override
    public Scrib_server Server_timeout_(int n) {
        this.server_timeout = n;
        return this;
    }

    @Override
    public int Server_timeout_polling() {
        return this.server_timeout_polling;
    }

    @Override
    public Scrib_server Server_timeout_polling_(int n) {
        this.server_timeout_polling = n;
        return this;
    }

    @Override
    public int Server_timeout_busy_wait() {
        return this.server_timeout_busy_wait;
    }

    @Override
    public Scrib_server Server_timeout_busy_wait_(int n) {
        this.server_timeout_busy_wait = n;
        return this;
    }

    @Override
    public void Init(String ... stringArray) {
        this.process_rdr = new Process_stream_rdr(this.bry_header, this.bry_body);
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.redirectErrorStream(false);
        try {
            this.process = processBuilder.start();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "core", "process init failed", "args", String_.AryXtoStr(stringArray));
        }
        this.stream_write = this.process.getOutputStream();
        this.error_reader = new Process_server_gobbler_error(this.process.getErrorStream(), this.bry_error);
        this.error_reader.Start();
    }

    @Override
    public byte[] Server_comm(byte[] byArray, Object[] objectArray) {
        this.Server_send(byArray, objectArray);
        return this.Server_recv();
    }

    @Override
    public void Server_send(byte[] byArray, Object[] objectArray) {
        if (this.process == null) {
            throw Err_.new_wo_type("process not started", new Object[0]);
        }
        this.cmd_last = byArray;
        this.stream_read = new Process_server_gobbler_recv(this.process.getInputStream(), this.process_rdr).Start();
        try {
            this.stream_write.write(byArray);
            this.stream_write.flush();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "core", "failed to write to output", new Object[0]);
        }
    }

    @Override
    public byte[] Server_recv() {
        long l;
        long l2 = l = System.currentTimeMillis();
        byte[] byArray;
        while ((byArray = this.stream_read.Data()) == null) {
            long l3 = System.currentTimeMillis();
            if (l3 <= l2 + (long)this.server_timeout_busy_wait) continue;
            if (l3 > l + (long)this.server_timeout) {
                throw Scrib_xtn_mgr.err_("lua_timeout: timeout={0} cmd={1}", this.server_timeout, String_.new_u8(this.cmd_last));
            }
            Thread_adp_.Sleep(this.server_timeout_polling);
            l2 = System.currentTimeMillis();
        }
        return byArray;
    }

    @Override
    public void Term() {
        if (this.error_reader != null) {
            this.error_reader.Term();
        }
        if (this.stream_read != null) {
            this.stream_read.Term();
        }
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

