/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.scribunto.engines.process;

import gplx.Bool_;
import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Double_;
import gplx.Gfo_usr_dlg;
import gplx.Int_;
import gplx.Keyval;
import gplx.Long_;
import gplx.Object_;
import gplx.Type_;
import gplx.xowa.xtns.scribunto.Scrib_lua_proc;
import gplx.xowa.xtns.scribunto.Scrib_xtn_mgr;

public class Process_send_wtr {
    private Gfo_usr_dlg usr_dlg;
    private static final byte[] Prc_bgn = Bry_.new_a7("chunks[");
    private static final byte[] CONST_nil = Bry_.new_a7("nil");
    private static final byte[] CONST_bool_true = Bry_.new_a7("true");
    private static final byte[] CONST_bool_false = Bry_.new_a7("false");
    private static final byte[] CONST_escape_000 = Bry_.new_a7("\\000");
    private static final String GRP_KEY = "xowa-scribunto-lua-srl";

    public Process_send_wtr(Gfo_usr_dlg gfo_usr_dlg) {
        this.usr_dlg = gfo_usr_dlg;
    }

    public String Encode(Object object) {
        Bry_bfr bry_bfr = Bry_bfr_.Reset(1024);
        this.Encode_obj(bry_bfr, object);
        return bry_bfr.To_str_and_clear();
    }

    public void Encode_bool(Bry_bfr bry_bfr, boolean bl) {
        bry_bfr.Add(bl ? CONST_bool_true : CONST_bool_false);
    }

    public void Encode_int(Bry_bfr bry_bfr, int n) {
        bry_bfr.Add_int_variable(n);
    }

    public boolean Encode_double(Bry_bfr bry_bfr, double d) {
        if (Double_.IsNaN(d)) {
            this.usr_dlg.Warn_many(GRP_KEY, "fail_encode_double", "cannot convert non-finite number", new Object[0]);
            return false;
        }
        bry_bfr.Add_double(d);
        return true;
    }

    public boolean Encode_str(Bry_bfr bry_bfr, String string) {
        return this.Encode_str(bry_bfr, Bry_.new_u8(string));
    }

    public boolean Encode_str(Bry_bfr bry_bfr, byte[] byArray) {
        int n = byArray.length;
        bry_bfr.Add_byte((byte)34);
        block7: for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            switch (by) {
                case 34: {
                    bry_bfr.Add_byte((byte)92).Add_byte(by);
                    continue block7;
                }
                case 10: {
                    bry_bfr.Add_byte((byte)92).Add_byte((byte)110);
                    continue block7;
                }
                case 13: {
                    bry_bfr.Add_byte((byte)92).Add_byte((byte)114);
                    continue block7;
                }
                case 0: {
                    bry_bfr.Add(CONST_escape_000);
                    continue block7;
                }
                case 92: {
                    bry_bfr.Add_byte((byte)92).Add_byte((byte)92);
                    continue block7;
                }
                default: {
                    bry_bfr.Add_byte(by);
                }
            }
        }
        bry_bfr.Add_byte((byte)34);
        return true;
    }

    public boolean Encode_prc(Bry_bfr bry_bfr, Scrib_lua_proc scrib_lua_proc) {
        bry_bfr.Add(Prc_bgn);
        bry_bfr.Add_int_variable(scrib_lua_proc.Id());
        bry_bfr.Add_byte((byte)93);
        return true;
    }

    private boolean Encode_ary(Bry_bfr bry_bfr, Keyval[] keyvalArray) {
        int n = keyvalArray.length;
        bry_bfr.Add_byte((byte)123);
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                bry_bfr.Add_byte((byte)44);
            }
            Keyval keyval = keyvalArray[i];
            this.Encode_key(bry_bfr, keyval.Key_as_obj());
            this.Encode_obj(bry_bfr, keyval.Val());
        }
        bry_bfr.Add_byte((byte)125);
        return true;
    }

    private boolean Encode_kv(Bry_bfr bry_bfr, Keyval keyval) {
        bry_bfr.Add_byte((byte)123);
        this.Encode_key(bry_bfr, keyval.Key_as_obj());
        this.Encode_obj(bry_bfr, keyval.Val());
        bry_bfr.Add_byte((byte)125);
        return true;
    }

    public void Encode_key(Bry_bfr bry_bfr, Object object) {
        bry_bfr.Add_byte((byte)91);
        this.Encode_obj(bry_bfr, object);
        bry_bfr.Add_byte((byte)93);
        bry_bfr.Add_byte((byte)61);
    }

    public boolean Encode_obj(Bry_bfr bry_bfr, Object object) {
        if (object == null) {
            bry_bfr.Add(CONST_nil);
            return true;
        }
        Class<?> clazz = Type_.Type_by_obj(object);
        if (Object_.Eq(clazz, Bool_.Cls_ref_type)) {
            this.Encode_bool(bry_bfr, Bool_.Cast(object));
        } else if (Object_.Eq(clazz, Int_.Cls_ref_type)) {
            this.Encode_int(bry_bfr, Int_.Cast(object));
        } else if (Object_.Eq(clazz, Long_.Cls_ref_type)) {
            bry_bfr.Add_long_variable(Long_.cast(object));
        } else if (Object_.Eq(clazz, Double_.Cls_ref_type)) {
            if (!this.Encode_double(bry_bfr, Double_.cast(object))) {
                return false;
            }
        } else if (Object_.Eq(clazz, String.class)) {
            if (!this.Encode_str(bry_bfr, (String)object)) {
                return false;
            }
        } else if (Object_.Eq(clazz, byte[].class)) {
            if (!this.Encode_str(bry_bfr, (byte[])object)) {
                return false;
            }
        } else if (Object_.Eq(clazz, Scrib_lua_proc.class)) {
            if (!this.Encode_prc(bry_bfr, (Scrib_lua_proc)object)) {
                return false;
            }
        } else if (Object_.Eq(clazz, Keyval.class)) {
            if (!this.Encode_kv(bry_bfr, (Keyval)object)) {
                return false;
            }
        } else if (Object_.Eq(clazz, Keyval[].class)) {
            if (!this.Encode_ary(bry_bfr, (Keyval[])object)) {
                return false;
            }
        } else {
            throw Scrib_xtn_mgr.err_("Object cannot be serialized: ~{0}", Type_.Name_by_obj(object));
        }
        return true;
    }
}

