/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.scribunto.engines.luaj;

import gplx.Bool_;
import gplx.Byte_;
import gplx.Char_;
import gplx.Decimal_adp;
import gplx.Double_;
import gplx.Err_;
import gplx.Float_;
import gplx.Int_;
import gplx.Keyval;
import gplx.Keyval_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Long_;
import gplx.Object_;
import gplx.Short_;
import gplx.String_;
import gplx.Type_;
import gplx.xowa.xtns.scribunto.Scrib_lua_proc;
import gplx.xowa.xtns.scribunto.engines.luaj.Luaj_server;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

class Luaj_value_ {
    Luaj_value_() {
    }

    public static String Get_val_as_str(LuaTable luaTable, String string) {
        return ((LuaString)luaTable.get(string)).tojstring();
    }

    public static LuaTable Get_val_as_lua_table(LuaTable luaTable, String string) {
        return (LuaTable)luaTable.get(string);
    }

    public static Keyval[] Get_val_as_kv_ary(Luaj_server luaj_server, LuaTable luaTable, String string) {
        LuaTable luaTable2 = (LuaTable)luaTable.get(string);
        return Luaj_value_.Lua_tbl_to_kv_ary(luaj_server, luaTable2);
    }

    public static Keyval[] Lua_tbl_to_kv_ary(Luaj_server luaj_server, LuaTable luaTable) {
        Varargs varargs;
        int n = luaTable.length();
        Keyval[] keyvalArray = n == 0 ? Keyval_.Ary_empty : new Keyval[n];
        List_adp list_adp = null;
        int n2 = 0;
        LuaValue luaValue = LuaValue.NIL;
        LuaValue luaValue2 = luaTable.getmetatable();
        if (luaValue2 != null && !luaValue2.isnil() && (varargs = ((LuaTable)luaValue2).get("xo_orig_data")) != null && !varargs.isnil()) {
            luaTable = (LuaTable)varargs;
        }
        while ((varargs = luaTable.next(luaValue)) != LuaValue.NIL) {
            LuaValue luaValue3 = varargs.arg(1);
            LuaValue luaValue4 = varargs.arg(2);
            Object object = Luaj_value_.Lua_val_to_obj(luaj_server, luaValue4);
            Keyval keyval = null;
            if (luaValue4.type() == 6) {
                String string = luaValue3.tojstring();
                int n3 = Int_.Cast(object);
                Scrib_lua_proc scrib_lua_proc = new Scrib_lua_proc(string, n3);
                keyval = luaValue3.type() == 4 ? Keyval_.new_(string, scrib_lua_proc) : Keyval_.int_(((LuaInteger)luaValue3).v, scrib_lua_proc);
            } else {
                switch (luaValue3.type()) {
                    case 3: {
                        int n4 = ((LuaNumber)luaValue3).toint();
                        keyval = Keyval_.int_(n4, object);
                        break;
                    }
                    case 4: {
                        keyval = Keyval_.new_(((LuaString)luaValue3).tojstring(), object);
                        break;
                    }
                    default: {
                        throw Err_.new_unhandled(luaValue3.type());
                    }
                }
            }
            if (n2 < n) {
                keyvalArray[n2] = keyval;
            } else {
                if (n2 == n) {
                    list_adp = List_adp_.New();
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            list_adp.Add(keyvalArray[i]);
                        }
                    }
                }
                list_adp.Add(keyval);
            }
            luaValue = luaValue3;
            ++n2;
        }
        return list_adp == null ? keyvalArray : (Keyval[])list_adp.To_ary_and_clear(Keyval.class);
    }

    private static Object Lua_val_to_obj(Luaj_server luaj_server, LuaValue luaValue) {
        switch (luaValue.type()) {
            case 0: {
                return null;
            }
            case 1: {
                return ((LuaBoolean)luaValue).toboolean();
            }
            case 4: {
                return ((LuaString)luaValue).tojstring();
            }
            case 3: {
                LuaNumber luaNumber = (LuaNumber)luaValue;
                if (luaNumber.isint()) {
                    return luaNumber.toint();
                }
                return luaNumber.todouble();
            }
            case 5: {
                return Luaj_value_.Lua_tbl_to_kv_ary(luaj_server, (LuaTable)luaValue);
            }
            case 6: {
                return luaj_server.Get_id_by_closure(luaValue);
            }
        }
        throw Err_.new_unhandled(luaValue.type());
    }

    public static LuaValue Obj_to_lua_val(Luaj_server luaj_server, Object object) {
        if (object == null) {
            return LuaValue.NIL;
        }
        Class<?> clazz = Type_.Type_by_obj(object);
        if (Object_.Eq(clazz, Bool_.Cls_ref_type)) {
            return LuaValue.valueOf((boolean)((Boolean)object));
        }
        if (Object_.Eq(clazz, Byte_.Cls_ref_type)) {
            return LuaValue.valueOf((int)((Byte)object).byteValue());
        }
        if (Object_.Eq(clazz, Int_.Cls_ref_type)) {
            return LuaValue.valueOf((int)((Integer)object));
        }
        if (Object_.Eq(clazz, String_.Cls_ref_type)) {
            return LuaValue.valueOf((String)((String)object));
        }
        if (Object_.Eq(clazz, Double_.Cls_ref_type)) {
            return LuaValue.valueOf((double)((Double)object));
        }
        if (Object_.Eq(clazz, byte[].class)) {
            return LuaValue.valueOf((String)String_.new_u8((byte[])object));
        }
        if (Object_.Eq(clazz, Keyval.class)) {
            return Luaj_value_.Make_lua_tbl_by_kv_ary(luaj_server, (Keyval)object);
        }
        if (Object_.Eq(clazz, Keyval[].class)) {
            return Luaj_value_.Make_lua_tbl_by_kv_ary(luaj_server, (Keyval[])object);
        }
        if (Object_.Eq(clazz, Object[].class)) {
            return Luaj_value_.Make_lua_tbl_by_obj_ary(luaj_server, (Object[])object);
        }
        if (Object_.Eq(clazz, Long_.Cls_ref_type)) {
            return LuaValue.valueOf((double)((Long)object).longValue());
        }
        if (Object_.Eq(clazz, Scrib_lua_proc.class)) {
            return luaj_server.Get_closure_by_id(((Scrib_lua_proc)object).Id());
        }
        if (Object_.Eq(clazz, Float_.Cls_ref_type)) {
            return LuaValue.valueOf((double)((Float)object).floatValue());
        }
        if (Object_.Eq(clazz, Char_.Cls_ref_type)) {
            return LuaValue.valueOf((int)((Character)object).charValue());
        }
        if (Object_.Eq(clazz, Short_.Cls_ref_type)) {
            return LuaValue.valueOf((int)((Short)object).shortValue());
        }
        if (Object_.Eq(clazz, Decimal_adp.class)) {
            return LuaValue.valueOf((double)((Decimal_adp)object).To_double());
        }
        return LuaValue.NIL;
    }

    private static LuaTable Make_lua_tbl_by_kv_ary(Luaj_server luaj_server, Keyval ... keyvalArray) {
        LuaTable luaTable = LuaValue.tableOf();
        block4: for (Keyval keyval : keyvalArray) {
            LuaValue luaValue = Luaj_value_.Obj_to_lua_val(luaj_server, keyval.Val());
            switch (keyval.Key_tid()) {
                case 5: {
                    luaTable.set(Int_.Cast(keyval.Key_as_obj()), luaValue);
                    continue block4;
                }
                case 0: 
                case 10: {
                    luaTable.set(keyval.Key(), luaValue);
                }
            }
        }
        return luaTable;
    }

    private static LuaTable Make_lua_tbl_by_obj_ary(Luaj_server luaj_server, Object ... objectArray) {
        LuaTable luaTable = LuaValue.tableOf();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            LuaValue luaValue = Luaj_value_.Obj_to_lua_val(luaj_server, object);
            luaTable.set(i + 1, luaValue);
        }
        return luaTable;
    }
}

