/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.mapSources;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Bry_find_;
import gplx.Byte_ascii;
import gplx.Double_;
import gplx.Err_;
import gplx.Math_;
import gplx.String_;
import gplx.core.btries.Btrie_slim_mgr;
import gplx.core.primitives.Byte_obj_val;
import gplx.xowa.parsers.Xop_ctx;
import gplx.xowa.parsers.tmpls.Xot_invk;

class Map_math {
    private int word_idx_nsew;
    private double[] rv = new double[4];
    private byte dir_id;
    private int prec;
    private int step;
    private double dec;
    private int error;
    private double coord_dec;
    private double coord_deg;
    private double coord_min;
    private double coord_sec;
    private byte[] coord_dir_ns;
    private byte[] coord_dir_ew;
    private Bry_bfr tmp_bfr = Bry_bfr_.Reset(32);
    private static final byte[] Bry_deg = Bry_.new_u8("\u00b0");
    private static final byte[] Bry_quot_mw = Bry_.new_a7("&quot;");
    private static final byte[] Bry_quot_wb = Bry_.new_a7("&#34;");
    private static final byte[] Bry_apos_mw = Bry_.new_a7("'");
    private static final byte[] Bry_apos_wb = Bry_.new_a7("&#39;");
    private static final byte Dir_unknown_id = 0;
    private static final byte Dir_lat_id = 1;
    private static final byte Dir_long_id = 2;
    public static final byte[] Dir_lat_bry = Bry_.new_a7("lat");
    public static final byte[] Dir_long_bry = Bry_.new_a7("long");
    private static final Btrie_slim_mgr Dir_trie = Btrie_slim_mgr.ci_a7().Add_bry_byte(Dir_lat_bry, (byte)1).Add_bry_byte(Dir_long_bry, (byte)2);
    private static final byte[] Compass_N = new byte[]{78};
    private static final byte[] Compass_E = new byte[]{69};
    private static final byte[] Compass_S = new byte[]{83};
    private static final byte[] Compass_W = new byte[]{87};
    private static final byte Input_byte_degree = 47;
    private static final byte[] Input_units = new byte[]{47, 39, 34, 32};
    private static final int Input_units_len = Input_units.length;
    private static final Btrie_slim_mgr Trie__normalize__apos = Btrie_slim_mgr.cs().Add_replace_many(Byte_ascii.Apos_bry, "\u2018", "\u2019", "\u2032");
    private static final Btrie_slim_mgr Trie__normalize__rest = Btrie_slim_mgr.cs().Add_replace_many("' ", "'").Add_replace_many("\" ", "\"", "''", "\u201c", "\u201d", "\u2033").Add_replace_many(Byte_ascii.Dash_bry, "-", "\u2212").Add_replace_many(Byte_ascii.Space_bry, " ", "_", "/", "\t", "\n", "\r").Add_replace_many("/ ", "\u00b0").Add_replace_many(" N", "N", "n").Add_replace_many(" S", "S", "s").Add_replace_many(" E", "E", "e").Add_replace_many(" W", "W", "w");
    public static final Map_math Instance = new Map_math();

    Map_math() {
    }

    public double Dec() {
        return this.dec;
    }

    public int Error() {
        return this.error;
    }

    public double Coord_dec() {
        return this.coord_dec;
    }

    public double Coord_deg() {
        return this.coord_deg;
    }

    public double Coord_min() {
        return this.coord_min;
    }

    public double Coord_sec() {
        return this.coord_sec;
    }

    public byte[] Coord_dir_ns() {
        return this.coord_dir_ns;
    }

    public byte[] Coord_dir_ew() {
        return this.coord_dir_ew;
    }

    public boolean Ctor(byte[] byArray, int n, byte[] byArray2, int n2) {
        try {
            this.New_coord(byArray, byArray2, n);
            if (n2 > 1 && this.error == 0) {
                this.Set_coord();
            }
        }
        catch (Exception exception) {
            Err_.Noop(exception);
            this.error = -128;
        }
        return this.error == 0;
    }

    public void Fail(Xop_ctx xop_ctx, byte[] byArray, Xot_invk xot_invk, Bry_bfr bry_bfr, byte[] byArray2) {
        String string = xop_ctx.Page().Url().To_str();
        String string2 = String_.new_u8(byArray2);
        String string3 = String_.new_u8(byArray, xot_invk.Src_bgn(), xot_invk.Src_end());
        switch (this.error) {
            case -3: 
            case -2: 
            case -1: {
                xop_ctx.App().Usr_dlg().Log_many("", "", "mapSources failed: page=~{0} pfunc=~{1} err=~{2} src=~{3}", string, string2, this.error, string3);
                break;
            }
            default: {
                xop_ctx.App().Usr_dlg().Warn_many("", "", "mapSources failed: page=~{0} pfunc=~{1} err=~{2} src=~{3}", string, string2, this.error, string3);
            }
        }
    }

    private void New_coord(byte[] byArray, byte[] byArray2, int n) {
        this.error = 0;
        this.word_idx_nsew = -1;
        this.coord_sec = 0.0;
        this.coord_min = 0.0;
        this.coord_deg = 0.0;
        this.coord_dec = 0.0;
        this.rv[2] = 0.0;
        this.rv[1] = 0.0;
        this.rv[0] = 0.0;
        this.rv[3] = 1.0;
        this.dir_id = Map_math.Parse_dir(byArray2);
        this.prec = Map_math.Parse_precision(n);
        this.dec = 0.0;
        this.step = 0;
        this.Parse_input(byArray);
    }

    private void Set_coord() {
        if (this.step > 1) {
            return;
        }
        if (this.prec < 9) {
            this.dec = Math_.Round(this.dec, this.prec);
        }
        int n = this.dec < 0.0 ? -1 : 1;
        double d = Math_.Abs_double(this.dec);
        double d2 = Math_.Floor(d);
        double d3 = (d - d2) * 60.0;
        double d4 = this.prec > 0 ? Math_.Round((d3 - Math_.Floor(d3)) * 60.0, this.prec - 4) : Math_.Round((d3 - Math_.Floor(d3)) * 60.0, 0);
        d3 = Math_.Floor(d3);
        if (d4 >= 60.0) {
            d4 -= 60.0;
            d3 += 1.0;
        }
        if (this.prec < 3 && d4 >= 30.0) {
            d3 += 1.0;
        }
        if (this.prec < 3) {
            d4 = 0.0;
        }
        if (d3 >= 60.0) {
            d3 -= 60.0;
            d2 += 1.0;
        }
        if (this.prec < 1 && d3 >= 30.0) {
            d2 += 1.0;
        }
        if (this.prec < 1) {
            d3 = 0.0;
        }
        this.coord_dec = Math_.Round(this.dec, this.prec);
        this.coord_deg = d2 * (double)n;
        this.coord_min = d3;
        this.coord_sec = d4;
        if (n > 0) {
            this.coord_dir_ns = Compass_N;
            this.coord_dir_ew = Compass_E;
        } else {
            this.coord_dir_ns = Compass_S;
            this.coord_dir_ew = Compass_W;
        }
        this.step = 2;
    }

    public byte[] Get_dms(boolean bl, byte[] byArray, byte[] byArray2) {
        if (this.step < 2) {
            this.Set_coord();
        }
        double d = this.coord_deg;
        if (this.dec < 0.0 && (Bry_.Len_gt_0(byArray) || Bry_.Len_gt_0(byArray2) || bl)) {
            d = Math_.Abs_double(d);
        }
        this.tmp_bfr.Add_double(d).Add(Bry_deg);
        if (this.prec > 0) {
            if (!bl) {
                this.tmp_bfr.Add_byte_space();
            }
            this.tmp_bfr.Add_double(this.coord_min).Add(bl ? Bry_apos_wb : Bry_apos_mw);
        }
        if (this.prec > 2) {
            if (!bl) {
                this.tmp_bfr.Add_byte_space();
            }
            this.tmp_bfr.Add_double(this.coord_sec).Add(bl ? Bry_quot_wb : Bry_quot_mw);
        }
        byte[] byArray3 = null;
        if (this.dir_id == 1) {
            byArray3 = this.coord_dir_ns;
        }
        if (this.dir_id == 2) {
            byArray3 = this.coord_dir_ew;
        }
        if (this.dec > 0.0 && Bry_.Len_gt_0(byArray)) {
            byArray3 = byArray;
        }
        if (this.dec < 0.0 && Bry_.Len_gt_0(byArray2)) {
            byArray3 = byArray2;
        }
        if (byArray3 != null) {
            this.tmp_bfr.Add_byte_space();
            this.tmp_bfr.Add(byArray3);
        }
        return this.tmp_bfr.To_bry_and_clear();
    }

    private void Parse_input(byte[] byArray) {
        if ((byArray = Map_math.Parse_input_normalize(this.tmp_bfr, byArray)) == null) {
            this.error = -1;
            return;
        }
        int n = byArray.length;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            boolean bl = n5 == n;
            int n6 = bl ? 32 : byArray[n5];
            switch (n6) {
                case 32: {
                    this.Parse_input_word(this.rv, byArray, ++n2, n3, n5);
                    ++n4;
                    n3 = n5 = Bry_find_.Find_fwd_while_space_or_tab(byArray, n5, n);
                }
            }
            if (bl) break;
            ++n5;
        }
        if (n4 < 1 || n4 > 4) {
            this.error = -2;
            return;
        }
        if (this.word_idx_nsew != -1 && this.word_idx_nsew != n4 - 1) {
            this.error = -10;
            return;
        }
        this.dec = this.rv[0] >= 0.0 ? (this.rv[0] + this.rv[1] / 60.0 + this.rv[2] / 3600.0) * this.rv[3] : (this.rv[0] - this.rv[1] / 60.0 - this.rv[2] / 3600.0) * this.rv[3];
        this.step = 1;
    }

    private boolean Parse_input_word_is_compass(byte by) {
        switch (by) {
            case 69: 
            case 78: 
            case 83: 
            case 87: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void Parse_input_word(double[] dArray, byte[] byArray, int n, int n2, int n3) {
        double d;
        if (n >= Input_units_len) {
            return;
        }
        byte by = Input_units[n];
        int n4 = Bry_find_.Find_fwd(byArray, by, n2, n3);
        if (n4 != -1) {
            n3 = n4;
        }
        if (!this.Parse_input_word_is_compass(byArray[n2])) {
            double d2 = Bry_.To_double_or(byArray, n2, n3, Double.NaN);
            if (Double_.IsNaN(d2)) {
                this.error = -3;
                return;
            }
            if (n > 2) {
                this.error = -4;
                return;
            }
            switch (n) {
                case 0: {
                    if (!(d2 <= -180.0) && !(d2 > 180.0)) {
                        dArray[0] = d2;
                        return;
                    }
                    this.error = -5;
                    return;
                }
                case 1: {
                    if (d2 < 0.0 || d2 >= 60.0) {
                        this.error = -6;
                        return;
                    }
                    if (dArray[0] != (double)((int)dArray[0])) {
                        this.error = -7;
                        return;
                    }
                    dArray[1] = d2;
                    return;
                }
                case 2: {
                    if (d2 < 0.0 || d2 >= 60.0) {
                        this.error = -8;
                        return;
                    }
                    if (dArray[1] != (double)((int)dArray[1])) {
                        this.error = -9;
                        return;
                    }
                    dArray[2] = d2;
                    return;
                }
            }
            return;
        }
        this.word_idx_nsew = n;
        byte by2 = byArray[n2];
        if (dArray[0] < 0.0) {
            this.error = -11;
            return;
        }
        if (n3 - n2 != 1) {
            this.error = -3;
            return;
        }
        switch (this.dir_id) {
            case 2: {
                if (by2 != 78 && by2 != 83) break;
                this.error = -12;
                return;
            }
            case 1: {
                if (by2 != 69 && by2 != 87) break;
                this.error = -12;
                return;
            }
            case 0: {
                if (by2 == 78 || by2 == 83) {
                    this.dir_id = 1;
                    break;
                }
                this.dir_id = (byte)2;
                break;
            }
        }
        if (this.dir_id == 1 && ((d = dArray[0]) < -90.0 || d > 90.0)) {
            this.error = -13;
            return;
        }
        if (by2 != 83) {
            if (by2 != 87) return;
        }
        dArray[3] = -1.0;
    }

    private static byte Parse_dir(byte[] byArray) {
        if (Bry_.Len_eq_0(byArray)) {
            return 0;
        }
        Object object = Dir_trie.Match_bgn(byArray, 0, byArray.length);
        return object == null ? (byte)0 : ((Byte_obj_val)object).Val();
    }

    private static int Parse_precision(int n) {
        if (n > -1 && n < 10) {
            return n;
        }
        if (n == -1) {
            return 9;
        }
        return 4;
    }

    public static byte[] Parse_input_normalize(Bry_bfr bry_bfr, byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return null;
        }
        byArray = Trie__normalize__apos.Replace(bry_bfr, byArray, 0, n);
        byArray = Trie__normalize__rest.Replace(bry_bfr, byArray, 0, byArray.length);
        return Bry_.Trim(byArray);
    }
}

