/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.cldrs;

import gplx.Bry_;
import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Keyval_;
import gplx.Ordered_hash;
import gplx.String_;
import gplx.langs.jsons.Json_doc;
import gplx.langs.jsons.Json_kv;
import gplx.langs.jsons.Json_nde;
import gplx.langs.jsons.Json_parser;
import gplx.xowa.xtns.cldrs.Cldr_name_file;

public class Cldr_name_loader {
    private final Json_parser parser = new Json_parser();
    private final Io_url cldr_dir;
    private final Hash_adp files_hash = Hash_adp_.New();
    private Hash_adp urls_hash;
    private static final String Token_cldr_names = "CldrNames";
    private static final String Token_json_ext = ".json";

    public Cldr_name_loader(Io_url io_url) {
        this.cldr_dir = io_url;
    }

    public void Clear() {
        this.files_hash.Clear();
        this.urls_hash = null;
    }

    public Cldr_name_file Load_or_empty(String string) {
        Io_url io_url;
        Cldr_name_file cldr_name_file = (Cldr_name_file)this.files_hash.Get_by(string = String_.Lower(string));
        if (cldr_name_file != null) {
            return cldr_name_file;
        }
        if (this.urls_hash == null) {
            this.urls_hash = Cldr_name_loader.Make_urls_hash(Io_mgr.Instance.QueryDir_fils(this.cldr_dir));
        }
        if ((io_url = (Io_url)this.urls_hash.Get_by(string)) == null) {
            Gfo_usr_dlg_.Instance.Log_many("", "", "no cldrName file exists for lang; lang=~{0}", string);
            return Cldr_name_file.Empty;
        }
        byte[] byArray = Io_mgr.Instance.LoadFilBry(io_url);
        if (Bry_.Len_eq_0(byArray)) {
            this.files_hash.Add(string, Cldr_name_file.Empty);
            Gfo_usr_dlg_.Instance.Warn_many("", "", "json is empty; lang=~{lang}", string);
            return Cldr_name_file.Empty;
        }
        cldr_name_file = this.Parse(string, byArray);
        this.files_hash.Add(string, cldr_name_file);
        return cldr_name_file;
    }

    public Cldr_name_file Parse(String string, byte[] byArray) {
        Cldr_name_file cldr_name_file = new Cldr_name_file(string);
        Json_doc json_doc = this.parser.Parse(byArray);
        Json_nde json_nde = json_doc.Root_nde();
        int n = json_nde.Len();
        for (int i = 0; i < n; ++i) {
            Json_kv json_kv = json_nde.Get_at_as_kv(i);
            String string2 = json_kv.Key_as_str();
            Json_nde json_nde2 = json_kv.Val_as_nde();
            Ordered_hash ordered_hash = null;
            if (String_.Eq(string2, "languageNames")) {
                ordered_hash = cldr_name_file.Language_names();
            } else if (String_.Eq(string2, "currencyNames")) {
                ordered_hash = cldr_name_file.Currency_names();
            } else if (String_.Eq(string2, "currencySymbols")) {
                ordered_hash = cldr_name_file.Currency_symbols();
            } else if (String_.Eq(string2, "countryNames")) {
                ordered_hash = cldr_name_file.Country_names();
            } else if (String_.Eq(string2, "timeUnits")) {
                ordered_hash = cldr_name_file.Time_units();
            } else {
                throw Err_.new_unhandled_default(string2);
            }
            this.Load_ary(cldr_name_file, ordered_hash, json_nde2);
        }
        return cldr_name_file;
    }

    private void Load_ary(Cldr_name_file cldr_name_file, Ordered_hash ordered_hash, Json_nde json_nde) {
        int n = json_nde.Len();
        for (int i = 0; i < n; ++i) {
            Json_kv json_kv = (Json_kv)json_nde.Get_at(i);
            String string = json_kv.Key_as_str();
            ordered_hash.Add(string, Keyval_.new_(string, String_.new_u8(json_kv.Val_as_bry())));
        }
    }

    private static Hash_adp Make_urls_hash(Io_url[] io_urlArray) {
        Hash_adp hash_adp = Hash_adp_.New();
        for (Io_url io_url : io_urlArray) {
            String string = io_url.NameAndExt();
            if (!String_.Has_at_bgn(string, Token_cldr_names)) {
                Gfo_usr_dlg_.Instance.Warn_many("", "", "file name does not start with CldrNames ; url=" + io_url.Raw(), new Object[0]);
                continue;
            }
            string = String_.Mid(string, String_.Len(Token_cldr_names), String_.Len(string));
            if (!String_.Has_at_end(string, Token_json_ext)) {
                Gfo_usr_dlg_.Instance.Warn_many("", "", "file name does not end with .json ; url=" + io_url.Raw(), new Object[0]);
                continue;
            }
            string = String_.Mid(string, 0, String_.Len(string) - String_.Len(Token_json_ext));
            string = String_.Lower(string);
            string = String_.Replace(string, "_", "-");
            hash_adp.Add_if_dupe_use_1st(string, io_url);
        }
        return hash_adp;
    }
}

