/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.cldrs;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Keyval;
import gplx.Keyval_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Ordered_hash;
import gplx.String_;
import gplx.core.log_msgs.Gfo_msg_log;
import gplx.core.primitives.Byte_obj_ref;
import gplx.core.primitives.Int_obj_ref;
import gplx.langs.jsons.Json_doc_wtr;
import gplx.langs.phps.Php_evaluator;
import gplx.langs.phps.Php_itm_ary;
import gplx.langs.phps.Php_itm_kv;
import gplx.langs.phps.Php_line;
import gplx.langs.phps.Php_line_assign;
import gplx.langs.phps.Php_parser;
import gplx.langs.phps.Php_text_itm_parser;
import gplx.langs.phps.Php_tkn_wkr;
import gplx.xowa.xtns.cldrs.Cldr_name_file;

class Cldr_name_converter {
    private final Php_parser parser = new Php_parser();
    private final Php_evaluator eval = new Php_evaluator(new Gfo_msg_log("test"));
    private final Php_text_itm_parser text_itm_parser = new Php_text_itm_parser().Quote_is_single_(true);
    private final Json_doc_wtr doc_wtr = new Json_doc_wtr();
    private final List_adp tmp_list = List_adp_.New();
    private final Byte_obj_ref tmp_result = Byte_obj_ref.zero_();
    private final Bry_bfr tmp_bfr = Bry_bfr_.New();
    public static final String File_CldrNames = "CldrNames";
    public static final String Node_languageNames = "languageNames";
    public static final String Node_currencyNames = "currencyNames";
    public static final String Node_currencySymbols = "currencySymbols";
    public static final String Node_countryNames = "countryNames";
    public static final String Node_timeUnits = "timeUnits";

    Cldr_name_converter() {
    }

    public void Convert(Io_url io_url, Io_url io_url2) {
        Cldr_name_file[] cldr_name_fileArray;
        for (Cldr_name_file cldr_name_file : cldr_name_fileArray = this.Parse_dir(io_url)) {
            Io_mgr.Instance.SaveFilStr(io_url2.GenSubDir(File_CldrNames).GenSubFil_ary(File_CldrNames, cldr_name_file.Key(), ".json"), this.To_json(cldr_name_file));
            Gfo_usr_dlg_.Instance.Note_many("", "", "converted file; key={0}", cldr_name_file.Key());
        }
    }

    public Cldr_name_file[] Parse_dir(Io_url io_url) {
        Io_url[] io_urlArray;
        List_adp list_adp = List_adp_.New();
        for (Io_url io_url2 : io_urlArray = Io_mgr.Instance.QueryDir_fils(io_url)) {
            String string = this.Extract_key_or_fail(io_url2.NameAndExt());
            byte[] byArray = Io_mgr.Instance.LoadFilBry(io_url2);
            list_adp.Add(this.Parse_fil(string, byArray));
        }
        return (Cldr_name_file[])list_adp.To_ary_and_clear(Cldr_name_file.class);
    }

    public String Extract_key_or_fail(String string) {
        if (!String_.Has_at_bgn(string, File_CldrNames) || !String_.Has_at_end(string, ".php")) {
            throw Err_.new_wo_type("file name must have a format of CldrNamesLANG.php", "fil_name", string);
        }
        return String_.Mid(string, String_.Len(File_CldrNames), String_.Len(string) - String_.Len(".php"));
    }

    public Cldr_name_file Parse_fil(String string, byte[] byArray) {
        Cldr_name_file cldr_name_file = new Cldr_name_file(string);
        this.parser.Parse_tkns(byArray, (Php_tkn_wkr)this.eval);
        for (Php_line php_line : (Php_line[])this.eval.List().To_ary(Php_line.class)) {
            Php_line_assign php_line_assign = (Php_line_assign)php_line;
            String string2 = String_.new_u8(php_line_assign.Key().Val_obj_bry());
            Ordered_hash ordered_hash = null;
            if (String_.Eq(string2, Node_languageNames)) {
                ordered_hash = cldr_name_file.Language_names();
            } else if (String_.Eq(string2, Node_currencyNames)) {
                ordered_hash = cldr_name_file.Currency_names();
            } else if (String_.Eq(string2, Node_currencySymbols)) {
                ordered_hash = cldr_name_file.Currency_symbols();
            } else if (String_.Eq(string2, Node_countryNames)) {
                ordered_hash = cldr_name_file.Country_names();
            } else if (String_.Eq(string2, Node_timeUnits)) {
                ordered_hash = cldr_name_file.Time_units();
            } else {
                throw Err_.new_unhandled_default(string2);
            }
            this.Parse_assign_line(string, string2, php_line_assign, ordered_hash);
        }
        this.eval.Clear();
        return cldr_name_file;
    }

    private void Parse_assign_line(String string, String string2, Php_line_assign php_line_assign, Ordered_hash ordered_hash) {
        Php_itm_ary php_itm_ary = (Php_itm_ary)php_line_assign.Val();
        int n = php_itm_ary.Subs_len();
        for (int i = 0; i < n; ++i) {
            Php_itm_kv php_itm_kv = (Php_itm_kv)php_itm_ary.Subs_get(i);
            String string3 = String_.new_u8(php_itm_kv.Key().Val_obj_bry());
            String string4 = String_.new_u8(this.text_itm_parser.Parse_as_bry(this.tmp_list, php_itm_kv.Val().Val_obj_bry(), this.tmp_result, this.tmp_bfr));
            if (ordered_hash.Has(string3)) {
                throw Err_.new_wo_type("key already exists", "lang", string, "type", string2, "key", string3);
            }
            ordered_hash.Add(string3, Keyval_.new_(string3, string4));
        }
    }

    public String To_json(Cldr_name_file cldr_name_file) {
        Int_obj_ref int_obj_ref = Int_obj_ref.New_zero();
        this.doc_wtr.Nde_bgn();
        this.To_json(int_obj_ref, Node_languageNames, cldr_name_file.Language_names());
        this.To_json(int_obj_ref, Node_currencyNames, cldr_name_file.Currency_names());
        this.To_json(int_obj_ref, Node_currencySymbols, cldr_name_file.Currency_symbols());
        this.To_json(int_obj_ref, Node_countryNames, cldr_name_file.Country_names());
        this.To_json(int_obj_ref, Node_timeUnits, cldr_name_file.Time_units());
        this.doc_wtr.Nde_end();
        return this.doc_wtr.Bld_as_str();
    }

    private void To_json(Int_obj_ref int_obj_ref, String string, Ordered_hash ordered_hash) {
        int n = ordered_hash.Count();
        if (n == 0) {
            return;
        }
        this.doc_wtr.Key(int_obj_ref.Val() != 0, string);
        this.doc_wtr.Nde_bgn();
        for (int i = 0; i < n; ++i) {
            Keyval keyval = (Keyval)ordered_hash.Get_at(i);
            this.doc_wtr.Kv(i != 0, Bry_.new_u8(keyval.Key()), Bry_.new_u8(keyval.Val_to_str_or_null()));
        }
        this.doc_wtr.Nde_end();
        int_obj_ref.Val_add_post();
    }
}

