/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.wikis.data;

import gplx.Byte_;
import gplx.DateAdp;
import gplx.Err_;
import gplx.Guid_adp_;
import gplx.Int_;
import gplx.Int_ary_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.String_;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_conn_bldr;
import gplx.dbs.cfgs.Db_cfg_tbl;
import gplx.xowa.Xoa_app_;
import gplx.xowa.Xow_wiki;
import gplx.xowa.bldrs.infos.Xob_info_session;
import gplx.xowa.wikis.data.Xow_db_file;
import gplx.xowa.wikis.data.Xow_db_file_;
import gplx.xowa.wikis.data.Xow_db_file__core_;
import gplx.xowa.wikis.data.Xow_db_file_hash;
import gplx.xowa.wikis.data.Xowd_core_db_props;
import gplx.xowa.wikis.data.tbls.Xowd_page_tbl;
import gplx.xowa.wikis.data.tbls.Xowd_text_tbl;

public class Xow_db_mgr {
    private final Io_url wiki_root_dir;
    private final String domain_str;
    private final Ordered_hash hash_by_id = Ordered_hash_.New();
    private final Xow_db_file_hash hash_by_tids = new Xow_db_file_hash();
    private int db_id_next = 0;
    private Xowd_core_db_props props = Xowd_core_db_props.Test;
    private Xow_db_file db__core;
    private Xow_db_file db__text;
    private Xow_db_file db__html;
    private Xow_db_file db__cat_core;
    private Xow_db_file db__wbase;

    public Xow_db_mgr(Io_url io_url, String string) {
        this.wiki_root_dir = io_url;
        this.domain_str = string;
    }

    public Xowd_core_db_props Props() {
        return this.props;
    }

    public Db_cfg_tbl Tbl__cfg() {
        return this.db__core.Tbl__cfg();
    }

    public Xowd_page_tbl Tbl__page() {
        return this.db__core.Tbl__page();
    }

    public Xow_db_file Db__core() {
        return this.db__core;
    }

    public Xow_db_file Db__text() {
        return this.db__text;
    }

    public Xow_db_file Db__html() {
        return this.db__html;
    }

    public Xow_db_file Db__cat_core() {
        return this.db__cat_core;
    }

    public Xow_db_file Db__wbase() {
        return this.db__wbase;
    }

    public void Db__wbase_(Xow_db_file xow_db_file) {
        this.db__wbase = xow_db_file;
    }

    public void Init_by_load(Io_url io_url) {
        this.hash_by_id.Clear();
        this.hash_by_tids.Clear();
        Db_conn db_conn = Db_conn_bldr.Instance.Get(io_url);
        this.props = Xowd_core_db_props.Cfg_load(db_conn);
        this.Dbs__set_by_tid(Xow_db_file.Load(this.props, 0, Xow_db_file__core_.Core_db_tid(this.props.Layout_text()), io_url, "", 1, Guid_adp_.Empty));
        for (Xow_db_file xow_db_file : this.db__core.Tbl__db().Select_all(this.props, io_url.OwnerDir())) {
            this.Dbs__set_by_tid(xow_db_file);
            this.Dbs__add(xow_db_file);
        }
    }

    public void Init_by_make(Xowd_core_db_props xowd_core_db_props, Xob_info_session xob_info_session) {
        this.props = xowd_core_db_props;
        Xow_db_file xow_db_file = Xow_db_file__core_.Make_core_db(xowd_core_db_props, xob_info_session, this.wiki_root_dir, this.domain_str);
        this.Dbs__set_by_tid(xow_db_file);
        this.Dbs__add_and_save(xow_db_file);
        xowd_core_db_props.Cfg_save(this.db__core.Tbl__cfg());
    }

    public void Rls() {
        int n = this.hash_by_id.Len();
        for (int i = 0; i < n; ++i) {
            Xow_db_file xow_db_file = (Xow_db_file)this.hash_by_id.Get_at(i);
            xow_db_file.Rls();
        }
    }

    public int Dbs__len() {
        return this.hash_by_id.Len();
    }

    public Xow_db_file Dbs__get_at(int n) {
        return (Xow_db_file)this.hash_by_id.Get_at(n);
    }

    public Xow_db_file Dbs__get_by_id_or_fail(int n) {
        return (Xow_db_file)this.hash_by_id.Get_by_or_fail(n);
    }

    public Xow_db_file Dbs__get_by_id_or_null(int n) {
        return (Xow_db_file)this.hash_by_id.Get_by(n);
    }

    public Xow_db_file Dbs__get_by_tid_or_core(byte ... byArray) {
        Xow_db_file xow_db_file = this.Dbs__get_by_tid_or_null(byArray);
        return xow_db_file == null ? this.db__core : xow_db_file;
    }

    public Xow_db_file Dbs__get_by_tid_or_null(byte ... byArray) {
        for (byte by : byArray) {
            Ordered_hash ordered_hash = this.hash_by_tids.Get_by_tid_or_null(by);
            if (ordered_hash == null) continue;
            int n = ordered_hash.Len();
            if (n != 1) {
                Xoa_app_.Usr_dlg().Warn_many("", "", "expecting only 1 db for tid; tid=~{0} len=~{1} db_api=~{2}", by, ordered_hash.Len(), this.db__core.Conn().Conn_info().Db_api());
            }
            return (Xow_db_file)ordered_hash.Get_at(n - 1);
        }
        return null;
    }

    public Xow_db_file Dbs__assert_by_tid(byte by) {
        Xow_db_file xow_db_file = this.Dbs__get_by_tid_or_null(by);
        if (xow_db_file == null) {
            xow_db_file = this.Dbs__make_by_tid(by);
        }
        return xow_db_file;
    }

    public Ordered_hash Dbs__get_hash_by_tid(int n) {
        return this.hash_by_tids.Get_by_tid_or_null((byte)n);
    }

    public Xow_db_file Dbs__make_by_tid(byte by) {
        int n = this.Get_tid_idx(this.hash_by_tids, by);
        return this.Dbs__make_by_tid(by, "", n, Xow_db_mgr.Get_tid_name(n, by));
    }

    public Xow_db_file Dbs__make_by_tid(byte by, String string, int n, String string2) {
        return this.Dbs__make_by_id(this.db_id_next++, by, string, n, string2);
    }

    public Xow_db_file Dbs__make_by_id(int n, byte by, String string, int n2, String string2) {
        Io_url io_url = this.wiki_root_dir.GenSubFil(this.domain_str + string2);
        Xow_db_file xow_db_file = Xow_db_file.Make(this.db__core.Info_session(), this.props, n, by, io_url, string, n2, this.db__core.Url().NameAndExt(), Db_conn_bldr.Instance.New(io_url));
        this.Dbs__add_and_save(xow_db_file);
        this.Dbs__set_by_tid(xow_db_file);
        return xow_db_file;
    }

    public Xow_db_file Dbs__remake_by_tid(byte by) {
        this.Dbs__delete_by_tid(by);
        return this.Dbs__make_by_tid(by);
    }

    public void Dbs__delete_by_tid(byte ... byArray) {
        int n = this.hash_by_id.Len();
        for (int i = 0; i < n; ++i) {
            Xow_db_file xow_db_file = (Xow_db_file)this.hash_by_id.Get_at(i);
            if (!Byte_.Match_any(xow_db_file.Tid(), byArray)) continue;
            xow_db_file.Rls();
            Io_mgr.Instance.DeleteFil_args(xow_db_file.Url()).MissingFails_off().Exec();
            xow_db_file.Cmd_mode_((byte)3);
        }
        this.db__core.Tbl__db().Commit_all(this);
        this.Init_by_load(this.db__core.Url());
    }

    public Xow_db_file Dbs__get_for_create(byte by, int n) {
        Xow_db_file[] xow_db_fileArray = this.Dbs__get_ary(by, n);
        if (xow_db_fileArray.length == 0) {
            throw Err_.new_wo_type("no dbs exist; wiki=~{0} type=~{1}", this.domain_str, by);
        }
        return xow_db_fileArray[xow_db_fileArray.length - 1];
    }

    public Xow_db_file[] Dbs__get_ary(byte by, int n) {
        List_adp list_adp = List_adp_.New();
        int n2 = this.Dbs__len();
        for (int i = 0; i < n2; ++i) {
            boolean bl = false;
            Xow_db_file xow_db_file = this.Dbs__get_at(i);
            block0 : switch (by) {
                case 7: {
                    switch (xow_db_file.Tid()) {
                        case 1: {
                            bl = this.props.Layout_text().Tid_is_all_or_few();
                            break;
                        }
                        case 7: {
                            bl = true;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (xow_db_file.Tid()) {
                        case 1: {
                            bl = this.props.Layout_text().Tid_is_all();
                            break block0;
                        }
                        case 9: {
                            bl = true;
                            break block0;
                        }
                        case 2: {
                            int[] nArray;
                            for (int n3 : nArray = Int_ary_.Parse(xow_db_file.Ns_ids(), "|")) {
                                if (n3 != n) continue;
                                bl = true;
                                break block0;
                            }
                        }
                    }
                }
            }
            if (!bl) continue;
            list_adp.Add(xow_db_file);
        }
        return (Xow_db_file[])list_adp.To_ary_and_clear(Xow_db_file.class);
    }

    public void Create_page(Xowd_page_tbl xowd_page_tbl, Xowd_text_tbl xowd_text_tbl, int n, int n2, byte[] byArray, boolean bl, DateAdp dateAdp, byte[] byArray2, int n3, int n4, int n5, int n6) {
        xowd_page_tbl.Insert_cmd_by_batch(n, n2, byArray, bl, dateAdp, n3, n4, n5, n6, -1);
        xowd_text_tbl.Insert_cmd_by_batch(n, byArray2);
    }

    private void Dbs__set_by_tid(Xow_db_file xow_db_file) {
        switch (xow_db_file.Tid()) {
            case 1: 
            case 8: 
            case 9: {
                this.db__core = xow_db_file;
                if (!this.props.Layout_text().Tid_is_all_or_few()) break;
                this.db__cat_core = this.db__text = xow_db_file;
                break;
            }
            case 2: {
                this.db__text = xow_db_file;
                break;
            }
            case 11: {
                this.db__html = xow_db_file;
                break;
            }
            case 5: {
                if (this.db__wbase != null) break;
                this.db__wbase = xow_db_file;
                break;
            }
            case 3: 
            case 6: {
                if (this.db__cat_core != null) break;
                this.db__cat_core = xow_db_file;
            }
        }
    }

    private void Dbs__add(Xow_db_file xow_db_file) {
        int n = xow_db_file.Id();
        this.hash_by_id.Add(n, xow_db_file);
        this.hash_by_tids.Add_or_new(xow_db_file);
        if (n >= this.db_id_next) {
            this.db_id_next = n + 1;
        }
    }

    private void Dbs__add_and_save(Xow_db_file xow_db_file) {
        this.Dbs__add(xow_db_file);
        this.db__core.Tbl__db().Commit_all(this);
        xow_db_file.Info_file().Save(xow_db_file.Tbl__cfg());
        xow_db_file.Info_session().Save(xow_db_file.Tbl__cfg());
    }

    private int Get_tid_idx(Xow_db_file_hash xow_db_file_hash, byte by) {
        return xow_db_file_hash.Count_of_tid(by) + 1;
    }

    private static String Get_tid_name(int n, byte by) {
        String string = Xow_db_file_.To_key(by);
        String string2 = "";
        switch (by) {
            case 6: {
                break;
            }
            case 7: {
                string2 = "-db." + Int_.To_str_pad_bgn_zero(n, 3);
                break;
            }
            default: {
                string2 = n == 1 ? "" : "-db." + Int_.To_str_pad_bgn_zero(n, 3);
            }
        }
        return String_.Format("-{0}{1}.xowa", string, string2);
    }

    public static void Init_by_load(Xow_wiki xow_wiki, Io_url io_url) {
        xow_wiki.Data__core_mgr().Init_by_load(io_url);
        xow_wiki.Props().Init_by_load(xow_wiki.App(), xow_wiki.Data__core_mgr().Tbl__cfg());
    }
}

