/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.mediawiki.includes.filerepo.file;

import gplx.Bry_;
import gplx.Byte_ascii;
import gplx.Math_;
import gplx.Virtual;
import gplx.langs.htmls.encoders.Gfo_url_encoder_;
import gplx.xowa.mediawiki.XomwEnv;
import gplx.xowa.mediawiki.XophpEncode;
import gplx.xowa.mediawiki.XophpString;
import gplx.xowa.mediawiki.XophpUtility;
import gplx.xowa.mediawiki.includes.XomwTitle;
import gplx.xowa.mediawiki.includes.filerepo.XomwFileRepo;
import gplx.xowa.mediawiki.includes.media.XomwMediaHandler;
import gplx.xowa.mediawiki.includes.media.XomwMediaTransformOutput;
import gplx.xowa.mediawiki.includes.parsers.lnkis.Xomw_params_handler;

public class XomwFile {
    private final XomwEnv env;
    public XomwFileRepo repo;
    private XomwTitle title;
    private XomwMediaHandler handler = null;
    public byte[] url;
    public byte[] extension;
    private byte[] name;
    private byte[] path;
    private byte[] hashPath;
    private boolean canRenderVar = true;
    private Object canRenderObj = null;
    private byte[] relPath;
    private static final byte[] Mime_type__unknown = Bry_.new_a7("unknown/unknown");

    static byte[] normalizeExtension(byte[] byArray) {
        return byArray;
    }

    public XomwFile(XomwEnv xomwEnv, XomwTitle xomwTitle, XomwFileRepo xomwFileRepo) {
        this.env = xomwEnv;
        this.title = xomwTitle;
        this.name = xomwTitle.getDBkey();
        this.repo = xomwFileRepo;
    }

    public byte[] getName() {
        if (!XophpUtility.isset(this.name)) {
            this.name = this.repo.getNameFromTitle(this.title);
        }
        return this.name;
    }

    private byte[] getExtension() {
        if (!XophpUtility.isset(this.extension)) {
            int n = XophpString.strpos(this.getName(), (byte)46);
            this.extension = XomwFile.normalizeExtension(n != -1 ? XophpString.substr(this.getName(), n + 1) : Bry_.Empty);
        }
        return this.extension;
    }

    public XomwTitle getTitle() {
        return this.title;
    }

    public byte[] getUrl() {
        if (!XophpUtility.isset(this.url)) {
            byte[] byArray = this.getExtension();
            this.url = Bry_.Add(this.repo.getZoneUrl(0, byArray), Byte_ascii.Slash_bry, this.getUrlRel());
        }
        return this.url;
    }

    public byte[] getPath() {
        if (this.path == null) {
            this.path = Bry_.Add(this.repo.getZonePath(0), Byte_ascii.Slash_bry, this.getRel());
        }
        return this.path;
    }

    @Virtual
    public int getWidth(int n) {
        return -1;
    }

    public int getWidth() {
        return this.getWidth(1);
    }

    @Virtual
    public int getHeight(int n) {
        return -1;
    }

    public int getHeight() {
        return this.getHeight(1);
    }

    public boolean isVectorized() {
        return false;
    }

    @Virtual
    public byte[] getMimeType() {
        return Mime_type__unknown;
    }

    public boolean canRender() {
        if (this.canRenderObj == null) {
            this.canRenderVar = this.getHandler().canRender(this) && this.exists();
            this.canRenderObj = this;
        }
        return this.canRenderVar;
    }

    public boolean mustRender() {
        XomwMediaHandler xomwMediaHandler = this.getHandler();
        return xomwMediaHandler.mustRender(this);
    }

    public boolean allowInlineDisplay() {
        return this.canRender();
    }

    public boolean exists() {
        return true;
    }

    public byte[] thumbName(Xomw_params_handler xomw_params_handler) {
        return this.thumbName(xomw_params_handler, 0);
    }

    public byte[] thumbName(Xomw_params_handler xomw_params_handler, int n) {
        byte[] byArray = this.getName();
        return this.generateThumbName(byArray, xomw_params_handler);
    }

    public byte[] generateThumbName(byte[] byArray, Xomw_params_handler xomw_params_handler) {
        XomwMediaHandler xomwMediaHandler = this.getHandler();
        if (xomwMediaHandler == null) {
            return null;
        }
        this.extension = this.getExtension();
        byte[] byArray2 = xomwMediaHandler.makeParamString(xomw_params_handler);
        byArray2 = Bry_.Add(byArray2, Byte_ascii.Dash_bry, byArray);
        return byArray2;
    }

    public XomwMediaTransformOutput transform(Xomw_params_handler xomw_params_handler) {
        return this.transform(xomw_params_handler, 0);
    }

    public XomwMediaTransformOutput transform(Xomw_params_handler xomw_params_handler, int n) {
        XomwMediaTransformOutput xomwMediaTransformOutput;
        block1: {
            xomwMediaTransformOutput = null;
            if (!this.canRender()) break block1;
            if (this.repo != null) {
                // empty if block
            }
            Object var4_4 = null;
            xomwMediaTransformOutput = this.generateAndSaveThumb(var4_4, xomw_params_handler, n);
        }
        return xomwMediaTransformOutput;
    }

    public XomwMediaTransformOutput generateAndSaveThumb(Object object, Xomw_params_handler xomw_params_handler, int n) {
        XomwMediaHandler xomwMediaHandler = this.getHandler();
        Xomw_params_handler xomw_params_handler2 = xomw_params_handler;
        xomwMediaHandler.normaliseParams(this, xomw_params_handler2);
        byte[] byArray = this.thumbName(xomw_params_handler2);
        byte[] byArray2 = this.getThumbUrl(byArray);
        byte[] byArray3 = Bry_.Empty;
        XomwMediaTransformOutput xomwMediaTransformOutput = xomwMediaHandler.doTransform(this, byArray3, byArray2, xomw_params_handler);
        return xomwMediaTransformOutput;
    }

    public XomwMediaHandler getHandler() {
        if (this.handler == null) {
            this.handler = this.env.MediaHandlerFactory().getHandler(this.getMimeType());
        }
        return this.handler;
    }

    private byte[] getHashPath() {
        if (!XophpUtility.isset(this.hashPath)) {
            this.hashPath = this.repo.getHashPath(this.getName());
        }
        return this.hashPath;
    }

    private byte[] getRel() {
        if (this.relPath == null) {
            this.relPath = Bry_.Add(this.getHashPath(), this.getName());
        }
        return this.relPath;
    }

    private byte[] getThumbRel(byte[] byArray) {
        this.path = this.getRel();
        if (byArray != null) {
            this.path = Bry_.Add(this.path, Byte_ascii.Slash_bry, byArray);
        }
        return this.path;
    }

    private byte[] getUrlRel() {
        return Bry_.Add(this.getHashPath(), XophpEncode.rawurlencode(this.getName()));
    }

    public byte[] getThumbPath(byte[] byArray) {
        return Bry_.Add(this.repo.getZonePath(1), Byte_ascii.Slash_bry, this.getThumbRel(byArray));
    }

    private byte[] getZoneUrl(int n, byte[] byArray) {
        byte[] byArray2 = this.getExtension();
        byte[] byArray3 = Bry_.Add(this.repo.getZoneUrl(n, byArray2), Byte_ascii.Slash_bry, this.getUrlRel());
        if (byArray != null) {
            byArray3 = Bry_.Add(byArray3, Byte_ascii.Slash_bry, Gfo_url_encoder_.Php_rawurlencode.Encode(byArray));
        }
        return byArray3;
    }

    private byte[] getThumbUrl(byte[] byArray) {
        return this.getZoneUrl(1, byArray);
    }

    public static int scaleHeight(int n, int n2, int n3) {
        if (n == 0) {
            return 0;
        }
        return (int)Math_.Round(n2 * n3 / n, 0);
    }
}

