/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.mediawiki.includes.content;

import gplx.Err_;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.xowa.mediawiki.includes.content.XomwContent;
import gplx.xowa.mediawiki.includes.content.XomwTextContentHandler;
import gplx.xowa.mediawiki.includes.content.XomwWikitextContentHandler;

public abstract class XomwContentHandler {
    private static XomwContentHandler[] handlers = new XomwContentHandler[5];
    private int mModelID;
    private String[] mSupportedFormats;
    private Ordered_hash mSupportedFormatsHash = Ordered_hash_.New();

    public static XomwContentHandler getForContent(XomwContent xomwContent) {
        int n = xomwContent.getModel();
        return XomwContentHandler.getForModelID(n);
    }

    public static XomwContentHandler getForModelID(int n) {
        XomwContentHandler xomwContentHandler = handlers[n];
        if (xomwContentHandler != null) {
            return xomwContentHandler;
        }
        switch (n) {
            case 0: {
                xomwContentHandler = new XomwWikitextContentHandler();
                break;
            }
            case 4: {
                xomwContentHandler = new XomwTextContentHandler();
                break;
            }
            default: {
                throw Err_.new_unhandled_default(n);
            }
        }
        XomwContentHandler.handlers[n] = xomwContentHandler;
        return xomwContentHandler;
    }

    public XomwContentHandler(int n, String ... stringArray) {
        this.mModelID = n;
        this.mSupportedFormats = stringArray;
        for (String string : stringArray) {
            this.mSupportedFormatsHash.Add_as_key_and_val(string);
        }
    }

    public int getModelID() {
        return this.mModelID;
    }

    public String[] getSupportedFormats() {
        return this.mSupportedFormats;
    }

    public String getDefaultFormat() {
        return this.mSupportedFormats[0];
    }

    public boolean isSupportedFormat(String string) {
        if (string == null) {
            return true;
        }
        return this.mSupportedFormatsHash.Has(string);
    }
}

