/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.mediawiki.includes.content;

import gplx.Err_;
import gplx.Virtual;
import gplx.xowa.mediawiki.includes.XomwMagicWord;
import gplx.xowa.mediawiki.includes.XomwTitle;
import gplx.xowa.mediawiki.includes.content.XomwContent;
import gplx.xowa.mediawiki.includes.content.XomwContentHandler;
import gplx.xowa.mediawiki.includes.exception.XomwMWException;
import gplx.xowa.mediawiki.includes.parsers.XomwParserOptions;
import gplx.xowa.mediawiki.includes.parsers.XomwParserOutput;

public abstract class XomwAbstractContent
implements XomwContent {
    private int model_id;

    public XomwAbstractContent(int n) {
        this.model_id = n;
    }

    @Override
    public int getModel() {
        return this.model_id;
    }

    protected void checkModelID(int n) {
        if (n != this.model_id) {
            throw new XomwMWException("Bad content model: expected " + this.model_id + "but got " + n);
        }
    }

    @Override
    public XomwContentHandler getContentHandler() {
        return XomwContentHandler.getForContent(this);
    }

    @Override
    public String getDefaultFormat() {
        return this.getContentHandler().getDefaultFormat();
    }

    @Override
    public String[] getSupportedFormats() {
        return this.getContentHandler().getSupportedFormats();
    }

    @Override
    public boolean isSupportedFormat(String string) {
        if (string == null) {
            return true;
        }
        return this.getContentHandler().isSupportedFormat(string);
    }

    public void checkFormat(String string) {
        if (!this.isSupportedFormat(string)) {
            throw new XomwMWException("Format " + string + " is not supported for content model " + this.getModel());
        }
    }

    @Override
    public String serialize(String string) {
        throw Err_.new_unimplemented();
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    @Virtual
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean equals(XomwContent xomwContent) {
        if (xomwContent == null) {
            return false;
        }
        if (xomwContent == this) {
            return true;
        }
        if (xomwContent.getModel() != this.getModel()) {
            return false;
        }
        return this.getNativeData() == xomwContent.getNativeData();
    }

    @Override
    public XomwTitle[] getRedirectChain() {
        throw Err_.new_unimplemented();
    }

    @Override
    @Virtual
    public boolean matchMagicWord(XomwMagicWord xomwMagicWord) {
        return false;
    }

    @Override
    public abstract byte[] getTextForSearchIndex();

    @Override
    public abstract byte[] getWikitextForTransclusion();

    @Override
    public abstract byte[] getTextForSummary(int var1);

    @Override
    public abstract Object getNativeData();

    @Override
    public abstract int getSize();

    @Override
    public abstract XomwContent copy();

    @Override
    public abstract boolean isCountable(boolean var1);

    @Override
    public abstract XomwParserOutput getParserOutput(XomwTitle var1, int var2, XomwParserOptions var3, boolean var4);

    @Override
    public abstract Object getSecondaryDataUpdates(XomwTitle var1, XomwContent var2, boolean var3, XomwParserOutput var4);

    @Override
    public abstract XomwTitle getRedirectTarget();

    @Override
    public abstract XomwTitle getUltimateRedirectTarget();

    @Override
    public abstract boolean isRedirect();

    @Override
    public abstract XomwContent updateRedirect(XomwTitle var1);

    @Override
    public abstract XomwContent getSection(String var1);

    @Override
    public abstract byte[] replaceSection(String var1, XomwContent var2, String var3);

    @Override
    public abstract XomwContent preSaveTransform(XomwTitle var1, Object var2, XomwParserOptions var3);

    @Override
    public abstract XomwContent addSectionHeader(byte[] var1);

    @Override
    public abstract XomwContent preloadTransform(XomwTitle var1, XomwParserOptions var2, Object[] var3);

    @Override
    public abstract Object prepareSave(Object var1, int var2, int var3, Object var4);

    @Override
    public abstract Object getDeletionUpdates(Object var1, XomwParserOutput var2);

    @Override
    public abstract XomwContent convert(byte[] var1, byte[] var2);
}

