/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.mediawiki.includes;

import gplx.Bry_;
import gplx.Byte_ascii;
import gplx.Err_;
import gplx.core.intls.Utf8_;
import gplx.xowa.htmls.hrefs.Xoh_href_;
import gplx.xowa.mediawiki.XomwEnv;
import gplx.xowa.mediawiki.XophpString;
import gplx.xowa.mediawiki.includes.XomwGlobalFunctions;
import gplx.xowa.mediawiki.includes.title.XomwMalformedTitleException;
import gplx.xowa.mediawiki.includes.title.XomwMediaWikiTitleCodec;
import gplx.xowa.mediawiki.includes.title.XomwMediaWikiTitleCodecParts;

public class XomwTitle {
    private byte[] mTextform = Bry_.Empty;
    private byte[] mUrlform = Bry_.Empty;
    private byte[] mDbkeyform = Bry_.Empty;
    protected byte[] mUserCaseDBKey;
    public int mNamespace = 0;
    public byte[] mInterwiki = Bry_.Empty;
    private boolean mLocalInterwiki = false;
    private byte[] mFragment = Bry_.Empty;
    public int mArticleID = -1;
    private byte[] mPrefixedText = null;
    public int mDefaultNamespace = 0;
    private final XomwEnv env;
    private static final byte[] Bry__wgArticlePath__wiki = Bry_.new_a7("/wiki/");
    private static boolean[] title_chars_valid;

    XomwTitle(XomwEnv xomwEnv) {
        this.env = xomwEnv;
    }

    public static XomwTitle newFromText(XomwEnv xomwEnv, byte[] byArray) {
        return XomwTitle.newFromText(xomwEnv, byArray, 0);
    }

    private static XomwTitle newFromText(XomwEnv xomwEnv, byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        try {
            return XomwTitle.newFromTextThrow(xomwEnv, byArray, n);
        }
        catch (XomwMalformedTitleException xomwMalformedTitleException) {
            Err_.Noop(xomwMalformedTitleException);
            return null;
        }
    }

    private static XomwTitle newFromTextThrow(XomwEnv xomwEnv, byte[] byArray, int n) {
        byte[] byArray2 = byArray;
        XomwTitle xomwTitle = new XomwTitle(xomwEnv);
        xomwTitle.mDbkeyform = XophpString.strtr(byArray2, (byte)32, (byte)95);
        xomwTitle.mDefaultNamespace = n;
        xomwTitle.secureAndSplit(xomwEnv);
        return xomwTitle;
    }

    public static XomwTitle newMainPage(XomwEnv xomwEnv) {
        XomwTitle xomwTitle = XomwTitle.newFromText(xomwEnv, XomwGlobalFunctions.wfMessage(xomwEnv, "mainpage").inContentLanguage().text());
        if (xomwTitle == null) {
            xomwTitle = XomwTitle.newFromText(xomwEnv, Bry_.new_a7("Main Page"));
        }
        return xomwTitle;
    }

    public boolean isExternal() {
        return this.mInterwiki != Bry_.Empty;
    }

    public byte[] getInterwiki() {
        return this.mInterwiki;
    }

    public boolean wasLocalInterwiki() {
        return this.mLocalInterwiki;
    }

    public byte[] getText() {
        return this.mTextform;
    }

    public byte[] getPartialURL() {
        return this.mUrlform;
    }

    public byte[] getDBkey() {
        return this.mDbkeyform;
    }

    public byte[] getUserCaseDBKey() {
        if (this.mUserCaseDBKey != null) {
            return this.mUserCaseDBKey;
        }
        return this.mDbkeyform;
    }

    public int getNamespace() {
        return this.mNamespace;
    }

    public byte[] getNsText() {
        if (this.isExternal()) {
            // empty if block
        }
        XomwMediaWikiTitleCodec xomwMediaWikiTitleCodec = this.env.MediaWikiServices().getTitleFormatter();
        return xomwMediaWikiTitleCodec.getNamespaceName(this.mNamespace, this.mDbkeyform);
    }

    public int getDefaultNamespace() {
        return this.mDefaultNamespace;
    }

    public byte[] getFragment() {
        return this.mFragment;
    }

    public boolean hasFragment() {
        return this.mFragment != Bry_.Empty;
    }

    public XomwTitle createFragmentTarget(byte[] byArray) {
        return null;
    }

    private byte[] prefix(byte[] byArray) {
        byte[] byArray2 = Bry_.Empty;
        if (0 != this.mNamespace) {
            byArray2 = Bry_.Add(byArray2, this.getNsText(), Byte_ascii.Colon_bry);
        }
        return Bry_.Add(byArray2, byArray);
    }

    public byte[] getPrefixedDBkey() {
        byte[] byArray = this.prefix(this.mDbkeyform);
        byArray = XophpString.strtr(byArray, (byte)32, (byte)95);
        return byArray;
    }

    public byte[] getPrefixedText() {
        if (this.mPrefixedText == null) {
            byte[] byArray = this.prefix(this.mTextform);
            byArray = XophpString.strtr(byArray, (byte)95, (byte)32);
            this.mPrefixedText = byArray;
        }
        return this.mPrefixedText;
    }

    public byte[] getLocalURL(byte[] byArray) {
        return this.getLocalURL(byArray, null);
    }

    public byte[] getLocalURL(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        byte[] byArray4 = this.getPrefixedDBkey();
        byArray3 = Bry_.Add(Bry__wgArticlePath__wiki, byArray4);
        return byArray3;
    }

    public byte[] getLinkURL(Object object, boolean bl, boolean bl2) {
        return Bry_.Add(Xoh_href_.Bry__wiki, this.getPrefixedText());
    }

    private boolean secureAndSplit(XomwEnv xomwEnv) {
        this.mInterwiki = Bry_.Empty;
        this.mFragment = Bry_.Empty;
        this.mNamespace = this.mDefaultNamespace;
        byte[] byArray = this.mDbkeyform;
        XomwMediaWikiTitleCodec xomwMediaWikiTitleCodec = xomwEnv.MediaWikiServices().getTitleParser();
        XomwMediaWikiTitleCodecParts xomwMediaWikiTitleCodecParts = xomwMediaWikiTitleCodec.splitTitleString(byArray, this.getDefaultNamespace());
        this.mInterwiki = xomwMediaWikiTitleCodecParts.interwiki;
        this.mLocalInterwiki = xomwMediaWikiTitleCodecParts.local_interwiki;
        this.mNamespace = xomwMediaWikiTitleCodecParts.ns;
        this.mUserCaseDBKey = xomwMediaWikiTitleCodecParts.user_case_dbkey;
        this.mDbkeyform = xomwMediaWikiTitleCodecParts.dbkey;
        this.mUrlform = XomwGlobalFunctions.wfUrlencode(this.mDbkeyform);
        this.mTextform = XophpString.strtr(this.mDbkeyform, (byte)95, (byte)32);
        if (this.isExternal() || this.mNamespace == -1) {
            this.mArticleID = 0;
        }
        return true;
    }

    public boolean equals(XomwTitle xomwTitle) {
        return Bry_.Eq(this.getInterwiki(), xomwTitle.getInterwiki()) && this.getNamespace() == xomwTitle.getNamespace() && Bry_.Eq(this.getDBkey(), xomwTitle.getDBkey());
    }

    public boolean isAlwaysKnown() {
        return false;
    }

    public boolean isKnown() {
        return true;
    }

    public static int Find_fwd_while_title(byte[] byArray, int n, int n2, boolean[] blArray) {
        int n3 = n;
        while (n3 != n2) {
            byte by = byArray[n3];
            int n4 = Utf8_.Len_of_char_by_1st_byte(by);
            if (n4 == 1) {
                if (!blArray[by & 0xFF]) break;
                ++n3;
                continue;
            }
            n3 += n4;
        }
        return n3;
    }

    public static boolean[] Title_chars_valid() {
        if (title_chars_valid == null) {
            int n;
            title_chars_valid = new boolean[128];
            for (n = 48; n <= 57; ++n) {
                XomwTitle.title_chars_valid[n] = true;
            }
            for (n = 65; n <= 90; ++n) {
                XomwTitle.title_chars_valid[n] = true;
            }
            for (n = 97; n <= 122; ++n) {
                XomwTitle.title_chars_valid[n] = true;
            }
            byte[] byArray = new byte[]{32, 37, 33, 34, 38, 39, 40, 41, 42, 44, 45, 46, 47, 58, 59, 61, 63, 64, 92, 94, 95, 96, 126, 43};
            int n2 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                XomwTitle.title_chars_valid[byArray[i]] = true;
            }
        }
        return title_chars_valid;
    }
}

