/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.htmls.core.htmls.tidy.vnus;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DepurateSerializer
implements ContentHandler,
LexicalHandler {
    private static final String[] VOID_ELEMENTS = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "command", "embed", "frame", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"};
    private static final String[] NON_ESCAPING = new String[]{"iframe", "noembed", "noframes", "noscript", "plaintext", "script", "style", "xmp"};
    private int ignoreLevel = 0;
    private int escapeLevel = 0;
    private OutputStream outputStream;
    private Writer writer;

    private static Writer wrap(OutputStream outputStream) {
        try {
            return new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public DepurateSerializer(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.writer = DepurateSerializer.wrap(outputStream);
    }

    public OutputStream getOutputStream() throws SAXException {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) throws RuntimeException {
        this.outputStream = outputStream;
        this.writer = DepurateSerializer.wrap(outputStream);
    }

    public void write(String string) throws SAXException {
        try {
            this.writer.write(string);
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void writeStream(ByteArrayOutputStream byteArrayOutputStream) throws SAXException {
        try {
            this.writer.flush();
            byteArrayOutputStream.writeTo(this.outputStream);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.escapeLevel > 0) {
                this.writer.write(cArray, n, n2);
            } else {
                block8: for (int i = n; i < n + n2; ++i) {
                    char c = cArray[i];
                    switch (c) {
                        case '<': {
                            this.writer.write("&lt;");
                            continue block8;
                        }
                        case '>': {
                            this.writer.write("&gt;");
                            continue block8;
                        }
                        case '&': {
                            this.writer.write("&amp;");
                            continue block8;
                        }
                        case '\u00a0': {
                            this.writer.write("&#160;");
                            continue block8;
                        }
                        default: {
                            this.writer.write(c);
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.escapeLevel > 0) {
            --this.escapeLevel;
        }
        if (this.ignoreLevel > 0) {
            --this.ignoreLevel;
        } else {
            try {
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(string2);
                this.writer.write(62);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.writer.write("<!DOCTYPE html>\n");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.escapeLevel > 0) {
            ++this.escapeLevel;
        }
        boolean bl = "http://www.w3.org/1999/xhtml".equals(string);
        if (this.ignoreLevel > 0 || !bl && !"http://www.w3.org/2000/svg".equals(string) && !"http://www.w3.org/1998/Math/MathML".equals(string)) {
            ++this.ignoreLevel;
            return;
        }
        try {
            this.writer.write(60);
            this.writer.write(string2);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getURI(i);
                String string5 = attributes.getLocalName(i);
                if (string4.length() == 0) {
                    this.writer.write(32);
                } else if (!bl && "http://www.w3.org/1999/xlink".equals(string4)) {
                    this.writer.write(" xlink:");
                } else {
                    if (!"http://www.w3.org/XML/1998/namespace".equals(string4)) continue;
                    if (bl) {
                        if (!"lang".equals(string5)) continue;
                        this.writer.write(32);
                    } else {
                        this.writer.write(" xml:");
                    }
                }
                this.writer.write(attributes.getLocalName(i));
                this.writer.write(61);
                this.writer.write(34);
                String string6 = attributes.getValue(i);
                block8: for (int j = 0; j < string6.length(); ++j) {
                    char c = string6.charAt(j);
                    switch (c) {
                        case '\"': {
                            this.writer.write("&quot;");
                            continue block8;
                        }
                        case '&': {
                            this.writer.write("&amp;");
                            continue block8;
                        }
                        case '\u00a0': {
                            this.writer.write("&nbsp;");
                            continue block8;
                        }
                        default: {
                            this.writer.write(c);
                        }
                    }
                }
                this.writer.write(34);
            }
            if (Arrays.binarySearch(VOID_ELEMENTS, string2) > -1) {
                this.writer.write(" />");
                ++this.ignoreLevel;
                return;
            }
            this.writer.write(62);
            if ("pre".equals(string2) || "textarea".equals(string2) || "listing".equals(string2)) {
                this.writer.write(10);
            }
            if (this.escapeLevel == 0 && Arrays.binarySearch(NON_ESCAPING, string2) > -1) {
                this.escapeLevel = 1;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreLevel > 0 || this.escapeLevel > 0) {
            return;
        }
        try {
            this.writer.write("<!--");
            this.writer.write(cArray, n, n2);
            this.writer.write("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }
}

