/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.htmls.core.htmls.tidy.vnus;

import gplx.xowa.htmls.core.htmls.tidy.vnus.DepurateSerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class CompatibilitySerializer
implements ContentHandler,
LexicalHandler {
    protected Stack<StackEntry> m_stack = new Stack();
    protected DepurateSerializer m_serializer;
    protected Stack<StackEntry> m_pStack = new Stack();
    protected static final String[] ONLY_INLINE_ELEMENTS = new String[]{"a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "dfn", "em", "font", "i", "iframe", "img", "input", "kbd", "label", "legend", "map", "object", "param", "q", "rb", "rbc", "rp", "rt", "rtc", "ruby", "s", "samp", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"};
    protected static final String[] MARKED_EMPTY_ELEMENTS = new String[]{"li", "p", "tr"};

    public CompatibilitySerializer(OutputStream outputStream) {
        this.m_serializer = new DepurateSerializer(outputStream);
    }

    private StackEntry peek(Stack<StackEntry> stack) throws SAXException {
        try {
            return stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private ByteArrayOutputStream popAndGetContents() throws SAXException {
        try {
            StackEntry stackEntry = this.m_stack.pop();
            if (stackEntry.isPWrapper) {
                this.m_pStack.pop();
            }
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.m_serializer.getOutputStream();
            this.m_serializer.setOutputStream(stackEntry.savedStream);
            return byteArrayOutputStream;
        }
        catch (EmptyStackException emptyStackException) {
            throw new SAXException(emptyStackException);
        }
    }

    private StackEntry push(String string, String string2, String string3, Attributes attributes) throws SAXException {
        StackEntry stackEntry = new StackEntry(string, string2, string3, attributes, this.m_serializer.getOutputStream());
        this.m_stack.push(stackEntry);
        this.m_serializer.setOutputStream(new ByteArrayOutputStream());
        return stackEntry;
    }

    private StackEntry pushPWrapper() throws SAXException {
        StackEntry stackEntry = this.push("", "mw:p-wrap", "mw:p-wrap", new AttributesImpl());
        this.m_pStack.push(stackEntry);
        return stackEntry;
    }

    private void writePWrapper(StackEntry stackEntry, ByteArrayOutputStream byteArrayOutputStream) throws SAXException {
        if (!stackEntry.isDisabledPWrapper && !stackEntry.blank) {
            this.m_serializer.write("<p>");
            this.m_serializer.writeStream(byteArrayOutputStream);
            this.m_serializer.write("</p>");
        } else {
            this.m_serializer.writeStream(byteArrayOutputStream);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        StackEntry stackEntry = this.peek(this.m_stack);
        if (stackEntry != null) {
            if (stackEntry.needsPWrapping) {
                stackEntry = this.pushPWrapper();
            }
            if (stackEntry.blank || !stackEntry.hasText) {
                for (int i = n; i < n + n2; ++i) {
                    char c = cArray[i];
                    if (c == '\t' || c == '\n' || c == '\f' || c == '\r' || c == ' ') continue;
                    stackEntry.blank = false;
                    stackEntry.hasText = true;
                    if (this.peek(this.m_pStack) == null) break;
                    this.peek(this.m_pStack).blank = false;
                    break;
                }
            }
        }
        this.m_serializer.characters(cArray, n, n2);
    }

    private void splitTagStack(boolean bl) throws SAXException {
        ByteArrayOutputStream byteArrayOutputStream;
        StackEntry stackEntry = this.peek(this.m_pStack);
        int n = this.m_stack.size();
        int n2 = n - 1;
        StackEntry stackEntry2 = (StackEntry)this.m_stack.get(n2);
        while (stackEntry2 != stackEntry) {
            byteArrayOutputStream = (ByteArrayOutputStream)this.m_serializer.getOutputStream();
            this.m_serializer.setOutputStream(stackEntry2.savedStream);
            if (stackEntry2.hasText) {
                bl = true;
            }
            if (bl) {
                this.m_serializer.startElement(stackEntry2.uri, stackEntry2.localName, stackEntry2.qName, stackEntry2.attrs);
                this.m_serializer.writeStream(byteArrayOutputStream);
                this.m_serializer.endElement(stackEntry2.uri, stackEntry2.localName, stackEntry2.qName);
                stackEntry2.split = true;
                stackEntry2.blank = true;
                stackEntry2.hasText = false;
            }
            stackEntry2.savedStream = new ByteArrayOutputStream();
            stackEntry2 = (StackEntry)this.m_stack.get(--n2);
        }
        if (bl || stackEntry2.hasText) {
            byteArrayOutputStream = (ByteArrayOutputStream)this.m_serializer.getOutputStream();
            this.m_serializer.setOutputStream(stackEntry2.savedStream);
            this.writePWrapper(stackEntry2, byteArrayOutputStream);
            stackEntry2.blank = true;
        }
        this.m_serializer.setOutputStream(new ByteArrayOutputStream());
    }

    private boolean isOnlyInline(String string) {
        return Arrays.binarySearch(ONLY_INLINE_ELEMENTS, string) > -1;
    }

    private void enterBlock(String string) throws SAXException {
        StackEntry stackEntry = this.peek(this.m_pStack);
        if (stackEntry.blockNestingLevel == 0) {
            this.splitTagStack(false);
        }
        ++stackEntry.blockNestingLevel;
        stackEntry.isDisabledPWrapper = true;
    }

    private void leaveBlock(String string) throws SAXException {
        StackEntry stackEntry = this.peek(this.m_pStack);
        --stackEntry.blockNestingLevel;
        if (stackEntry.blockNestingLevel == 0) {
            this.splitTagStack(true);
        }
        stackEntry.isDisabledPWrapper = false;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        StackEntry stackEntry = this.peek(this.m_stack);
        if (stackEntry != null) {
            if (stackEntry.isPWrapper) {
                if (!this.isOnlyInline(string2)) {
                    ByteArrayOutputStream byteArrayOutputStream = this.popAndGetContents();
                    this.writePWrapper(stackEntry, byteArrayOutputStream);
                    stackEntry = this.peek(this.m_stack);
                } else {
                    stackEntry.blank = false;
                }
            } else {
                stackEntry.blank = false;
            }
        }
        boolean bl = this.isOnlyInline(string2);
        StackEntry stackEntry2 = this.peek(this.m_pStack);
        if (stackEntry2 != null && !bl) {
            this.enterBlock(string2);
        }
        if (stackEntry != null && stackEntry.needsPWrapping && bl) {
            StackEntry stackEntry3 = this.pushPWrapper();
            stackEntry3.blank = false;
        }
        this.push(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        StackEntry stackEntry = this.peek(this.m_stack);
        ByteArrayOutputStream byteArrayOutputStream = this.popAndGetContents();
        if (stackEntry.isPWrapper) {
            this.writePWrapper(stackEntry, byteArrayOutputStream);
            stackEntry = this.peek(this.m_stack);
            byteArrayOutputStream = this.popAndGetContents();
        }
        if (Arrays.binarySearch(MARKED_EMPTY_ELEMENTS, string2) > -1 && stackEntry.attrs.getLength() == 0 && stackEntry.blank) {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "class", "class", "", "mw-empty-elt");
            stackEntry.attrs = attributesImpl;
        }
        if (!stackEntry.split || !stackEntry.blank) {
            this.m_serializer.startElement(stackEntry.uri, stackEntry.localName, stackEntry.qName, stackEntry.attrs);
            this.m_serializer.writeStream(byteArrayOutputStream);
            this.m_serializer.endElement(string, string2, string3);
        }
        boolean bl = this.isOnlyInline(string2);
        StackEntry stackEntry2 = this.peek(this.m_pStack);
        if (stackEntry2 != null && !bl) {
            this.leaveBlock(string2);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_serializer.endDocument();
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.m_serializer.comment(cArray, n, n2);
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    protected class StackEntry {
        public String uri;
        public String localName;
        public String qName;
        public Attributes attrs;
        OutputStream savedStream;
        public boolean needsPWrapping;
        public boolean isPWrapper;
        public boolean blank;
        public boolean hasText;
        public boolean split;
        public int blockNestingLevel;
        public boolean isDisabledPWrapper;

        public StackEntry(String string, String string2, String string3, Attributes attributes, OutputStream outputStream) {
            this.uri = string;
            this.localName = string2;
            this.qName = string3;
            this.attrs = attributes;
            this.savedStream = outputStream;
            this.needsPWrapping = "body".equals(string2) || "blockquote".equals(string2);
            this.blank = true;
            this.hasText = false;
            this.isPWrapper = "mw:p-wrap".equals(string2);
            this.blockNestingLevel = 0;
            this.isDisabledPWrapper = false;
            this.split = false;
        }
    }
}

