/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.files.caches;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.DateAdp_;
import gplx.Datetime_now;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Internal;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Keyval;
import gplx.Keyval_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.core.ios.Io_size_;
import gplx.dbs.Db_conn;
import gplx.dbs.cfgs.Db_cfg_tbl;
import gplx.xowa.Xoa_app;
import gplx.xowa.Xoa_app_;
import gplx.xowa.Xow_wiki;
import gplx.xowa.files.Xof_ext;
import gplx.xowa.files.Xof_fsdb_itm;
import gplx.xowa.files.Xof_lnki_time;
import gplx.xowa.files.Xof_url_bldr;
import gplx.xowa.files.caches.Xou_cache_grp;
import gplx.xowa.files.caches.Xou_cache_grp_sorter;
import gplx.xowa.files.caches.Xou_cache_itm;
import gplx.xowa.files.caches.Xou_cache_tbl;
import gplx.xowa.files.repos.Xof_repo_itm;
import gplx.xowa.users.data.Xou_db_file;
import gplx.xowa.wikis.Xoa_wiki_mgr;
import gplx.xowa.wikis.domains.Xow_abrv_xo_;

public class Xou_cache_mgr
implements Gfo_invk {
    private long fsys_size_cur = 0L;
    private long fsys_size_min = 0x4B00000L;
    private long fsys_size_max = 0x6400000L;
    private final Xoa_wiki_mgr wiki_mgr;
    private final Xou_cache_tbl cache_tbl;
    private final Db_cfg_tbl cfg_tbl;
    private final Bry_bfr tmp_bfr = Bry_bfr_.Reset(512);
    private final Ordered_hash hash = Ordered_hash_.New_bry();
    private final Xof_url_bldr url_bldr = Xof_url_bldr.new_v2();
    private final Object thread_lock = new Object();
    private final Io_url cache_dir;
    private boolean db_load_needed = true;
    private boolean enabled = true;
    private static final String Cfg__fsys_size_min = "xowa.files.cache.fsys_size_min";
    private static final String Cfg__fsys_size_max = "xowa.files.cache.fsys_size_max";
    private static final String Run__fsys_reduce_to_min = "xowa.files.cache.reduce_to_min";
    private static final String Run__fsys_clear = "xowa.files.cache.clear";
    private static final String Val__fsys_info = "xowa.files.cache.info";

    public Xou_cache_mgr(Xoa_wiki_mgr xoa_wiki_mgr, Io_url io_url, Xou_db_file xou_db_file) {
        this.wiki_mgr = xoa_wiki_mgr;
        this.cache_dir = io_url;
        this.cfg_tbl = xou_db_file.Tbl__cfg();
        this.cache_tbl = xou_db_file.Tbl__cache();
    }

    public boolean Enabled() {
        return this.enabled;
    }

    public void Enabled_n_() {
        this.enabled = false;
    }

    public void Init_by_app(Xoa_app xoa_app) {
        xoa_app.Cfg().Bind_many_app(this, Cfg__fsys_size_min, Cfg__fsys_size_max);
        xoa_app.Cfg().Sub_many_app(this, Run__fsys_reduce_to_min, Run__fsys_clear);
        xoa_app.Cfg().Dflt_mgr().Add(this, Val__fsys_info);
    }

    public Xou_cache_itm Get_or_null(Xof_fsdb_itm xof_fsdb_itm) {
        return this.Get_or_null(xof_fsdb_itm.Lnki_wiki_abrv(), xof_fsdb_itm.Lnki_ttl(), xof_fsdb_itm.Lnki_type(), xof_fsdb_itm.Lnki_upright(), xof_fsdb_itm.Lnki_w(), xof_fsdb_itm.Lnki_h(), xof_fsdb_itm.Lnki_time(), xof_fsdb_itm.Lnki_page(), xof_fsdb_itm.User_thumb_w());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xou_cache_itm Get_or_null(byte[] byArray, byte[] byArray2, int n, double d, int n2, int n3, double d2, int n4, int n5) {
        if (!this.enabled) {
            return null;
        }
        Object object = this.thread_lock;
        synchronized (object) {
            this.Page_bgn();
            byte[] byArray3 = Xou_cache_itm.Key_gen(this.tmp_bfr, byArray, byArray2, n, d, n2, n3, d2, n4, n5);
            Xou_cache_itm xou_cache_itm = (Xou_cache_itm)this.hash.Get_by(byArray3);
            if (xou_cache_itm == Xou_cache_itm.Null) {
                xou_cache_itm = this.cache_tbl.Select_one(byArray, byArray2, n, d, n2, n3, d2, n4, n5);
                if (xou_cache_itm == Xou_cache_itm.Null) {
                    return Xou_cache_itm.Null;
                }
                this.hash.Add(byArray3, xou_cache_itm);
            }
            return xou_cache_itm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Update(Xof_fsdb_itm xof_fsdb_itm) {
        Object object = this.thread_lock;
        synchronized (object) {
            Xou_cache_itm xou_cache_itm = this.Get_or_null(xof_fsdb_itm.Lnki_wiki_abrv(), xof_fsdb_itm.Lnki_ttl(), xof_fsdb_itm.Lnki_type(), xof_fsdb_itm.Lnki_upright(), xof_fsdb_itm.Lnki_w(), xof_fsdb_itm.Lnki_h(), xof_fsdb_itm.Lnki_time(), xof_fsdb_itm.Lnki_page(), xof_fsdb_itm.User_thumb_w());
            if (xou_cache_itm == Xou_cache_itm.Null) {
                xou_cache_itm = new Xou_cache_itm(this.tmp_bfr, 1, xof_fsdb_itm.Lnki_wiki_abrv(), xof_fsdb_itm.Lnki_ttl(), xof_fsdb_itm.Lnki_type(), xof_fsdb_itm.Lnki_upright(), xof_fsdb_itm.Lnki_w(), xof_fsdb_itm.Lnki_h(), xof_fsdb_itm.Lnki_time(), xof_fsdb_itm.Lnki_page(), xof_fsdb_itm.User_thumb_w(), xof_fsdb_itm.Orig_repo_id(), xof_fsdb_itm.Orig_ttl(), xof_fsdb_itm.Orig_ext().Id(), xof_fsdb_itm.Orig_w(), xof_fsdb_itm.Orig_h(), xof_fsdb_itm.Html_w(), xof_fsdb_itm.Html_h(), xof_fsdb_itm.Lnki_time(), xof_fsdb_itm.Lnki_page(), xof_fsdb_itm.File_is_orig(), xof_fsdb_itm.File_w(), xof_fsdb_itm.Lnki_time(), xof_fsdb_itm.Lnki_page(), xof_fsdb_itm.File_size(), 1, Datetime_now.Get().Timestamp_unix());
                this.hash.Add(xou_cache_itm.Lnki_key(), xou_cache_itm);
                this.fsys_size_cur += xou_cache_itm.File_size();
            } else {
                xou_cache_itm.Update_view_stats();
            }
        }
    }

    public void Page_bgn() {
        if (this.db_load_needed) {
            this.db_load_needed = false;
            this.fsys_size_cur = this.cfg_tbl.Assert_long("user.file_cache", "size_sum", 0L);
            this.cache_tbl.Select_all(this.tmp_bfr, this.hash);
        }
    }

    public void Page_end(Xoa_wiki_mgr xoa_wiki_mgr) {
        this.cfg_tbl.Update_long("user.file_cache", "size_sum", this.fsys_size_cur);
        this.Db_save();
        if (this.fsys_size_cur > this.fsys_size_max) {
            this.Reduce(this.fsys_size_min);
        }
    }

    @Internal
    protected void Clear() {
        this.db_load_needed = true;
        this.fsys_size_cur = 0L;
        this.hash.Clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Db_save() {
        Object object = this.thread_lock;
        synchronized (object) {
            Db_conn db_conn = this.cache_tbl.Conn();
            try {
                db_conn.Txn_bgn("user__file_cache__save");
                int n = this.hash.Count();
                for (int i = 0; i < n; ++i) {
                    Xou_cache_itm xou_cache_itm = (Xou_cache_itm)this.hash.Get_at(i);
                    this.cache_tbl.Db_save(xou_cache_itm);
                }
                db_conn.Txn_end();
            }
            catch (Exception exception) {
                db_conn.Txn_cxl();
                throw Err_.new_exc(exception, "cache", "unknown error while saving cache; err=~{0}", Err_.Message_gplx_log(exception));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Reduce(long l) {
        Xoa_app_.Usr_dlg().Note_many("", "", "cache compress started", new Object[0]);
        Object object = this.thread_lock;
        synchronized (object) {
            try {
                this.Db_save();
                this.cache_tbl.Select_all(this.tmp_bfr, this.hash);
                Ordered_hash ordered_hash = Ordered_hash_.New();
                int n = this.hash.Count();
                for (int i = 0; i < n; ++i) {
                    Xou_cache_itm xou_cache_itm = (Xou_cache_itm)this.hash.Get_at(i);
                    Io_url io_url = this.Calc_url(xou_cache_itm);
                    xou_cache_itm.File_url_(io_url);
                    Xou_cache_grp xou_cache_grp = (Xou_cache_grp)ordered_hash.Get_by(io_url.Raw());
                    if (xou_cache_grp == null) {
                        xou_cache_grp = new Xou_cache_grp(io_url);
                        ordered_hash.Add(io_url.Raw(), xou_cache_grp);
                    }
                    xou_cache_grp.Add(xou_cache_itm);
                }
                ordered_hash.Sort_by(Xou_cache_grp_sorter.Instance);
                n = ordered_hash.Count();
                long l2 = 0L;
                long l3 = 0L;
                List_adp list_adp = List_adp_.New();
                for (int i = 0; i < n; ++i) {
                    Xou_cache_grp xou_cache_grp = (Xou_cache_grp)ordered_hash.Get_at(i);
                    l3 = l2 + xou_cache_grp.File_size();
                    if (l3 > l || l3 == -1L) {
                        list_adp.Add(xou_cache_grp);
                        continue;
                    }
                    l2 = l3;
                }
                n = list_adp.Count();
                Db_conn db_conn = this.cache_tbl.Conn();
                db_conn.Txn_bgn("user__file_cache__delete");
                for (int i = 0; i < n; ++i) {
                    Xou_cache_grp xou_cache_grp = (Xou_cache_grp)list_adp.Get_at(i);
                    xou_cache_grp.Delete(this.hash, this.cache_tbl);
                    this.fsys_size_cur -= xou_cache_grp.File_size();
                }
                db_conn.Txn_end();
                Io_mgr.Instance.Delete_dir_empty(this.cache_dir);
            }
            catch (Exception exception) {
                Xoa_app_.Usr_dlg().Warn_many("", "", "failed to compress cache: err=~{0}", Err_.Message_gplx_full(exception));
                return;
            }
        }
        Xoa_app_.Usr_dlg().Note_many("", "", "cache compress done", new Object[0]);
    }

    private Io_url Calc_url(Xou_cache_itm xou_cache_itm) {
        byte[] byArray = Xow_abrv_xo_.To_itm(xou_cache_itm.Lnki_wiki_abrv()).Domain_bry();
        Xow_wiki xow_wiki = this.wiki_mgr.Get_by_or_make_init_y(byArray);
        if (xow_wiki == null) {
            return Io_url_.Empty;
        }
        Xof_repo_itm xof_repo_itm = xow_wiki.File__repo_mgr().Get_trg_by_id_or_null(xou_cache_itm.Orig_repo_id(), xou_cache_itm.Lnki_ttl(), Bry_.Empty);
        if (xof_repo_itm == null) {
            return Io_url_.Empty;
        }
        byte[] byArray2 = xou_cache_itm.Orig_ttl();
        byte[] byArray3 = xou_cache_itm.Orig_ttl_md5();
        Xof_ext xof_ext = xou_cache_itm.Orig_ext_itm();
        byArray2 = xof_repo_itm.Gen_name_trg(this.tmp_bfr, byArray2, byArray3, xof_ext);
        byte by = xou_cache_itm.File_is_orig() ? (byte)0 : 1;
        return this.url_bldr.Init_for_trg_file(xof_repo_itm, by, byArray2, byArray3, xof_ext, xou_cache_itm.File_w(), Xof_lnki_time.Convert_to_xowa_thumbtime(xof_ext.Id(), xou_cache_itm.File_time()), Xof_lnki_time.Convert_to_xowa_page(xof_ext.Id(), xou_cache_itm.File_page())).Xto_url();
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Cfg__fsys_size_min)) {
            this.fsys_size_min = gfoMsg.ReadLong("v") * 0x100000L;
        } else if (gfsCtx.Match(string, Cfg__fsys_size_max)) {
            this.fsys_size_max = gfoMsg.ReadLong("v") * 0x100000L;
        } else {
            if (gfsCtx.Match(string, Val__fsys_info)) {
                return this.Info_str();
            }
            if (gfsCtx.Match(string, Run__fsys_reduce_to_min)) {
                this.Reduce(this.fsys_size_min);
            } else if (gfsCtx.Match(string, Run__fsys_clear)) {
                this.Reduce(0L);
            } else {
                return Gfo_invk_.Rv_unhandled;
            }
        }
        return this;
    }

    public void Fsys_size_(long l, long l2) {
        this.fsys_size_min = l;
        this.fsys_size_max = l2;
    }

    private String Info_str() {
        this.Page_bgn();
        Bry_bfr bry_bfr = Bry_bfr_.New_w_size(255);
        for (Keyval keyval : this.Info_kvs()) {
            bry_bfr.Add_str_a7(keyval.Key()).Add_str_a7(": ").Add_str_u8(keyval.Val_to_str_or_empty()).Add_byte_nl();
        }
        return bry_bfr.To_str_and_clear();
    }

    private Keyval[] Info_kvs() {
        long l = Long.MAX_VALUE;
        long l2 = 0L;
        int n = this.hash.Count();
        for (int i = 0; i < n; ++i) {
            Xou_cache_itm xou_cache_itm = (Xou_cache_itm)this.hash.Get_at(i);
            l2 += xou_cache_itm.File_size();
            if (xou_cache_itm.View_date() >= l) continue;
            l = xou_cache_itm.View_date();
        }
        return Keyval_.Ary(Keyval_.new_("cache folder", this.cache_dir.Xto_api()), Keyval_.new_("space used", Io_size_.To_str(l2)), Keyval_.new_("file count", n), Keyval_.new_("oldest file", l == Long.MAX_VALUE ? "" : DateAdp_.unixtime_utc_seconds_(l).XtoStr_fmt_iso_8561()));
    }
}

