/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.files.caches;

import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.Gfo_usr_dlg;
import gplx.GfsCtx;
import gplx.Io_mgr;
import gplx.core.envs.Env_;
import gplx.core.primitives.Bool_obj_ref;
import gplx.dbs.Db_conn;
import gplx.xowa.files.Xoa_repo_mgr;
import gplx.xowa.files.Xof_ext;
import gplx.xowa.files.Xof_fsdb_itm;
import gplx.xowa.files.caches.Xofc_cfg_mgr;
import gplx.xowa.files.caches.Xofc_dir_mgr;
import gplx.xowa.files.caches.Xofc_fil_itm;
import gplx.xowa.files.caches.Xofc_fil_mgr;
import gplx.xowa.wikis.Xoae_wiki_mgr;

public class Xof_cache_mgr
implements Gfo_invk {
    private final Gfo_usr_dlg usr_dlg;
    private final Xoae_wiki_mgr wiki_mgr;
    private final Xoa_repo_mgr repo_mgr;
    private final Xofc_cfg_mgr cfg_mgr = new Xofc_cfg_mgr();
    private final Xofc_dir_mgr dir_mgr;
    private final Xofc_fil_mgr fil_mgr;
    private final Bool_obj_ref fil_created = Bool_obj_ref.n_();
    private static final String Invk_cache_min = "cache_min";
    private static final String Invk_cache_min_ = "cache_min_";
    private static final String Invk_cache_max = "cache_max";
    private static final String Invk_cache_max_ = "cache_max_";
    private static final String Invk_cache_compress = "cache_compress";

    public Xof_cache_mgr(Gfo_usr_dlg gfo_usr_dlg, Xoae_wiki_mgr xoae_wiki_mgr, Xoa_repo_mgr xoa_repo_mgr) {
        this.usr_dlg = gfo_usr_dlg;
        this.wiki_mgr = xoae_wiki_mgr;
        this.repo_mgr = xoa_repo_mgr;
        this.dir_mgr = new Xofc_dir_mgr(this);
        this.fil_mgr = new Xofc_fil_mgr(this);
    }

    public int Next_id() {
        return this.cfg_mgr.Next_id();
    }

    public void Next_id_(int n) {
        this.cfg_mgr.Next_id_(n);
    }

    public void Init_for_db(Db_conn db_conn, boolean bl, boolean bl2) {
        this.cfg_mgr.Conn_(db_conn, bl, bl2);
        this.dir_mgr.Conn_(db_conn, bl, bl2);
        this.fil_mgr.Conn_(db_conn, bl, bl2);
    }

    public void Db_save() {
        try {
            this.dir_mgr.Save_all();
            this.fil_mgr.Save_all();
            this.cfg_mgr.Save_all();
        }
        catch (Exception exception) {
            this.usr_dlg.Warn_many("", "", "cache_mgr.save:fatal error: err=~{0}", Err_.Message_gplx_full(exception));
        }
    }

    public void Db_term() {
        try {
            this.cfg_mgr.Cleanup();
            this.dir_mgr.Cleanup();
            this.fil_mgr.Cleanup();
        }
        catch (Exception exception) {
            this.usr_dlg.Warn_many("", "", "cache_mgr.term:fatal error: err=~{0}", Err_.Message_gplx_full(exception));
        }
    }

    public Xofc_fil_itm Reg(Xof_fsdb_itm xof_fsdb_itm, long l) {
        return this.Reg(xof_fsdb_itm.Orig_repo_name(), xof_fsdb_itm.Orig_ttl(), xof_fsdb_itm.File_is_orig(), xof_fsdb_itm.File_w(), xof_fsdb_itm.File_w(), xof_fsdb_itm.Lnki_time(), xof_fsdb_itm.Orig_ext(), l, DateAdp_.MaxValue, "");
    }

    private Xofc_fil_itm Reg(byte[] byArray, byte[] byArray2, boolean bl, int n, int n2, double d, Xof_ext xof_ext, long l, DateAdp dateAdp, String string) {
        int n3 = this.dir_mgr.Get_by_name_or_make(byArray).Id();
        Xofc_fil_itm xofc_fil_itm = this.fil_mgr.Get_or_make(n3, byArray2, bl, n, n2, d, xof_ext, l, this.fil_created.Val_n_());
        xofc_fil_itm.Cache_time_now_();
        if (this.fil_created.Val()) {
            this.cfg_mgr.Cache_len_add(l);
        }
        return xofc_fil_itm;
    }

    public void Reg_and_check_for_size_0(Xof_fsdb_itm xof_fsdb_itm) {
        if (Env_.Mode_testing()) {
            return;
        }
        Xofc_fil_itm xofc_fil_itm = this.Reg(xof_fsdb_itm, 0L);
        if (xofc_fil_itm.Size() == 0L) {
            long l = Io_mgr.Instance.QueryFil(xof_fsdb_itm.Html_view_url()).Size();
            xofc_fil_itm.Size_(l);
        }
    }

    public void Compress_check() {
        if (this.cfg_mgr.Cache_len() > this.cfg_mgr.Cache_max()) {
            this.fil_mgr.Compress(this.usr_dlg, this.wiki_mgr, this.repo_mgr, this.dir_mgr, this.cfg_mgr);
        }
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_cache_min)) {
            return this.cfg_mgr.Cache_min() / 0x100000L;
        }
        if (gfsCtx.Match(string, Invk_cache_min_)) {
            this.cfg_mgr.Cache_min_(gfoMsg.ReadLong("v") * 0x100000L);
        } else {
            if (gfsCtx.Match(string, Invk_cache_max)) {
                return this.cfg_mgr.Cache_max() / 0x100000L;
            }
            if (gfsCtx.Match(string, Invk_cache_max_)) {
                this.cfg_mgr.Cache_max_(gfoMsg.ReadLong("v") * 0x100000L);
            } else if (gfsCtx.Match(string, Invk_cache_compress)) {
                this.fil_mgr.Compress(this.usr_dlg, this.wiki_mgr, this.repo_mgr, this.dir_mgr, this.cfg_mgr);
            } else {
                return Gfo_invk_.Rv_unhandled;
            }
        }
        return this;
    }
}

