/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.bldrs.cmds;

import gplx.Bry_;
import gplx.Datetime_now;
import gplx.Decimal_adp_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Io_url;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.core.envs.System_;
import gplx.dbs.Db_conn;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.Xowe_wiki_;
import gplx.xowa.addons.bldrs.files.utls.Xobu_poll_mgr;
import gplx.xowa.bldrs.Xob_bldr;
import gplx.xowa.bldrs.cmds.Xob_dump_bmk;
import gplx.xowa.bldrs.cmds.Xob_dump_bmk_mgr;
import gplx.xowa.bldrs.cmds.Xob_dump_mgr_base_;
import gplx.xowa.bldrs.cmds.Xob_dump_src_id;
import gplx.xowa.bldrs.cmds.Xob_rate_mgr;
import gplx.xowa.bldrs.wkrs.Xob_cmd;
import gplx.xowa.bldrs.wkrs.Xob_itm_basic_base;
import gplx.xowa.parsers.Xop_ctx;
import gplx.xowa.parsers.Xop_parser;
import gplx.xowa.parsers.Xop_root_tkn;
import gplx.xowa.wikis.data.Xow_db_file;
import gplx.xowa.wikis.data.Xow_db_file__core_;
import gplx.xowa.wikis.data.Xow_db_mgr;
import gplx.xowa.wikis.data.tbls.Xowd_page_itm;
import gplx.xowa.wikis.nss.Xow_ns;

public abstract class Xob_dump_mgr_base
extends Xob_itm_basic_base
implements Xob_cmd,
Gfo_invk {
    private Xob_dump_src_id page_src;
    private Xow_db_mgr db_fsys_mgr;
    protected Xop_parser parser;
    protected Xop_ctx ctx;
    protected Xop_root_tkn root;
    private int[] ns_ary;
    private Xow_db_file[] db_ary;
    private int ns_bgn = -1;
    private int db_bgn = -1;
    private int pg_bgn = -1;
    private int ns_end = -1;
    private int db_end = -1;
    private int pg_end = Integer.MAX_VALUE;
    private int commit_interval = 1000;
    private int progress_interval = 250;
    private int cleanup_interval = 2500;
    private int select_size = 0xA00000;
    private int exec_count;
    private int exec_count_max = Integer.MAX_VALUE;
    private boolean reset_db = false;
    private boolean exit_after_commit = false;
    private boolean exit_now = false;
    private boolean load_tmpls;
    private Xob_dump_bmk_mgr bmk_mgr = new Xob_dump_bmk_mgr();
    private Xobu_poll_mgr poll_mgr;
    private int poll_interval = 5000;
    private Xob_rate_mgr rate_mgr = new Xob_rate_mgr();
    private long time_bgn;
    public static final String Invk_progress_interval_ = "progress_interval_";
    public static final String Invk_commit_interval_ = "commit_interval_";
    public static final String Invk_cleanup_interval_ = "cleanup_interval_";
    public static final String Invk_rate_interval_ = "rate_interval_";
    public static final String Invk_select_size_ = "select_size_";
    public static final String Invk_ns_bgn_ = "ns_bgn_";
    public static final String Invk_db_bgn_ = "db_bgn_";
    public static final String Invk_pg_bgn_ = "pg_bgn_";
    public static final String Invk_ns_end_ = "ns_end_";
    public static final String Invk_db_end_ = "db_end_";
    public static final String Invk_pg_end_ = "pg_end_";
    public static final String Invk_load_tmpls_ = "load_tmpls_";
    public static final String Invk_poll_mgr = "poll_mgr";
    public static final String Invk_reset_db_ = "reset_db_";
    public static final String Invk_exec_count_max_ = "exec_count_max_";
    public static final String Invk_exit_now_ = "exit_now_";
    public static final String Invk_exit_after_commit_ = "exit_after_commit_";
    public static final String Invk__manual_now_ = "manual_now_";

    @Override
    public abstract String Cmd_key();

    @Override
    protected void Cmd_ctor_end(Xob_bldr xob_bldr, Xowe_wiki xowe_wiki) {
        this.poll_mgr = new Xobu_poll_mgr(xob_bldr.App());
    }

    @Override
    public void Cmd_bgn(Xob_bldr xob_bldr) {
        this.parser = this.wiki.Parser_mgr().Main();
        this.ctx = this.wiki.Parser_mgr().Ctx();
        this.root = this.ctx.Tkn_mkr().Root(Bry_.Empty);
        this.wiki.Init_assert();
        this.wiki.Db_mgr_as_sql().Core_data_mgr();
        Xow_db_mgr.Init_by_load(this.wiki, Xow_db_file__core_.Find_core_fil_or_null(this.wiki));
        this.wiki.File__orig_mgr().Wkrs__del((byte)2);
        this.db_fsys_mgr = this.wiki.Db_mgr_as_sql().Core_data_mgr();
        this.db_ary = Xob_dump_mgr_base_.Init_text_files_ary(this.db_fsys_mgr);
        this.poll_interval = this.poll_mgr.Poll_interval();
        this.page_src = new Xob_dump_src_id().Init(this.wiki, this.Init_redirect(), this.select_size);
        this.ns_ary = this.Init_ns_ary();
        Db_conn db_conn = this.Init_db_file();
        Io_url io_url = this.wiki.Fsys_mgr().Root_dir();
        this.bmk_mgr.Cfg_url_(io_url.GenSubFil("xowa.file.make.cfg.gfs"));
        this.rate_mgr.Log_file_(io_url.GenSubFil("xowa.file.make.log.csv"));
        if (this.reset_db) {
            this.bmk_mgr.Reset();
            this.Init_reset(db_conn);
        }
        this.bmk_mgr.Load(this.wiki.Appe(), this);
        this.Cmd_bgn_end();
    }

    protected abstract void Cmd_bgn_end();

    public abstract byte Init_redirect();

    public abstract int[] Init_ns_ary();

    protected abstract void Init_reset(Db_conn var1);

    protected abstract Db_conn Init_db_file();

    @Override
    public void Cmd_run() {
        this.Exec_ns_ary();
    }

    private void Exec_ns_ary() {
        if (this.pg_bgn == Integer.MAX_VALUE) {
            return;
        }
        if (this.load_tmpls) {
            Xob_dump_mgr_base_.Load_all_tmpls(this.usr_dlg, this.wiki, this.page_src);
        }
        this.time_bgn = System_.Ticks();
        Xob_dump_bmk xob_dump_bmk = new Xob_dump_bmk();
        this.rate_mgr.Init();
        int n = this.ns_ary.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.ns_ary[i];
            if (this.ns_bgn != -1) {
                if (n2 != this.ns_bgn) continue;
                this.ns_bgn = -1;
            }
            xob_dump_bmk.Ns_id_(n2);
            this.Exec_db_ary(i, xob_dump_bmk, n2);
            if (n2 == this.ns_end) {
                this.exit_now = true;
            }
            if (this.exit_now) break;
        }
        this.Exec_commit(xob_dump_bmk.Ns_id(), xob_dump_bmk.Db_id(), xob_dump_bmk.Pg_id(), Bry_.Empty);
    }

    private void Exec_db_ary(int n, Xob_dump_bmk xob_dump_bmk, int n2) {
        int n3 = this.db_ary.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.db_ary[i].Id();
            if (this.db_bgn != -1) {
                if (n4 != this.db_bgn) continue;
                this.db_bgn = -1;
            }
            xob_dump_bmk.Db_id_(n4);
            this.Exec_db_itm(xob_dump_bmk, n, n2, n4);
            if (n4 == this.db_end) {
                this.exit_now = true;
            }
            if (!this.exit_now) continue;
            return;
        }
    }

    private void Exec_db_itm(Xob_dump_bmk xob_dump_bmk, int n, int n2, int n3) {
        List_adp list_adp = List_adp_.New();
        Xow_ns xow_ns = this.wiki.Ns_mgr().Ids_get_or_null(n2);
        int n4 = this.pg_bgn;
        block0: while (true) {
            this.page_src.Get_pages(this.wiki.Appe(), list_adp, n3, n2, n4);
            int n5 = list_adp.Count();
            if (n5 == 0) {
                if (n4 > this.pg_bgn) {
                    this.pg_bgn = 0;
                }
                return;
            }
            this.usr_dlg.Prog_many("", "", "fetched pages: ~{0}", n5);
            int n6 = 0;
            while (true) {
                if (n6 >= n5) continue block0;
                Xowd_page_itm xowd_page_itm = (Xowd_page_itm)list_adp.Get_at(n6);
                xob_dump_bmk.Pg_id_(n4);
                this.Exec_pg_itm(n, xow_ns, n3, xowd_page_itm);
                if (n4 >= this.pg_end || this.exec_count >= this.exec_count_max) {
                    this.exit_now = true;
                }
                if (this.exit_now) {
                    return;
                }
                n4 = xowd_page_itm.Id();
                ++n6;
            }
            break;
        }
    }

    private void Exec_pg_itm(int n, Xow_ns xow_ns, int n2, Xowd_page_itm xowd_page_itm) {
        try {
            if (this.exec_count % this.progress_interval == 0) {
                this.usr_dlg.Prog_many("", "", "parsing: ns=~{0} db=~{1} pg=~{2} count=~{3} time=~{4} rate=~{5} ttl=~{6}", xow_ns.Id(), n2, xowd_page_itm.Id(), this.exec_count, System_.Ticks__elapsed_in_sec(this.time_bgn), this.rate_mgr.Rate_as_str(), String_.new_u8(xowd_page_itm.Ttl_page_db()));
            }
            this.ctx.Clear_all();
            byte[] byArray = xowd_page_itm.Text();
            if (byArray != null) {
                this.Exec_pg_itm_hook(n, xow_ns, xowd_page_itm, byArray);
            }
            this.ctx.Wiki().Utl__bfr_mkr().Clear_fail_check();
            if (this.ctx.Wiki().Cache_mgr().Tmpl_result_cache().Count() > 50000) {
                this.ctx.Wiki().Cache_mgr().Tmpl_result_cache().Clear();
            }
            ++this.exec_count;
            this.rate_mgr.Increment();
            if (this.exec_count % this.poll_interval == 0) {
                this.poll_mgr.Poll();
            }
            if (this.exec_count % this.commit_interval == 0) {
                this.Exec_commit(xow_ns.Id(), n2, xowd_page_itm.Id(), xowd_page_itm.Ttl_page_db());
            }
            if (this.exec_count % this.cleanup_interval == 0) {
                this.Free();
            }
        }
        catch (Exception exception) {
            this.bldr.Usr_dlg().Warn_many("", "", "parse failed: wiki=~{0} ttl=~{1} err=~{2}", this.wiki.Domain_str(), xowd_page_itm.Ttl_full_db(), Err_.Message_gplx_log(exception));
            this.ctx.Wiki().Utl__bfr_mkr().Clear();
            this.Free();
        }
    }

    public abstract void Exec_pg_itm_hook(int var1, Xow_ns var2, Xowd_page_itm var3, byte[] var4);

    private void Exec_commit(int n, int n2, int n3, byte[] byArray) {
        this.usr_dlg.Prog_many("", "", "committing: ns=~{0} db=~{1} pg=~{2} count=~{3} ttl=~{4}", n, n2, n3, this.exec_count, String_.new_u8(byArray));
        this.Exec_commit_hook();
        this.bmk_mgr.Save(n, n2, n3);
        if (this.exit_after_commit) {
            this.exit_now = true;
        }
    }

    public abstract void Exec_commit_hook();

    public abstract void Exec_end_hook();

    @Override
    public void Cmd_init(Xob_bldr xob_bldr) {
    }

    @Override
    public void Cmd_term() {
    }

    @Override
    public void Cmd_end() {
        if (!this.exit_now) {
            this.pg_bgn = Integer.MAX_VALUE;
        }
        this.Exec_commit(-1, -1, -1, Bry_.Empty);
        this.Exec_end_hook();
        this.Free();
        this.usr_dlg.Note_many("", "", "done: ~{0} ~{1}", this.exec_count, Decimal_adp_.divide_safe_(this.exec_count, System_.Ticks__elapsed_in_sec(this.time_bgn)).To_str("#,###.000"));
    }

    private void Free() {
        Xowe_wiki_.Rls_mem(this.wiki, true);
    }

    protected void Reset_db_y_() {
        this.reset_db = true;
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_commit_interval_)) {
            this.commit_interval = gfoMsg.ReadInt("v");
        } else if (gfsCtx.Match(string, Invk_progress_interval_)) {
            this.progress_interval = gfoMsg.ReadInt("v");
        } else if (gfsCtx.Match(string, Invk_rate_interval_)) {
            this.rate_mgr.Reset_interval_(gfoMsg.ReadInt("v"));
        } else if (gfsCtx.Match(string, Invk_cleanup_interval_)) {
            this.cleanup_interval = gfoMsg.ReadInt("v");
        } else if (gfsCtx.Match(string, Invk_select_size_)) {
            this.select_size = gfoMsg.ReadInt("v") * 0x100000;
        } else if (gfsCtx.Match(string, Invk_ns_bgn_)) {
            this.ns_bgn = gfoMsg.ReadInt("v");
            this.Notify_restoring("ns", this.ns_bgn);
        } else if (gfsCtx.Match(string, Invk_db_bgn_)) {
            this.db_bgn = gfoMsg.ReadInt("v");
            this.Notify_restoring("db", this.db_bgn);
        } else if (gfsCtx.Match(string, Invk_pg_bgn_)) {
            this.pg_bgn = gfoMsg.ReadInt("v");
            this.Notify_restoring("pg", this.pg_bgn);
        } else if (gfsCtx.Match(string, Invk_ns_end_)) {
            this.ns_end = gfoMsg.ReadInt("v");
        } else if (gfsCtx.Match(string, Invk_db_end_)) {
            this.db_end = gfoMsg.ReadInt("v");
        } else if (gfsCtx.Match(string, Invk_pg_end_)) {
            this.pg_end = gfoMsg.ReadInt("v");
        } else if (gfsCtx.Match(string, Invk_load_tmpls_)) {
            this.load_tmpls = gfoMsg.ReadYn("v");
        } else {
            if (gfsCtx.Match(string, Invk_poll_mgr)) {
                return this.poll_mgr;
            }
            if (gfsCtx.Match(string, Invk_reset_db_)) {
                this.reset_db = gfoMsg.ReadYn("v");
            } else if (gfsCtx.Match(string, Invk_exec_count_max_)) {
                this.exec_count_max = gfoMsg.ReadInt("v");
            } else if (gfsCtx.Match(string, Invk_exit_now_)) {
                this.exit_now = gfoMsg.ReadYn("v");
            } else if (gfsCtx.Match(string, Invk_exit_after_commit_)) {
                this.exit_after_commit = gfoMsg.ReadYn("v");
            } else if (gfsCtx.Match(string, Invk__manual_now_)) {
                Datetime_now.Manual_and_freeze_(gfoMsg.ReadDate("v"));
            } else {
                return Gfo_invk_.Rv_unhandled;
            }
        }
        return this;
    }

    private void Notify_restoring(String string, int n) {
        this.usr_dlg.Note_many("", "", "restoring: itm=~{0} val=~{1}", string, n);
    }
}

