/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.apps.servers.tcp;

import gplx.xowa.apps.servers.tcp.Xowa_tcp_receiver;
import gplx.xowa.apps.servers.tcp.Xowa_tcp_sender;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Xowa_tcp_console {
    private int server_send_port;
    private int server_recv_port;
    private String wiki_domain;
    private int max_length;
    private Xowa_tcp_sender sender;

    public static void main(String[] stringArray) {
        Xowa_tcp_console xowa_tcp_console = new Xowa_tcp_console();
        xowa_tcp_console.Run(stringArray);
    }

    public void Run(String[] stringArray) {
        Xowa_tcp_console.Print_message_line("XOWA TCP client v0.0.0.0");
        if (!this.Parse_args(stringArray)) {
            Xowa_tcp_console.Print_message_line("XOWA console requires 4 args: server_send_port, server_recv_port, wiki_domain, max_length.");
            Xowa_tcp_console.Print_message_line("For example, use '55000 55001 simple.wikipedia.org 1000'");
            return;
        }
        this.sender = new Xowa_tcp_sender(this.server_send_port);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        Xowa_tcp_console.Print_message_line("Enter page name. For example 'Earth'. Press Ctrl+C to exit. Enter '|server_stop' to stop server or '|exit' to exit.");
        Xowa_tcp_console.Print_message("> ");
        try {
            String string;
            while ((string = Xowa_tcp_console.Read_string(bufferedReader)) != null && !"|exit".equals(string)) {
                if ("|server_stop".equals(string)) {
                    this.Send_message_server_stop();
                    continue;
                }
                this.Send_message_fetch_page(string);
            }
        }
        catch (Exception exception) {
            Xowa_tcp_console.Print_error(exception);
        }
    }

    private void Send_message_fetch_page(String string) {
        Xowa_tcp_console.Print_message_line("Sending request for " + string);
        String string2 = String.format("app.shell.fetch_page('%s/wiki/%s', 'wiki');", this.wiki_domain, string);
        this.Send_message(string2);
    }

    private void Send_message_server_stop() {
        Xowa_tcp_console.Print_message_line("Sending request to stop server");
        this.Send_message("app.server.stop;");
    }

    private void Send_message(String string) {
        String string2 = "id_is_for_client_usage";
        String string3 = "time_is_for_client_usage";
        String string4 = String.format("xowa.cmd.exec|%s|xowa_tcp_console|xowa_server|%s|%s", string2, string3, string);
        int n = string4.length();
        int n2 = n * 2 + 1;
        String string5 = String.format("0|%s|%s|%s", String.format("%010d", n), String.format("%010d", n2), string4);
        Xowa_tcp_receiver xowa_tcp_receiver = new Xowa_tcp_receiver(this.server_recv_port, this.max_length);
        new Thread(xowa_tcp_receiver).start();
        this.sender.Send_command(string5);
    }

    private boolean Parse_args(String[] stringArray) {
        if (stringArray.length != 4) {
            Xowa_tcp_console.Print_message_line("4 arguments must be supplied: " + stringArray.length);
            return false;
        }
        this.server_send_port = Xowa_tcp_console.Parse_int(stringArray[0]);
        if (this.server_send_port == -1) {
            return false;
        }
        this.server_recv_port = Xowa_tcp_console.Parse_int(stringArray[1]);
        if (this.server_recv_port == -1) {
            return false;
        }
        this.wiki_domain = stringArray[2];
        this.max_length = Xowa_tcp_console.Parse_int(stringArray[3]);
        return this.max_length != -1;
    }

    private static int Parse_int(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            Xowa_tcp_console.Print_message_line("argument must be numeric: " + string);
            return -1;
        }
    }

    private static String Read_string(BufferedReader bufferedReader) {
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void Print_message_line(String string) {
        System.out.println(string);
    }

    public static void Print_message(String string) {
        System.out.print(string);
    }

    public static void Print_error(Exception exception) {
        System.err.println(exception.getMessage());
    }

    public static void Sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Xowa_tcp_console.Print_error(interruptedException);
        }
    }
}

