/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.apps.servers.tcp;

import gplx.Bool_;
import gplx.Bry_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Object_;
import gplx.String_;
import gplx.Time_span_;
import gplx.Type_;
import gplx.core.envs.System_;
import gplx.core.primitives.String_obj_ref;
import gplx.core.threads.Thread_adp_;
import gplx.gfui.controls.standards.Gfui_html;
import gplx.langs.jsons.Json_doc_srl;
import gplx.xowa.Xoae_app;
import gplx.xowa.apps.servers.Gxw_html_server;
import gplx.xowa.apps.servers.tcp.Xosrv_cmd_types;
import gplx.xowa.apps.servers.tcp.Xosrv_msg;
import gplx.xowa.apps.servers.tcp.Xosrv_socket_rdr;
import gplx.xowa.apps.servers.tcp.Xosrv_socket_wtr;
import gplx.xowa.apps.servers.tcp.Xosrv_xowa_exec_parser;

public class Xosrv_server
implements Gfo_invk {
    private long last_cmd;
    private Xosrv_socket_rdr rdr = new Xosrv_socket_rdr();
    private Xosrv_socket_wtr wtr = new Xosrv_socket_wtr();
    private int rdr_port = 55000;
    private int wtr_port = 55001;
    private int shutdown_interval = -1;
    private String wtr_host = "localhost";
    private boolean running = false;
    String running_str = "false";
    private Xoae_app app;
    private Xosrv_xowa_exec_parser xowa_exec_parser = new Xosrv_xowa_exec_parser();
    private Json_doc_srl json_wtr = new Json_doc_srl();
    private static final byte[] Bry_xowa_js_result = Bry_.new_a7("xowa_js_result");
    public static final String Invk_stop = "stop";
    public static final String Invk_rdr_port = "rdr_port";
    public static final String Invk_rdr_port_ = "rdr_port_";
    public static final String Invk_wtr_port = "wtr_port";
    public static final String Invk_wtr_port_ = "wtr_port_";
    public static final String Invk_wtr_host = "wtr_host";
    public static final String Invk_wtr_host_ = "wtr_host_";
    public static final String Invk_shutdown_interval = "shutdown_interval";
    public static final String Invk_shutdown_interval_ = "shutdown_interval_";

    public Xosrv_socket_rdr Rdr() {
        return this.rdr;
    }

    public Xosrv_socket_wtr Wtr() {
        return this.wtr;
    }

    public int Rdr_port() {
        return this.rdr_port;
    }

    public Xosrv_server Rdr_port_(int n) {
        this.rdr_port = n;
        return this;
    }

    public int Wtr_port() {
        return this.wtr_port;
    }

    public Xosrv_server Wtr_port_(int n) {
        this.wtr_port = n;
        return this;
    }

    public int Shutdown_interval() {
        return this.shutdown_interval;
    }

    public Xosrv_server Shutdown_interval_(int n) {
        this.shutdown_interval = n;
        return this;
    }

    public String Wtr_host() {
        return this.wtr_host;
    }

    public boolean Running() {
        return this.running;
    }

    public Xosrv_server Running_(boolean bl) {
        this.running = bl;
        this.running_str = Bool_.To_str_lower(this.running);
        return this;
    }

    public String Running_str() {
        return this.running_str;
    }

    public void App_ctor(Xoae_app xoae_app) {
        this.app = xoae_app;
    }

    public Xoae_app App() {
        return this.app;
    }

    public void Run() {
        this.rdr.Init(this, this.rdr_port);
        this.wtr.Init(this.wtr_host, this.wtr_port);
        Gxw_html_server.Init_gui_for_server(this.app, this.wtr);
        Thread_adp_.Start_by_key("xowa.http_server.main", this.rdr, "start");
        this.app.Usr_dlg().Note_many("", "", "server started: listening on ~{0}. Press Ctrl+C to exit", this.rdr_port);
        this.last_cmd = System_.Ticks();
        this.Running_(true);
        while (this.running && (this.shutdown_interval == -1 || System_.Ticks() - this.last_cmd <= (long)this.shutdown_interval)) {
            Thread_adp_.Sleep(1000);
        }
        this.rdr.Rls();
        this.wtr.Rls();
        this.app.Usr_dlg().Note_many("", "", "server stopped", this.rdr_port);
    }

    public void Msg_rcvd(Xosrv_msg xosrv_msg) {
        try {
            long l;
            byte[] byArray = xosrv_msg.Cmd_name();
            byte[] byArray2 = Bry_.Empty;
            this.last_cmd = l = System_.Ticks();
            byte[] byArray3 = xosrv_msg.Msg_text();
            String string = String_.new_u8(byArray3);
            this.app.Usr_dlg().Note_many("", "", "processing cmd: ~{0}", string);
            String string2 = null;
            if (Bry_.Eq(byArray, Xosrv_cmd_types.Cmd_exec)) {
                byArray2 = Xosrv_cmd_types.Cmd_pass;
                string2 = this.Exec_cmd(string);
            } else if (Bry_.Eq(byArray, Xosrv_cmd_types.Js_exec)) {
                byArray2 = Xosrv_cmd_types.Js_pass;
                string2 = this.Exec_js(xosrv_msg.Sender(), byArray3);
            }
            Xosrv_msg xosrv_msg2 = Xosrv_msg.new_(byArray2, xosrv_msg.Msg_id(), xosrv_msg.Recipient(), xosrv_msg.Sender(), xosrv_msg.Msg_date(), Bry_.new_u8(string2));
            this.app.Usr_dlg().Note_many("", "", "sending rsp: bytes=~{0}", String_.Len(string2));
            this.wtr.Write(xosrv_msg2);
            this.app.Usr_dlg().Note_many("", "", "rsp sent: elapsed=~{0}", Time_span_.fracs_(System_.Ticks() - l).XtoStrUiAbbrv());
        }
        catch (Exception exception) {
            this.app.Usr_dlg().Warn_many("", "", "server error: ~{0}", Err_.Message_gplx_full(exception));
        }
    }

    private String Exec_cmd(String string) {
        Object object = this.app.Gfs_mgr().Run_str(string);
        String string2 = Type_.Eq_by_obj(object, String_.Cls_ref_type) ? (String)object : Object_.Xto_str_strict_or_null(object);
        return string2;
    }

    public String Exec_js(byte[] byArray, byte[] byArray2) {
        String_obj_ref string_obj_ref = String_obj_ref.new_("exec_js");
        try {
            Object[] objectArray = this.xowa_exec_parser.Parse_xowa_exec(byArray2);
            string_obj_ref.Val_("js_args");
            Object object = Gfui_html.Js_args_exec(this.app.Gui_mgr().Browser_win().Active_html_itm().Js_cbk(), objectArray);
            string_obj_ref.Val_("json_write: " + Object_.Xto_str_strict_or_null_mark(object));
            return this.json_wtr.Write_root(Bry_xowa_js_result, object).Bld_as_str();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "http", "exec_js error", "trace", string_obj_ref, "msg", byArray2);
        }
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_rdr_port)) {
            return this.rdr_port;
        }
        if (gfsCtx.Match(string, Invk_rdr_port_)) {
            this.rdr_port = gfoMsg.ReadInt("v");
        } else {
            if (gfsCtx.Match(string, Invk_wtr_port)) {
                return this.wtr_port;
            }
            if (gfsCtx.Match(string, Invk_wtr_port_)) {
                this.wtr_port = gfoMsg.ReadInt("v");
            } else {
                if (gfsCtx.Match(string, Invk_wtr_host)) {
                    return this.wtr_host;
                }
                if (gfsCtx.Match(string, Invk_wtr_host_)) {
                    this.wtr_host = gfoMsg.ReadStr("v");
                } else {
                    if (gfsCtx.Match(string, Invk_shutdown_interval)) {
                        return this.shutdown_interval;
                    }
                    if (gfsCtx.Match(string, Invk_shutdown_interval_)) {
                        this.shutdown_interval = gfoMsg.ReadInt("v");
                    } else if (gfsCtx.Match(string, Invk_stop)) {
                        this.running = false;
                    } else {
                        return Gfo_invk_.Rv_unhandled;
                    }
                }
            }
        }
        return this;
    }
}

