/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.apps.servers.tcp;

import gplx.Bry_;
import gplx.Bry_find_;
import gplx.Byte_;
import gplx.String_;
import gplx.core.ios.streams.IoStream;
import gplx.core.primitives.Bool_obj_ref;
import gplx.core.primitives.Int_obj_ref;
import gplx.core.primitives.String_obj_ref;
import gplx.xowa.apps.servers.tcp.Xosrv_msg;

public class Xosrv_msg_rdr {
    private byte[] header_bry = new byte[24];
    private byte[] default_body_bry;
    int default_body_bry_len;
    private IoStream rdr;

    public Xosrv_msg_rdr(byte[] byArray, IoStream ioStream) {
        this.default_body_bry = byArray;
        this.default_body_bry_len = byArray.length;
        this.rdr = ioStream;
    }

    public IoStream Rdr() {
        return this.rdr;
    }

    public Xosrv_msg Read() {
        int n = this.rdr.Read(this.header_bry, 0, 24);
        if (n < 24) {
            if (n == -1) {
                return Xosrv_msg.Exit;
            }
            return Xosrv_msg.fail_("header is invalid; hdr:{0}", String_.new_u8(this.header_bry, 0, n));
        }
        byte by = this.header_bry[0];
        if (by != 48) {
            return Xosrv_msg.fail_("version must be 0; version:{0}", Byte_.To_str(by));
        }
        int n2 = Bry_.To_int_or(this.header_bry, 2, 12, -1);
        if (n2 == -1) {
            return Xosrv_msg.fail_("body_len is not number; body_len:{0}", String_.new_u8(this.header_bry, 2, 23));
        }
        int n3 = Bry_.To_int_or(this.header_bry, 13, 23, -1);
        if (n3 == -1) {
            return Xosrv_msg.fail_("checksum is not number; cksum:{0}", String_.new_u8(this.header_bry, 13, 23));
        }
        if (!Xosrv_msg_rdr.Chk_bytes(this.header_bry, (byte)124, 1, 12, 23)) {
            return Xosrv_msg.fail_("message should be delimited by pipes at 1, 12 and 23; message:{0}", String_.new_u8(this.header_bry, 0, 24));
        }
        if (n3 != n2 * 2 + 1) {
            return Xosrv_msg.fail_("checksum failed; body_len:{0} chksum:{1}", n2, n3);
        }
        byte[] byArray = n2 > this.default_body_bry_len ? new byte[n2] : this.default_body_bry;
        this.rdr.Read(byArray, 0, n2);
        Int_obj_ref int_obj_ref = Int_obj_ref.New_zero();
        Bool_obj_ref bool_obj_ref = Bool_obj_ref.n_();
        String_obj_ref string_obj_ref = String_obj_ref.null_();
        byte[] byArray2 = Xosrv_msg_rdr.Read_fld(byArray, n2, int_obj_ref, bool_obj_ref, string_obj_ref.Val_("cmd_name"));
        if (bool_obj_ref.Val()) {
            return Xosrv_msg_rdr.Read_fld_fail(string_obj_ref, byArray);
        }
        byte[] byArray3 = Xosrv_msg_rdr.Read_fld(byArray, n2, int_obj_ref, bool_obj_ref, string_obj_ref.Val_("msg_id"));
        if (bool_obj_ref.Val()) {
            return Xosrv_msg_rdr.Read_fld_fail(string_obj_ref, byArray);
        }
        byte[] byArray4 = Xosrv_msg_rdr.Read_fld(byArray, n2, int_obj_ref, bool_obj_ref, string_obj_ref.Val_("sender"));
        if (bool_obj_ref.Val()) {
            return Xosrv_msg_rdr.Read_fld_fail(string_obj_ref, byArray);
        }
        byte[] byArray5 = Xosrv_msg_rdr.Read_fld(byArray, n2, int_obj_ref, bool_obj_ref, string_obj_ref.Val_("recipient"));
        if (bool_obj_ref.Val()) {
            return Xosrv_msg_rdr.Read_fld_fail(string_obj_ref, byArray);
        }
        byte[] byArray6 = Xosrv_msg_rdr.Read_fld(byArray, n2, int_obj_ref, bool_obj_ref, string_obj_ref.Val_("msg_date"));
        if (bool_obj_ref.Val()) {
            return Xosrv_msg_rdr.Read_fld_fail(string_obj_ref, byArray);
        }
        byte[] byArray7 = Bry_.Mid(byArray, int_obj_ref.Val(), n2);
        return Xosrv_msg.new_(byArray2, byArray3, byArray4, byArray5, byArray6, byArray7);
    }

    private static byte[] Read_fld(byte[] byArray, int n, Int_obj_ref int_obj_ref, Bool_obj_ref bool_obj_ref, String_obj_ref string_obj_ref) {
        int n2 = Bry_find_.Find_fwd(byArray, (byte)124, int_obj_ref.Val(), n);
        if (n2 == -1) {
            bool_obj_ref.Val_y_();
            return null;
        }
        byte[] byArray2 = Bry_.Mid(byArray, int_obj_ref.Val(), n2);
        int_obj_ref.Val_(n2 + 1);
        return byArray2;
    }

    private static Xosrv_msg Read_fld_fail(String_obj_ref string_obj_ref, byte[] byArray) {
        return Xosrv_msg.fail_("pipe not found for " + string_obj_ref.Val() + "; body:{0}", String_.new_u8(byArray));
    }

    private static boolean Chk_bytes(byte[] byArray, byte by, int ... nArray) {
        int n = nArray.length;
        int n2 = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 >= n2) {
                return false;
            }
            if (byArray[n3] == by) continue;
            return false;
        }
        return true;
    }
}

