/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.wikis.searchs.searchers;

import gplx.Cancelable;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.Gfo_usr_dlg_;
import gplx.GfsCtx;
import gplx.Hash_adp_bry;
import gplx.core.threads.Thread_adp_;
import gplx.xowa.Xow_wiki;
import gplx.xowa.addons.wikis.searchs.Srch_search_addon;
import gplx.xowa.addons.wikis.searchs.dbs.Srch_db_upgrade;
import gplx.xowa.addons.wikis.searchs.parsers.Srch_text_parser;
import gplx.xowa.addons.wikis.searchs.searchers.Srch_search_cmd;
import gplx.xowa.addons.wikis.searchs.searchers.Srch_search_ctx;
import gplx.xowa.addons.wikis.searchs.searchers.Srch_search_qry;
import gplx.xowa.addons.wikis.searchs.searchers.crts.Srch_crt_mgr;
import gplx.xowa.addons.wikis.searchs.searchers.crts.Srch_crt_parser;
import gplx.xowa.addons.wikis.searchs.searchers.crts.Srch_crt_scanner_syms;
import gplx.xowa.addons.wikis.searchs.searchers.rslts.Srch_rslt_cache;
import gplx.xowa.addons.wikis.searchs.searchers.rslts.Srch_rslt_cbk;
import gplx.xowa.addons.wikis.searchs.searchers.rslts.Srch_rslt_list;
import gplx.xowa.addons.wikis.searchs.searchers.wkrs.Srch_link_wkr;
import gplx.xowa.addons.wikis.searchs.searchers.wkrs.Srch_page_tbl_wkr;

public class Srch_search_mgr
implements Gfo_invk {
    private final Srch_search_addon addon;
    private final Xow_wiki wiki;
    private final Srch_rslt_list cache__page = new Srch_rslt_list();
    private final Hash_adp_bry cache__word_counts = Hash_adp_bry.cs();
    private final Srch_rslt_cache cache__rslts = new Srch_rslt_cache();
    private final Srch_page_tbl_wkr page_tbl_searcher = new Srch_page_tbl_wkr();
    private final Srch_crt_parser crt_parser;
    private final Srch_search_cmd[] cur_cmds;
    private final Object mutex = new Object();
    private int search_count;
    private boolean upgrade_prompted;
    public static final String Cfg__args_default = "xowa.addon.search.special.args_default";

    public Srch_search_mgr(Srch_search_addon srch_search_addon, Xow_wiki xow_wiki, Srch_text_parser srch_text_parser) {
        this.addon = srch_search_addon;
        this.wiki = xow_wiki;
        this.crt_parser = new Srch_crt_parser(Srch_crt_scanner_syms.Dflt);
        int n = 4;
        this.cur_cmds = new Srch_search_cmd[4];
        for (int i = 0; i < n; ++i) {
            this.cur_cmds[i] = Srch_search_cmd.Noop();
        }
        xow_wiki.App().Cfg().Bind_many_wiki(this, xow_wiki, Cfg__args_default);
    }

    public void Clear_rslts_cache() {
        this.cache__rslts.Clear();
    }

    public void Search_cancel() {
        this.cur_cmds[1].Cancel();
    }

    public void Search(Srch_search_qry srch_search_qry, Srch_rslt_cbk srch_rslt_cbk) {
        if (srch_search_qry.Phrase.Orig.length == 0) {
            return;
        }
        if (this.addon.Db_mgr().Cfg() == null) {
            Gfo_usr_dlg_.Instance.Warn_many("", "", "Search databases are missing; wiki=~{0}", this.wiki.Domain_str());
            return;
        }
        if (this.addon.Db_mgr().Cfg().Version_id__needs_upgrade() && !this.upgrade_prompted) {
            this.upgrade_prompted = true;
            Srch_db_upgrade srch_db_upgrade = new Srch_db_upgrade(this.wiki, this.addon.Db_mgr());
            srch_db_upgrade.Upgrade();
            return;
        }
        Srch_search_cmd srch_search_cmd = this.cur_cmds[srch_search_qry.Tid];
        srch_search_cmd.Cancel();
        Srch_crt_mgr srch_crt_mgr = this.crt_parser.Parse_or_invalid(srch_search_qry.Phrase.Compiled);
        if (srch_crt_mgr == Srch_crt_mgr.Invalid) {
            return;
        }
        Srch_rslt_list srch_rslt_list = this.cache__rslts.Get_or_new(srch_crt_mgr.Key);
        this.cur_cmds[srch_search_qry.Tid] = srch_search_cmd = new Srch_search_cmd(this, srch_search_qry, srch_crt_mgr, srch_rslt_cbk, srch_rslt_list);
        if (this.wiki.App().Mode().Tid_is_http()) {
            srch_search_cmd.Search();
        } else {
            Thread_adp_.Start_by_key("xowa.special.suggest", srch_search_cmd, "search");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Search_async(Cancelable cancelable, Srch_search_qry srch_search_qry, Srch_crt_mgr srch_crt_mgr, Srch_rslt_cbk srch_rslt_cbk, Srch_rslt_list srch_rslt_list) {
        Object object = this.mutex;
        synchronized (object) {
            if (++this.search_count > 64) {
                this.Clear();
            }
            Srch_search_ctx srch_search_ctx = new Srch_search_ctx(cancelable, this.wiki, this.addon, this.cache__page, this.cache__word_counts, srch_search_qry, srch_search_qry.Phrase.Syms, srch_crt_mgr, srch_rslt_list);
            srch_search_ctx.Score_rng.Select_init(srch_search_ctx.Rslts_needed, srch_rslt_list.Score_bgn, srch_rslt_list.Score_len, Srch_link_wkr.Percentile_rng__calc_adj(srch_crt_mgr.Words_nth__len()));
            this.page_tbl_searcher.Search(srch_search_ctx, srch_rslt_cbk);
            if (cancelable.Canceled()) {
                return;
            }
            Srch_link_wkr srch_link_wkr = new Srch_link_wkr();
            srch_link_wkr.Search(srch_rslt_list, srch_rslt_cbk, srch_search_ctx);
        }
    }

    private void Clear() {
        Gfo_usr_dlg_.Instance.Log_many("", "", "search.clear", new Object[0]);
        this.search_count = 0;
        this.cache__page.Clear();
        this.cache__word_counts.Clear();
        this.cache__rslts.Clear();
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (!gfsCtx.Match(string, Cfg__args_default)) {
            return Gfo_invk_.Rv_unhandled;
        }
        this.Clear_rslts_cache();
        return this;
    }
}

