/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.wikis.searchs.bldrs.cmds.adjustments;

import gplx.Array_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.Gfo_log_;
import gplx.GfsCtx;
import gplx.String_;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.Dbmeta_fld_tid;
import gplx.dbs.Dbmeta_tbl_itm;
import gplx.xowa.Xow_wiki;
import gplx.xowa.addons.wikis.searchs.bldrs.cmds.adjustments.Page_matcher_itm;
import gplx.xowa.addons.wikis.searchs.bldrs.cmds.adjustments.Page_matcher_mgr;
import gplx.xowa.addons.wikis.searchs.bldrs.cmds.adjustments.Page_matcher_wkr;
import gplx.xowa.addons.wikis.searchs.bldrs.cmds.adjustments.Page_stub;
import gplx.xowa.bldrs.Xob_db_file;
import gplx.xowa.wikis.nss.Xow_ns;

public class Adjustment_cmd
implements Gfo_invk {
    private final Xow_wiki wiki;
    private final Page_matcher_mgr matcher_mgr;
    private boolean enabled = true;
    private double median_factor = 0.001;
    private static final String Invk__match_mgr = "match_mgr";
    private static final String Invk__enabled_ = "enabled_";
    private static final String Invk__median_factor_ = "median_factor_";

    public Adjustment_cmd(Xow_wiki xow_wiki) {
        this.wiki = xow_wiki;
        this.matcher_mgr = new Page_matcher_mgr(xow_wiki);
    }

    public void Exec() {
        if (!this.enabled) {
            return;
        }
        this.wiki.Init_by_wiki();
        Xob_db_file xob_db_file = Xob_db_file.New__page_link(this.wiki);
        Db_conn db_conn = xob_db_file.Conn();
        String string = "page_rank_temp";
        db_conn.Meta_fld_assert(string, "score_old", Dbmeta_fld_tid.Itm__int, 0);
        db_conn.Meta_fld_assert(string, "len_avg", Dbmeta_fld_tid.Itm__int, 0);
        db_conn.Meta_tbl_remake(Dbmeta_tbl_itm.New("penalty_summary", Dbmeta_fld_itm.new_int("page_ns"), Dbmeta_fld_itm.new_int("score_bgn"), Dbmeta_fld_itm.new_int("score_end"), Dbmeta_fld_itm.new_int("len_avg"), Dbmeta_fld_itm.new_int("page_count")));
        Db_stmt db_stmt = db_conn.Stmt_insert("penalty_summary", "page_ns", "score_bgn", "score_end", "len_avg", "page_count");
        Db_stmt db_stmt2 = db_conn.Stmt_update(string, String_.Ary("page_id"), "page_score", "score_old", "len_avg");
        db_conn.Meta_idx_create("page_rank_temp", "adjustment", "page_namespace", "page_score");
        Db_stmt db_stmt3 = db_conn.Stmt_sql("SELECT pr.page_id, pr.page_is_redirect, pr.page_len, pr.page_score FROM page_rank_temp pr WHERE pr.page_namespace = ? ORDER BY pr.page_score DESC");
        int n = this.wiki.Ns_mgr().Ords_len();
        for (int i = 0; i < n; ++i) {
            Xow_ns xow_ns = this.wiki.Ns_mgr().Ords_get_at(i);
            if (xow_ns.Count() <= 0) continue;
            Page_matcher_wkr page_matcher_wkr = this.matcher_mgr.Get_by(xow_ns.Id()).Load_all();
            db_conn.Txn_bgn("pl_penalty");
            this.Calc_for_ns(this.wiki, page_matcher_wkr, db_stmt3, db_stmt, db_stmt2, xow_ns);
            db_conn.Txn_end();
        }
        db_stmt2.Rls();
        db_stmt.Rls();
        db_stmt3.Rls();
    }

    private void Calc_for_ns(Xow_wiki xow_wiki, Page_matcher_wkr page_matcher_wkr, Db_stmt db_stmt, Db_stmt db_stmt2, Db_stmt db_stmt3, Xow_ns xow_ns) {
        int n = (int)((double)xow_ns.Count() * 1.0E-4);
        if (n < 100) {
            n = 100;
        }
        Page_stub[] page_stubArray = new Page_stub[n];
        Gfo_log_.Instance.Prog("loading pages for ns", "ns_id", xow_ns.Id());
        Db_rdr db_rdr = db_stmt.Clear().Crt_int("page_namespace", xow_ns.Id()).Exec_select__rls_manual();
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (db_rdr.Move_next()) {
            int n6 = db_rdr.Read_int("page_id");
            boolean bl = db_rdr.Read_bool_by_byte("page_is_redirect");
            int n7 = db_rdr.Read_int("page_len");
            n4 = db_rdr.Read_int("page_score");
            if (n3 == -1) {
                n3 = n4;
            }
            page_stubArray[n2] = new Page_stub(n6, bl, n7, n4);
            if (++n2 != n) continue;
            if (++n5 % 100 == 0) {
                Gfo_log_.Instance.Prog("updating range", "ns", xow_ns.Id(), "score_cur", n4, "score_end", n3);
            }
            this.Save_sample(page_stubArray, page_matcher_wkr, xow_wiki.Domain_bry(), xow_ns.Id(), n4, n3, db_stmt2, db_stmt3);
            n2 = 0;
            n3 = -1;
        }
        page_stubArray = (Page_stub[])Array_.Resize(page_stubArray, n2);
        this.Save_sample(page_stubArray, page_matcher_wkr, xow_wiki.Domain_bry(), xow_ns.Id(), n4, n3, db_stmt2, db_stmt3);
        db_rdr.Rls();
    }

    private void Save_sample(Page_stub[] page_stubArray, Page_matcher_wkr page_matcher_wkr, byte[] byArray, int n, int n2, int n3, Db_stmt db_stmt, Db_stmt db_stmt2) {
        Array_.Sort(page_stubArray);
        int n4 = page_stubArray.length;
        if (n4 == 0) {
            return;
        }
        int n5 = Adjustment_cmd.Calc_median(page_stubArray);
        for (int i = 0; i < n4; ++i) {
            int n6;
            Page_stub page_stub = page_stubArray[i];
            int n7 = n6 = page_stub.Score;
            Page_matcher_itm page_matcher_itm = page_matcher_wkr.Get_by_or_null(page_stub.Id);
            if (page_matcher_itm != null) {
                n7 = page_matcher_itm.Calc(n6);
            } else if (page_stub.Len < n5) {
                n7 = (int)((1.0 - (1.0 - (double)page_stub.Len / (double)n5) * this.median_factor) * (double)n6);
            }
            db_stmt2.Clear().Val_int("page_score", n7).Val_int("score_old", n6).Val_int("len_avg", n5).Crt_int("page_id", page_stub.Id).Exec_update();
        }
        db_stmt.Clear().Val_int("page_ns", n).Val_int("score_bgn", n2).Val_int("score_end", n3).Val_int("len_avg", n5).Val_int("page_count", n4).Exec_insert();
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk__enabled_)) {
            this.enabled = gfoMsg.ReadBool("v");
        } else if (gfsCtx.Match(string, Invk__median_factor_)) {
            this.median_factor = gfoMsg.ReadDouble("v");
        } else {
            if (gfsCtx.Match(string, Invk__match_mgr)) {
                return this.matcher_mgr;
            }
            return Gfo_invk_.Rv_unhandled;
        }
        return this;
    }

    private static int Calc_median(Page_stub[] page_stubArray) {
        int n;
        int n2 = page_stubArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            Page_stub page_stub = page_stubArray[n];
            if (page_stub.Is_redirect) continue;
            n3 = n;
            break;
        }
        n = (n2 - n3) / 2;
        return page_stubArray[n].Len;
    }
}

