/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.bldrs.utils_rankings.bldrs;

import gplx.Bry_fmt;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.String_;
import gplx.dbs.Db_attach_itm;
import gplx.dbs.Db_attach_mgr;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_conn_bldr;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.Dbmeta_idx_itm;
import gplx.dbs.Dbmeta_tbl_itm;
import gplx.xowa.Xoa_app_;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.bldrs.Xob_bldr;
import gplx.xowa.bldrs.wkrs.Xob_cmd;
import gplx.xowa.bldrs.wkrs.Xob_cmd__base;

public class Sqlite_percentile_cmd
extends Xob_cmd__base
implements Xob_cmd {
    private String db_rel_url;
    private String tbl_name = "tmp_score";
    private int score_max = 100000000;
    private String select_sql;
    private Db_conn conn;
    public int count;
    private static final String Invk__db_rel_url_ = "db_rel_url_";
    private static final String Invk__select_sql_ = "select_sql_";
    private static final String Invk__tbl_name_ = "tbl_name_";
    private static final String Invk__score_max_ = "score_max_";
    public static final String BLDR_CMD_KEY = "util.sqlite.normalize";
    public static final Xob_cmd Prototype = new Sqlite_percentile_cmd(null, null);

    public Sqlite_percentile_cmd(Xob_bldr xob_bldr, Xowe_wiki xowe_wiki) {
        super(xob_bldr, xowe_wiki);
    }

    public Sqlite_percentile_cmd Init_by_rel_url(String string, String string2, int n, String string3) {
        this.db_rel_url = string;
        this.tbl_name = string2;
        this.score_max = n;
        this.select_sql = string3;
        return this;
    }

    public Sqlite_percentile_cmd Init_by_conn(Db_conn db_conn, String string, int n, String string2) {
        this.conn = db_conn;
        return this.Init_by_rel_url(null, string, n, string2);
    }

    @Override
    public void Cmd_run() {
        this.wiki.Init_assert();
        if (this.conn == null) {
            if (this.db_rel_url == null) {
                throw Err_.new_("bldr", "db_rel_url can not be empty; EX: 'xowa.page_rank.sqlite3'", new Object[0]);
            }
            this.conn = Db_conn_bldr.Instance.Get_or_autocreate(false, this.wiki.Fsys_mgr().Root_dir().GenSubFil(this.db_rel_url));
        }
        Xoa_app_.Usr_dlg().Prog_many("", "", "creating temp_table: tbl=~{0}", this.tbl_name);
        this.conn.Meta_tbl_delete(this.tbl_name);
        this.conn.Meta_tbl_create(Dbmeta_tbl_itm.New(this.tbl_name, Dbmeta_fld_itm.new_int("row_rank").Primary_y_().Autonum_y_(), Dbmeta_fld_itm.new_int("row_key"), Dbmeta_fld_itm.new_double("row_val"), Dbmeta_fld_itm.new_double("row_score").Default_(-1)));
        Xoa_app_.Usr_dlg().Prog_many("", "", "filling temp_table: tbl=~{0} sql=~{1}", this.tbl_name, this.select_sql);
        new Db_attach_mgr(this.conn, new Db_attach_itm("page_db", this.wiki.Data__core_mgr().Tbl__page().Conn())).Exec_sql(Bry_fmt.Make_str("INSERT INTO ~{tbl} (row_key, row_val) ~{select}", this.tbl_name, this.select_sql), new Object[0]);
        Xoa_app_.Usr_dlg().Prog_many("", "", "updating row_score: tbl=~{0}", this.tbl_name);
        String string = Dbmeta_fld_itm.To_double_str_by_int(this.score_max);
        this.count = this.conn.Exec_select_as_int("SELECT Count(*) FROM " + this.tbl_name, -1);
        if (this.count == -1) {
            throw Err_.new_("bldr", "failed to get count; tbl=~{0}", this.tbl_name);
        }
        String string2 = Dbmeta_fld_itm.To_double_str_by_int(this.count);
        this.conn.Exec_sql(Bry_fmt.Make_str("UPDATE ~{tbl} SET row_score = (row_rank * ~{score_max}) / ~{count}", this.tbl_name, string, string2));
        Xoa_app_.Usr_dlg().Prog_many("", "", "resolving ties: tbl=~{0}", this.tbl_name);
        this.conn.Meta_tbl_remake(Dbmeta_tbl_itm.New(this.tbl_name + "_avg", Dbmeta_fld_itm.new_double("row_val").Primary_y_(), Dbmeta_fld_itm.new_double("row_score")));
        this.conn.Exec_sql(Bry_fmt.Make_str(String_.Concat_lines_nl_skip_last("INSERT INTO ~{tbl}_avg (row_val, row_score)", "SELECT   row_val", ",        (Avg(row_rank) * ~{score_max} / ~{count}) AS row_score", "FROM     ~{tbl}", "GROUP BY row_val", "HAVING   Count(row_val > 1)"), this.tbl_name, string, string2));
        this.conn.Exec_sql(Bry_fmt.Make_str(String_.Concat_lines_nl_skip_last("UPDATE   ~{tbl}", "SET      row_score = (SELECT row_score FROM ~{tbl}_avg t2 WHERE t2.row_val = ~{tbl}.row_val)", "WHERE    row_val IN (SELECT row_val FROM ~{tbl}_avg t2)"), this.tbl_name));
        this.conn.Meta_tbl_delete(this.tbl_name + "_avg");
        this.conn.Meta_idx_create(Xoa_app_.Usr_dlg(), Dbmeta_idx_itm.new_normal_by_tbl(this.tbl_name, "row_score", "row_key", "row_score"));
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk__db_rel_url_)) {
            this.db_rel_url = gfoMsg.ReadStr("v");
        } else if (gfsCtx.Match(string, Invk__select_sql_)) {
            this.select_sql = gfoMsg.ReadStr("v");
        } else if (gfsCtx.Match(string, Invk__tbl_name_)) {
            this.tbl_name = gfoMsg.ReadStr("v");
        } else if (gfsCtx.Match(string, Invk__score_max_)) {
            this.score_max = gfoMsg.ReadInt("v");
        } else {
            return Gfo_invk_.Rv_unhandled;
        }
        return this;
    }

    @Override
    public String Cmd_key() {
        return BLDR_CMD_KEY;
    }

    @Override
    public Xob_cmd Cmd_clone(Xob_bldr xob_bldr, Xowe_wiki xowe_wiki) {
        return new Sqlite_percentile_cmd(xob_bldr, xowe_wiki);
    }
}

