/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.bldrs.exports.splits.archives;

import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_crt_;
import gplx.dbs.Db_qry_;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.Dbmeta_idx_itm;
import gplx.dbs.Dbmeta_tbl_itm;
import gplx.dbs.metas.Dbmeta_idx_fld;
import gplx.dbs.qrys.Db_qry__select_cmd;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.addons.bldrs.exports.splits.htmls.Xoh_page_tbl_itm;
import gplx.xowa.addons.bldrs.exports.splits.htmls.Xoh_src_tbl_mgr;
import gplx.xowa.addons.bldrs.exports.splits.htmls.Xoh_trg_tbl_mgr;
import gplx.xowa.htmls.core.dbs.Xowd_html_row;
import gplx.xowa.wikis.data.Xow_db_mgr;
import gplx.xowa.wikis.data.tbls.Xowd_page_tbl;

class Reindex_html_dbs_cmd {
    private Db_conn core_conn;
    private Xowd_page_tbl page_tbl;
    private Xoh_src_tbl_mgr src_tbl_mgr;
    private Xoh_trg_tbl_mgr trg_tbl_mgr;
    private String tbl_page;
    private String fld_page_id;
    private String fld_page_ns;
    private String fld_page_len;
    private String fld_page_score;
    private String fld_page_html_db_id;
    private final String Idx_name = "page__repack";

    Reindex_html_dbs_cmd() {
    }

    public void Exec(Xowe_wiki xowe_wiki, long l) {
        xowe_wiki.Init_assert();
        Xow_db_mgr xow_db_mgr = xowe_wiki.Data__core_mgr();
        this.page_tbl = xow_db_mgr.Tbl__page();
        this.core_conn = this.page_tbl.Conn();
        this.src_tbl_mgr = new Xoh_src_tbl_mgr(xowe_wiki);
        this.trg_tbl_mgr = new Xoh_trg_tbl_mgr(xowe_wiki);
        this.tbl_page = this.page_tbl.Tbl_name();
        this.fld_page_id = this.page_tbl.Fld_page_id();
        this.fld_page_ns = this.page_tbl.Fld_page_ns();
        this.fld_page_len = this.page_tbl.Fld_page_len();
        this.fld_page_score = this.page_tbl.Fld_page_score();
        this.fld_page_html_db_id = this.page_tbl.Fld_html_db_id();
        this.Create_repack_idx_on_page();
        this.Create_repack_tbl();
        this.Insert_repack_rows();
        this.Move_html_data(l);
        this.Cleanup_dbs(xowe_wiki);
        this.core_conn.Meta_idx_delete("page__repack");
        this.core_conn.Meta_tbl_delete("repack");
        this.core_conn.Env_vacuum();
    }

    private void Create_repack_idx_on_page() {
        if (!this.core_conn.Meta_idx_exists("page__repack")) {
            this.core_conn.Meta_idx_create(Dbmeta_idx_itm.new_normal_by_name(this.tbl_page, "page__repack", Dbmeta_idx_fld.Dsc(this.fld_page_ns), Dbmeta_idx_fld.Dsc(this.fld_page_score), Dbmeta_idx_fld.Dsc(this.fld_page_len)));
        }
    }

    private void Create_repack_tbl() {
        this.core_conn.Meta_tbl_remake(Dbmeta_tbl_itm.New("repack", Dbmeta_fld_itm.new_int("sort_idx").Autonum_y_().Primary_y_(), Dbmeta_fld_itm.new_int("page_id"), Dbmeta_fld_itm.new_int("page_ns"), Dbmeta_fld_itm.new_int("page_score"), Dbmeta_fld_itm.new_int("page_len"), Dbmeta_fld_itm.new_int("src_db")));
    }

    private void Insert_repack_rows() {
        Gfo_usr_dlg_.Instance.Prog_many("", "", "inserting rows into repack table", new Object[0]);
        Db_qry__select_cmd db_qry__select_cmd = Db_qry_.select_(this.tbl_page, this.fld_page_id, this.fld_page_ns, this.fld_page_len, this.fld_page_score, this.fld_page_html_db_id).Order_(this.fld_page_ns, true).Order_(this.fld_page_score, false).Order_(this.fld_page_len, false).Where_(Db_crt_.New_eq_not(this.fld_page_html_db_id, -1));
        Db_qry_.insert_("repack").Cols_("page_id", "page_ns", "page_len", "page_score", "src_db").Select_(db_qry__select_cmd).Exec_qry(this.core_conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Move_html_data(long l) {
        Db_rdr db_rdr = this.core_conn.Stmt_select_order("repack", String_.Ary("sort_idx", "page_id", "page_ns", "page_len", "src_db"), String_.Ary_empty, "sort_idx").Exec_select__rls_auto();
        Db_stmt db_stmt = this.core_conn.Stmt_update(this.tbl_page, String_.Ary(this.fld_page_id), this.fld_page_html_db_id);
        Xoh_page_tbl_itm xoh_page_tbl_itm = null;
        try {
            Xowd_html_row xowd_html_row = new Xowd_html_row();
            long l2 = 0L;
            int n = -1;
            int n2 = 0;
            int n3 = -1;
            this.core_conn.Txn_bgn("update page");
            while (db_rdr.Move_next()) {
                int n4 = db_rdr.Read_int("page_ns");
                boolean bl = false;
                if (n != n4) {
                    n = n4;
                    n2 = 0;
                    bl = true;
                }
                Xoh_page_tbl_itm xoh_page_tbl_itm2 = this.src_tbl_mgr.Get_or_load(db_rdr.Read_int("src_db"));
                int n5 = db_rdr.Read_int("page_id");
                if (!xoh_page_tbl_itm2.Html_tbl().Select_as_row(xowd_html_row, n5)) {
                    throw Err_.new_wo_type("could not find html", "page_id", n5);
                }
                int n6 = xowd_html_row.Body().length;
                if (xoh_page_tbl_itm == null || bl || (l2 += (long)n6) > l) {
                    if (xoh_page_tbl_itm != null) {
                        xoh_page_tbl_itm.Html_tbl().Insert_end();
                        xoh_page_tbl_itm.Rls();
                    }
                    xoh_page_tbl_itm = this.trg_tbl_mgr.Make_new(n, ++n2);
                    xoh_page_tbl_itm.Html_tbl().Insert_bgn();
                    n3 = xoh_page_tbl_itm.Db_id();
                    l2 = n6;
                }
                xoh_page_tbl_itm.Html_tbl().Insert(xowd_html_row.Page_id(), xowd_html_row.Head_flag(), xowd_html_row.Body_flag(), xowd_html_row.Display_ttl(), xowd_html_row.Content_sub(), xowd_html_row.Sidebar_div(), xowd_html_row.Body());
                db_stmt.Clear().Val_int(this.fld_page_html_db_id, n3).Crt_int(this.fld_page_id, n5).Exec_update();
            }
        }
        finally {
            db_rdr.Rls();
            if (xoh_page_tbl_itm != null) {
                xoh_page_tbl_itm.Html_tbl().Insert_end();
                xoh_page_tbl_itm.Rls();
            }
            this.core_conn.Txn_end();
            db_stmt.Rls();
            this.src_tbl_mgr.Cleanup();
        }
    }

    private void Cleanup_dbs(Xowe_wiki xowe_wiki) {
        xowe_wiki.Data__core_mgr().Rls();
        String string = ".repack";
        Db_stmt db_stmt = this.core_conn.Stmt_delete("xowa_db", "db_id");
        Db_rdr db_rdr = this.core_conn.Stmt_select("xowa_db", String_.Ary("db_id", "db_type", "db_url"), new String[0]).Exec_select__rls_auto();
        while (db_rdr.Move_next()) {
            String string2;
            byte by = db_rdr.Read_byte("db_type");
            if (by != 11 || String_.Has(string2 = db_rdr.Read_str("db_url"), string)) continue;
            db_stmt.Clear().Crt_int("db_id", db_rdr.Read_int("db_id")).Exec_delete();
            Io_mgr.Instance.DeleteFil(xowe_wiki.Fsys_mgr().Root_dir().GenSubFil(string2));
        }
        db_rdr.Rls();
        db_stmt.Rls();
        Db_stmt db_stmt2 = this.core_conn.Stmt_update("xowa_db", String_.Ary("db_id"), "db_url");
        db_rdr = this.core_conn.Stmt_select("xowa_db", String_.Ary("db_id", "db_type", "db_url"), new String[0]).Exec_select__rls_auto();
        while (db_rdr.Move_next()) {
            byte by = db_rdr.Read_byte("db_type");
            if (by != 11) continue;
            Io_url io_url = xowe_wiki.Fsys_mgr().Root_dir().GenSubFil(db_rdr.Read_str("db_url"));
            String string3 = io_url.Raw();
            Io_url io_url2 = Io_url_.new_fil_(String_.Replace(string3, string, ""));
            if (!String_.Has(string3, string)) {
                throw Err_.new_wo_type("html db should be repack", "db_name", string3);
            }
            db_stmt2.Clear().Val_str("db_url", io_url2.NameAndExt()).Crt_int("db_id", db_rdr.Read_int("db_id")).Exec_update();
            Io_mgr.Instance.MoveFil(io_url, io_url2);
        }
        db_rdr.Rls();
        db_stmt2.Rls();
    }
}

