/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.bldrs.centrals.cmds;

import gplx.Bry_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.String_;
import gplx.core.ios.streams.IoStream;
import gplx.core.security.algos.Hash_algo;
import gplx.core.security.algos.Hash_algo_;
import gplx.core.security.algos.Hash_algo_utl;
import gplx.core.security.files.Cksum_itm;
import gplx.core.security.files.Cksum_list;
import gplx.xowa.addons.bldrs.centrals.Xobc_task_mgr;
import gplx.xowa.addons.bldrs.centrals.cmds.Xobc_cmd__base;
import gplx.xowa.addons.bldrs.centrals.cmds.Xobc_cmd_ctx;

public class Xobc_cmd__verify_dir
extends Xobc_cmd__base {
    private final Io_url delete_fil;
    private final Io_url checksum_fil;
    public static final String CMD_TYPE = "xowa.core.hash_dir";

    public Xobc_cmd__verify_dir(Xobc_task_mgr xobc_task_mgr, int n, int n2, int n3, Io_url io_url, Io_url io_url2) {
        super(xobc_task_mgr, n, n2, n3);
        this.checksum_fil = io_url;
        this.delete_fil = io_url2;
    }

    @Override
    public String Cmd_type() {
        return CMD_TYPE;
    }

    @Override
    public String Cmd_name() {
        return "verify";
    }

    @Override
    public String Cmd_fallback() {
        return "xowa.core.ios.zips.zip_unzip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void Cmd_exec_hook(Xobc_cmd_ctx xobc_cmd_ctx) {
        Cksum_list cksum_list = Cksum_list.Parse_by_fil(this.checksum_fil);
        this.Prog_data_end_(cksum_list.Itms_size);
        Hash_algo hash_algo = Hash_algo_.New_by_tid(cksum_list.Type);
        Cksum_itm[] cksum_itmArray = cksum_list.Itms;
        int n = cksum_itmArray.length;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            Cksum_itm cksum_itm = cksum_itmArray[i];
            IoStream ioStream = Io_mgr.Instance.OpenStreamRead(cksum_itm.File_url);
            byte[] byArray = Bry_.Empty;
            this.Prog_data_cur_(l);
            try {
                byArray = Hash_algo_utl.Calc_hash_w_prog_as_bry(hash_algo, ioStream, this);
            }
            finally {
                ioStream.Rls();
            }
            if (this.Prog_notify_and_chk_if_suspended(l += cksum_itm.File_size, this.Prog_data_end())) {
                return;
            }
            if (this.Prog_status() == 16 || Bry_.Eq(cksum_itm.Hash, byArray)) continue;
            this.Cmd_exec_err_(String_.Format("bad hash; file={0} bad={1} good={2}", cksum_itm.File_url.Raw(), byArray, cksum_itm.Hash));
            return;
        }
    }

    @Override
    public void Cmd_cleanup() {
        Io_mgr.Instance.DeleteFil(this.checksum_fil);
        Io_mgr.Instance.DeleteFil(this.delete_fil);
    }
}

