/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.bldrs.app_cfgs.wm_server_cfgs;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Bry_find_;
import gplx.Byte_ascii;
import gplx.DateAdp;
import gplx.Datetime_now;
import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Tfds;
import gplx.core.ios.IoItmFil;
import gplx.core.log_msgs.Gfo_msg_log;
import gplx.langs.phps.Php_evaluator;
import gplx.langs.phps.Php_itm_ary;
import gplx.langs.phps.Php_itm_kv;
import gplx.langs.phps.Php_line;
import gplx.langs.phps.Php_line_assign;
import gplx.langs.phps.Php_parser;
import gplx.langs.phps.Php_tkn_wkr;
import gplx.xowa.Xoa_app;
import gplx.xowa.wikis.domains.Xow_abrv_wm_;
import gplx.xowa.wikis.domains.Xow_domain_itm;
import gplx.xowa.wikis.domains.Xow_domain_itm_;

public class Xowm_server_cfg_mgr {
    public void Exec(Xoa_app xoa_app) {
        Io_url io_url = xoa_app.Fsys_mgr().Bin_xowa_dir().GenSubFil_nest("cfg", "wiki", "InitialiseSettings.php.txt");
        Xowm_server_cfg_mgr.Assert_recent_or_download(io_url, "https://noc.wikimedia.org/conf/InitialiseSettings.php.txt", 1440);
        byte[] byArray = Io_mgr.Instance.LoadFilBry(io_url);
        this.Parse_cat_collation(byArray);
    }

    private void Parse_cat_collation(byte[] byArray) {
        int n = Bry_find_.Find_fwd(byArray, Bry_.new_a7("wgCategoryCollation"));
        if (n == -1) {
            throw Err_.new_wo_type("could not find wgCategoryCollation bgn", new Object[0]);
        }
        n = Bry_find_.Move_fwd(byArray, Byte_ascii.Nl_bry, n);
        int n2 = Bry_find_.Find_fwd(byArray, Bry_.new_a7("\n],"), n);
        if (n2 == -1) {
            throw Err_.new_wo_type("could not find wgCategoryCollation end", new Object[0]);
        }
        byte[] byArray2 = Bry_.Mid(byArray, n, n2 + 2);
        byArray2 = Bry_.Add(Bry_.new_a7("$test=["), byArray2, Bry_.new_a7("];"));
        Php_parser php_parser = new Php_parser();
        Php_evaluator php_evaluator = new Php_evaluator(new Gfo_msg_log("test"));
        php_parser.Parse_tkns(byArray2, (Php_tkn_wkr)php_evaluator);
        Php_line[] php_lineArray = (Php_line[])php_evaluator.List().To_ary(Php_line.class);
        Php_line_assign php_line_assign = (Php_line_assign)php_lineArray[0];
        Php_itm_ary php_itm_ary = (Php_itm_ary)php_line_assign.Val();
        Bry_bfr bry_bfr = Bry_bfr_.New();
        bry_bfr.Add_byte_nl();
        int n3 = php_itm_ary.Subs_len();
        byte[] byArray3 = Bry_.new_a7("default");
        for (int i = 0; i < n3; ++i) {
            Php_itm_kv php_itm_kv = (Php_itm_kv)php_itm_ary.Subs_get(i);
            byte[] byArray4 = php_itm_kv.Key().Val_obj_bry();
            byte[] byArray5 = php_itm_kv.Val().Val_obj_bry();
            if (Bry_.Eq(byArray4, byArray3)) continue;
            try {
                byte[] byArray6 = Xow_abrv_wm_.Parse_to_domain_bry(byArray4);
                Xow_domain_itm xow_domain_itm = Xow_domain_itm_.parse(byArray6);
                bry_bfr.Add_str_u8_fmt("app.bldr.wiki_cfg_bldr.get('{0}').new_cmd_('wiki.ctgs.collations', \"catpage_mgr.collation_('{1}');\");\n", xow_domain_itm.Domain_bry(), byArray5);
                continue;
            }
            catch (Exception exception) {
                throw Err_.new_("failed to parse line", "wiki", byArray4, "collation", byArray5, "err", Err_.Message_lang(exception));
            }
        }
        Tfds.Write(bry_bfr.To_str_and_clear());
    }

    private static void Assert_recent_or_download(Io_url io_url, String string, int n) {
        DateAdp dateAdp;
        IoItmFil ioItmFil = Io_mgr.Instance.QueryFil(io_url);
        if (ioItmFil != null && (dateAdp = Datetime_now.Get()).Diff(ioItmFil.ModifiedTime()).Total_mins().To_int() < n) {
            return;
        }
        Io_mgr.Instance.DownloadFil(string, io_url);
    }
}

