/*
 * Decompiled with CFR 0.152.
 */
package gplx.objects.strings.bfrs;

import gplx.objects.primitives.Int_;
import gplx.objects.strings.String_;

public class String_bfr {
    private StringBuilder sb = new StringBuilder();

    public boolean Has_none() {
        return this.Len() == 0;
    }

    public boolean Has_some() {
        return this.Len() > 0;
    }

    public String_bfr Add_fmt(String string, Object ... objectArray) {
        this.Add(String_.Format(string, objectArray));
        return this;
    }

    public String_bfr Add_char_pipe() {
        return this.Add_char('|');
    }

    public String_bfr Add_char_nl() {
        return this.Add_char('\n');
    }

    public String_bfr Add_char_space() {
        return this.Add_char(' ');
    }

    public String_bfr Add_char_colon() {
        return this.Add_char(':');
    }

    public String_bfr Add_char_repeat(char c, int n) {
        this.Ensure_capacity(this.Len() + n);
        for (int i = 0; i < n; ++i) {
            this.Add_char(c);
        }
        return this;
    }

    public String_bfr Add_int_pad_bgn(char c, int n, int n2) {
        int n3 = Int_.Count_digits(n2);
        int n4 = n - n3;
        if (n4 > 0) {
            this.Add_char_repeat(c, n4);
        }
        this.Add_int(n2);
        return this;
    }

    public String_bfr Add_bool(boolean bl) {
        this.Add(bl ? "true" : "false");
        return this;
    }

    public String_bfr Add_bool_as_yn(boolean bl) {
        this.Add(bl ? "y" : "n");
        return this;
    }

    public String_bfr Clear() {
        this.Del(0, this.Len());
        return this;
    }

    public String To_str_and_clear() {
        String string = this.To_str();
        this.Clear();
        return string;
    }

    public String toString() {
        return this.To_str();
    }

    public String To_str() {
        return this.sb.toString();
    }

    public int Len() {
        return this.sb.length();
    }

    public String_bfr Add_at(int n, String string) {
        this.sb.insert(n, string);
        return this;
    }

    public String_bfr Add(String string) {
        this.sb.append(string);
        return this;
    }

    public String_bfr Add_char(char c) {
        this.sb.append(c);
        return this;
    }

    public String_bfr Add_byte(byte by) {
        this.sb.append(by);
        return this;
    }

    public String_bfr Add_int(int n) {
        this.sb.append(n);
        return this;
    }

    public String_bfr Add_long(long l) {
        this.sb.append(l);
        return this;
    }

    public String_bfr Add_double(double d) {
        this.sb.append(d);
        return this;
    }

    public String_bfr Add_mid(char[] cArray, int n, int n2) {
        this.sb.append(cArray, n, n2);
        return this;
    }

    public String_bfr Add_obj(Object object) {
        this.sb.append(object);
        return this;
    }

    public String_bfr Add_bry(byte[] byArray) {
        if (byArray != null) {
            this.sb.append(String_.New_bry_utf8(byArray));
        }
        return this;
    }

    private void Ensure_capacity(int n) {
        this.sb.ensureCapacity(n);
    }

    public String_bfr Del(int n, int n2) {
        this.sb.delete(n, n2);
        return this;
    }
}

