/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.dsvs;

import gplx.Err_;
import gplx.Internal;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.core.gfo_ndes.GfoFld;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoNde;
import gplx.core.stores.DataRdr;
import gplx.core.stores.GfoNdeRdr_;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;
import gplx.core.texts.CharStream;
import gplx.langs.dsvs.DsvSymbols;
import gplx.langs.dsvs.DsvTblBldr;

class DsvParser {
    DsvSymbols sym = DsvSymbols.default_();
    String_bldr sb = String_bldr_.new_();
    List_adp tkns = List_adp_.New();
    DsvTblBldr bldr = DsvTblBldr.new_();
    boolean cmdSeqOn = false;
    boolean qteOn = false;
    boolean csvOn = false;
    int nextValType = 0;
    int lineMode = 0;
    static final int ValType_Data = 0;
    static final int ValType_CmdName = 1;
    static final int LineType_Data = 0;
    static final int LineType_Comment = 1;
    static final int LineType_TblBgn = 2;
    static final int LineType_FldNames = 3;
    static final int LineType_FldTypes = 4;
    static final int LineType_BlankLine = 5;

    DsvParser() {
    }

    @Internal
    protected DsvSymbols Symbols() {
        return this.sym;
    }

    @Internal
    protected void Init() {
        this.sb.Clear();
        this.bldr.Init();
        this.qteOn = false;
    }

    @Internal
    protected DataRdr ParseAsRdr(String string) {
        return GfoNdeRdr_.root_(this.ParseAsNde(string), this.csvOn);
    }

    @Internal
    protected GfoNde ParseAsNde(String string) {
        if (String_.Eq(string, "")) {
            return this.bldr.BldRoot();
        }
        CharStream charStream = CharStream.pos0_(string);
        while (true) {
            if (charStream.AtEnd()) break;
            if (this.qteOn) {
                this.ReadStreamInQte(charStream);
                continue;
            }
            if (charStream.MatchAndMove(this.sym.QteDlm())) {
                this.qteOn = true;
                continue;
            }
            if (charStream.MatchAndMove(this.sym.FldSep())) {
                this.ProcessFld(charStream);
                continue;
            }
            if (charStream.MatchAndMove(this.sym.RowSep())) {
                this.ProcessLine(charStream, false);
                continue;
            }
            this.sb.Add(charStream.Cur());
            charStream.MoveNext();
        }
        this.ProcessLine(charStream, true);
        return this.bldr.BldRoot();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ReadStreamInQte(CharStream charStream) {
        if (charStream.MatchAndMove(this.sym.QteDlm())) {
            if (charStream.MatchAndMove(this.sym.QteDlm())) {
                this.sb.Add(this.sym.QteDlm());
                return;
            } else if (charStream.MatchAndMove(this.sym.FldSep())) {
                this.ProcessFld(charStream);
                this.qteOn = false;
                return;
            } else {
                if (!charStream.MatchAndMove(this.sym.RowSep()) && !charStream.AtEnd()) throw Err_.new_wo_type("invalid quote in quoted field; quote must be followed by quote, fieldSpr, or recordSpr", "sym", Character.valueOf(charStream.Cur()), "text", charStream.To_str_by_pos(charStream.Pos() - 10, charStream.Pos() + 10));
                this.ProcessLine(charStream, false);
                this.qteOn = false;
            }
            return;
        } else {
            this.sb.Add(charStream.Cur());
            charStream.MoveNext();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ProcessFld(CharStream charStream) {
        String string = this.sb.To_str_and_clear();
        if (this.cmdSeqOn) {
            this.cmdSeqOn = false;
            if (String_.Eq(string, this.sym.CmdDlm()) && this.qteOn) {
                this.nextValType = 1;
                return;
            }
            this.tkns.Add(this.sym.CmdDlm());
        }
        if (String_.Eq(string, this.sym.CmdDlm())) {
            this.cmdSeqOn = true;
            return;
        } else if (this.nextValType == 0) {
            if (String_.Len(string) == 0) {
                string = this.qteOn ? "" : null;
            }
            this.tkns.Add(string);
            return;
        } else {
            if (this.nextValType != 1) throw Err_.new_wo_type("unable to process field value", "value", string);
            if (String_.Eq(string, this.sym.TblNameSym())) {
                this.lineMode = 2;
                return;
            } else if (String_.Eq(string, this.sym.FldNamesSym())) {
                this.lineMode = 3;
                return;
            } else if (String_.Eq(string, this.sym.FldTypesSym())) {
                this.lineMode = 4;
                return;
            } else {
                if (!String_.Eq(string, this.sym.CommentSym())) throw Err_.new_wo_type("unknown dsv cmd", "cmd", string);
                this.lineMode = 1;
            }
        }
    }

    void ProcessLine(CharStream charStream, boolean bl) {
        if (this.sb.Count() == 0 && this.tkns.Count() == 0) {
            if (this.csvOn) {
                if (bl) {
                    return;
                }
                this.ProcessFld(charStream);
            } else {
                this.lineMode = 5;
            }
        } else {
            this.ProcessFld(charStream);
        }
        if (this.cmdSeqOn) {
            this.cmdSeqOn = false;
            this.tkns.Add(this.sym.CmdDlm());
        }
        if (this.lineMode == 2) {
            this.bldr.MakeTblBgn(this.tkns);
        } else if (this.lineMode == 3) {
            this.bldr.MakeFldNames(this.tkns);
        } else if (this.lineMode == 4) {
            this.bldr.MakeFldTypes(this.tkns);
        } else if (this.lineMode == 1) {
            this.bldr.MakeComment(this.tkns);
        } else if (this.lineMode == 5) {
            this.bldr.MakeBlankLine();
        } else {
            this.bldr.MakeVals(this.tkns);
        }
        this.nextValType = 0;
        this.lineMode = 0;
    }

    @Internal
    protected static DsvParser dsv_() {
        return new DsvParser();
    }

    @Internal
    protected static DsvParser csv_(boolean bl, GfoFldList gfoFldList) {
        DsvParser dsvParser = new DsvParser();
        dsvParser.csvOn = true;
        dsvParser.lineMode = bl ? 3 : 0;
        List_adp list_adp = List_adp_.New();
        List_adp list_adp2 = List_adp_.New();
        for (int i = 0; i < gfoFldList.Count(); ++i) {
            GfoFld gfoFld = gfoFldList.Get_at(i);
            list_adp.Add(gfoFld.Key());
            list_adp2.Add(gfoFld.Type().Key());
        }
        dsvParser.bldr.MakeFldNames(list_adp);
        dsvParser.bldr.MakeFldTypes(list_adp2);
        return dsvParser;
    }
}

