/*
 * Decompiled with CFR 0.152.
 */
package gplx.gfui.ipts;

import gplx.Err_;
import gplx.Internal;
import gplx.String_;
import gplx.gfui.ipts.IptArg;
import gplx.gfui.ipts.IptEventType;
import gplx.gfui.ipts.IptEventType_;
import gplx.gfui.ipts.IptKey;
import gplx.gfui.ipts.IptKeyChain;
import gplx.gfui.ipts.IptKey_;
import gplx.gfui.ipts.IptMacro;
import gplx.gfui.ipts.IptMouseBtn;
import gplx.gfui.ipts.IptMouseBtn_;
import gplx.gfui.ipts.IptMouseMove;
import gplx.gfui.ipts.IptMouseWheel;
import gplx.gfui.ipts.IptMouseWheel_;

public class IptArg_ {
    public static final IptArg[] Ary_empty = new IptArg[0];
    public static final IptArg Null = null;
    public static final String Wildcard_key = "wildcard";
    public static IptArg Wildcard = new IptKey(Integer.MAX_VALUE, "wildcard");

    public static boolean Is_null_or_none(IptArg iptArg) {
        return iptArg == Null || iptArg == IptKey_.None;
    }

    public static IptArg[] Ary(IptArg ... iptArgArray) {
        return iptArgArray;
    }

    public static IptArg[] parse_ary_or_empty(String string) {
        IptArg[] iptArgArray = IptArg_.parse_ary_(string);
        int n = iptArgArray.length;
        for (int i = 0; i < n; ++i) {
            if (iptArgArray[i] != null) continue;
            return Ary_empty;
        }
        return iptArgArray;
    }

    public static IptArg[] parse_ary_(String string) {
        String[] stringArray = String_.Split(string, "|");
        int n = stringArray.length;
        if (n == 0) {
            return Ary_empty;
        }
        IptArg[] iptArgArray = new IptArg[n];
        for (int i = 0; i < n; ++i) {
            iptArgArray[i] = IptArg_.parse(String_.Trim(stringArray[i]));
        }
        return iptArgArray;
    }

    public static IptArg parse_chain_(String string) {
        return IptKeyChain.parse(string);
    }

    public static IptArg parse_or_none_(String string) {
        try {
            return String_.Eq(string, "") ? IptKey_.None : IptArg_.parse(string);
        }
        catch (Exception exception) {
            Err_.Noop(exception);
            return IptKey_.None;
        }
    }

    public static IptArg parse(String string) {
        if (String_.Has(string, ",")) {
            return IptKeyChain.parse(string);
        }
        String string2 = String_.GetStrBefore(string, ".");
        if (String_.Eq(string2, "wheel")) {
            return IptMouseWheel_.parse(string);
        }
        if (String_.Eq(string2, "mouse")) {
            return IptMouseBtn_.parse(string);
        }
        if (String_.Eq(string2, "key")) {
            return IptKey_.parse(string);
        }
        return IptMacro.Instance.parse(string);
    }

    @Internal
    protected static IptEventType EventType_default(IptArg iptArg) {
        Class<?> clazz = iptArg.getClass();
        if (clazz == IptKey.class || clazz == IptKeyChain.class) {
            return IptEventType_.KeyDown;
        }
        if (clazz == IptMouseBtn.class) {
            return IptEventType_.MouseUp;
        }
        if (clazz == IptMouseWheel.class) {
            return IptEventType_.MouseWheel;
        }
        if (clazz == IptMouseMove.class) {
            return IptEventType_.MouseMove;
        }
        throw Err_.new_unhandled(clazz);
    }

    @Internal
    protected static boolean EventType_match(IptArg iptArg, IptEventType iptEventType) {
        Class<?> clazz = iptArg.getClass();
        if (clazz == IptKey.class || clazz == IptKeyChain.class) {
            return iptEventType == IptEventType_.KeyDown || iptEventType == IptEventType_.KeyUp || iptEventType == IptEventType_.KeyDown;
        }
        if (clazz == IptMouseBtn.class) {
            return iptEventType == IptEventType_.MouseDown || iptEventType == IptEventType_.MouseUp || iptEventType == IptEventType_.MousePress;
        }
        if (clazz == IptMouseWheel.class) {
            return iptEventType == IptEventType_.MouseWheel;
        }
        if (clazz == IptMouseMove.class) {
            return iptEventType == IptEventType_.MouseMove;
        }
        throw Err_.new_unhandled(clazz);
    }
}

