/*
 * Decompiled with CFR 0.152.
 */
package gplx.gfui.imgs;

import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.String_;
import gplx.UsrDlg_;
import gplx.core.ios.IoUrlInfo_;
import gplx.gfui.SizeAdp;
import gplx.gfui.SizeAdp_;
import gplx.gfui.imgs.Gfui_svg_util;
import gplx.gfui.imgs.ImageAdp;
import gplx.gfui.imgs.ImageAdp_base;
import gplx.gfui.imgs.ImageAdp_txt;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageAdp_ {
    public static final ImageAdp Null = ImageAdp_.new_(10, 10);

    public static ImageAdp as_(Object object) {
        return object instanceof ImageAdp ? (ImageAdp)object : null;
    }

    public static ImageAdp cast(Object object) {
        try {
            return (ImageAdp)object;
        }
        catch (Exception exception) {
            throw Err_.new_type_mismatch_w_exc(exception, ImageAdp.class, object);
        }
    }

    public static ImageAdp new_(int n, int n2) {
        BufferedImage bufferedImage = ImageAdp_.getCompatibleImage(n, n2);
        return new ImageAdp_base(bufferedImage);
    }

    public static ImageAdp txt_mem_(Io_url io_url, SizeAdp sizeAdp) {
        return new ImageAdp_txt(io_url, sizeAdp);
    }

    public static ImageAdp txt_fil_(Io_url io_url) {
        String string = Io_mgr.Instance.LoadFilStr(io_url);
        SizeAdp sizeAdp = null;
        sizeAdp = String_.Eq(string, "") ? SizeAdp_.Zero : (String_.Eq(io_url.Ext(), ".svg") ? ImageAdp_.SizeOf_svg(io_url) : SizeAdp_.parse(string));
        return new ImageAdp_txt(io_url, sizeAdp);
    }

    public static SizeAdp SizeOf_svg(Io_url io_url) {
        return Gfui_svg_util.QuerySize(io_url);
    }

    public static ImageAdp file_(Io_url io_url) {
        if (io_url.EqNull()) {
            throw Err_.new_wo_type("cannot load image from null url", new Object[0]);
        }
        if (String_.Eq(io_url.Info().Key(), IoUrlInfo_.Mem.Key())) {
            return ImageAdp_.txt_fil_(io_url);
        }
        if (!Io_mgr.Instance.ExistsFil(io_url)) {
            return Null;
        }
        BufferedImage bufferedImage = null;
        try {
            File file = new File(io_url.Xto_api());
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "ui", "image load failed", "url", io_url.Xto_api());
        }
        return new ImageAdp_base(bufferedImage).Url_(io_url);
    }

    private static BufferedImage getCompatibleImage(int n, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2);
        return bufferedImage;
    }

    public static int MemorySize(ImageAdp imageAdp) {
        int n = imageAdp.Height() * imageAdp.Width();
        BufferedImage bufferedImage = (BufferedImage)imageAdp.Under();
        int n2 = ImageAdp_.BitsPerPixelCalc(bufferedImage.getType(), imageAdp.Url());
        return n * (n2 / 8);
    }

    static int BitsPerPixelCalc(int n, Io_url io_url) {
        if (n == 5) {
            return 24;
        }
        if (n == 6) {
            return 32;
        }
        if (n == 7) {
            return 32;
        }
        if (n == 12) {
            return 8;
        }
        if (n == 10) {
            return 8;
        }
        if (n == 13) {
            return 8;
        }
        if (n == 0) {
            return 8;
        }
        if (n == 2) {
            return 32;
        }
        if (n == 3) {
            return 32;
        }
        if (n == 4) {
            return 32;
        }
        if (n == 1) {
            return 32;
        }
        if (n == 9) {
            return 16;
        }
        if (n == 8) {
            return 16;
        }
        if (n == 11) {
            return 16;
        }
        UsrDlg_.Instance.Warn("unknown bits per pixel", "imageType", n, "url", io_url.Xto_api());
        return 8;
    }
}

