/*
 * Decompiled with CFR 0.152.
 */
package gplx.gfui.controls.windows;

import gplx.Err_;
import gplx.GfoMsg;
import gplx.GfoMsg_;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Object_;
import gplx.String_;
import gplx.UsrDlg_;
import gplx.gfml.GfmlDataNde;
import gplx.gfui.controls.customs.GfuiIoDialogUtl;
import gplx.gfui.controls.elems.GfuiElem;
import gplx.gfui.controls.standards.GfuiTextBox;
import gplx.gfui.controls.windows.GfoConsoleWin;
import gplx.gfui.controls.windows.GfuiWin;
import gplx.langs.gfs.GfsCore;

class GfoConsoleWinCmds
implements Gfo_invk {
    GfuiWin win;
    GfuiTextBox consoleFilBox;
    GfuiTextBox consoleBox;
    GfuiTextBox statusBox;
    GfuiTextBox resultBox;
    public static final String Invk_Exec = "Exec";
    public static final String Invk_Hide = "Hide";
    public static final String Invk_Save = "Save";
    public static final String Invk_Load = "Load";
    public static final String Invk_Help = "Help";
    public static final String Invk_Clear = "Clear";
    public static final String Invk_X_ = "X_";
    public static final String Invk_Y_ = "Y_";
    public static final String Invk_Width_ = "Width_";
    public static final String Invk_Height_ = "Height_";
    public static final String Invk_Enabled_ = "Enabled_";
    public static final String Invk_SaveUrl_ = "SaveUrl_";
    GfoConsoleWin owner;

    public void Owner_set(GfuiElem gfuiElem) {
        this.win = (GfuiWin)gfuiElem;
    }

    public void Init() {
        this.consoleFilBox = (GfuiTextBox)this.win.SubElems().Get_by("consoleFilBox");
        this.consoleBox = (GfuiTextBox)this.win.SubElems().Get_by("consoleBox");
        this.resultBox = (GfuiTextBox)this.win.SubElems().Get_by("resultBox");
        this.statusBox = (GfuiTextBox)this.win.SubElems().Get_by("statusBox");
        GfsCore.Instance.AddObj(this, "gfoConsoleWin");
        GfsCore.Instance.ExecRegy("gplx.gfui.GfoConsoleWin.ini");
    }

    public void Results_add(String string) {
        if (!String_.Has_at_end(string, "\n")) {
            string = string + "\n";
        }
        this.statusBox.Text_(this.statusBox.Text() + string);
        this.statusBox.SelBgn_set(String_.Len(this.statusBox.Text()) - 1);
    }

    void Hide() {
        this.win.Hide();
    }

    void Exec(GfoMsg gfoMsg) {
        String string = this.consoleBox.SelLen() == 0 ? this.consoleBox.Text() : this.consoleBox.SelText();
        String string2 = this.FixNewLines(string);
        GfoMsg gfoMsg2 = GfoMsg_.Null;
        try {
            gfoMsg2 = GfsCore.Instance.MsgParser().ParseToMsg(string2);
        }
        catch (Exception exception) {
            this.statusBox.Text_("invalid gfml " + Err_.Message_gplx_full(exception));
            return;
        }
        GfsCtx gfsCtx = GfsCtx.new_();
        Object object = GfsCore.Instance.ExecMany(gfsCtx, gfoMsg2);
        this.resultBox.Text_(Object_.Xto_str_strict_or_empty(object));
    }

    void Help() {
        this.statusBox.Text_("");
        if (this.consoleBox.SelLen() == 0) {
            return;
        }
        String string = "help:'" + this.consoleBox.SelText() + "';";
        String string2 = this.FixNewLines(string);
        GfoMsg gfoMsg = GfoMsg_.Null;
        try {
            gfoMsg = GfmlDataNde.XtoMsgNoRoot(string2);
        }
        catch (Exception exception) {
            this.statusBox.Text_("invalid gfml " + Err_.Message_gplx_full(exception));
            return;
        }
        GfsCtx gfsCtx = GfsCtx.new_();
        try {
            Object object = GfsCore.Instance.ExecOne(gfsCtx, gfoMsg);
            if (object != Gfo_invk_.Rv_handled && object != Gfo_invk_.Rv_unhandled) {
                UsrDlg_.Instance.Note(Object_.Xto_str_strict_or_empty(object), new Object[0]);
            }
        }
        catch (Exception exception) {
            this.statusBox.Text_("help failed " + Err_.Message_gplx_full(exception));
            return;
        }
    }

    void Save() {
        String string = this.consoleFilBox.Text();
        Io_url io_url = Io_url_.Empty;
        if (String_.Len_eq_0(string)) {
            io_url = GfuiIoDialogUtl.SelectFile();
            this.consoleFilBox.Text_(io_url.Raw());
            return;
        }
        io_url = Io_url_.new_any_(string);
        Io_mgr.Instance.SaveFilStr(io_url, this.consoleBox.Text());
    }

    void Load() {
        String string = this.consoleFilBox.Text();
        Io_url io_url = Io_url_.Empty;
        if (String_.Len_eq_0(string)) {
            io_url = Io_url_.Empty;
        } else {
            io_url = Io_url_.new_any_(string);
            io_url = io_url.OwnerDir();
        }
        Io_url io_url2 = GfuiIoDialogUtl.SelectFile(io_url);
        if (io_url2 == Io_url_.Empty) {
            return;
        }
        this.consoleBox.Text_(Io_mgr.Instance.LoadFilStr(io_url2));
    }

    String FixNewLines(String string) {
        string = String_.Replace(string, "\n", "\r\n");
        string = String_.Replace(string, "\r\r", "\r");
        return string;
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_Exec)) {
            this.Exec(gfoMsg);
        } else if (gfsCtx.Match(string, Invk_Hide)) {
            this.Hide();
        } else if (gfsCtx.Match(string, Invk_Save)) {
            this.Save();
        } else if (gfsCtx.Match(string, Invk_Load)) {
            this.Load();
        } else if (gfsCtx.Match(string, Invk_Help)) {
            this.Help();
        } else if (gfsCtx.Match(string, Invk_Clear)) {
            this.statusBox.Text_("");
        } else {
            if (gfsCtx.Match(string, "consoleBox")) {
                return this.consoleBox;
            }
            if (gfsCtx.Match(string, Invk_X_)) {
                int n2 = gfoMsg.ReadInt("v");
                if (gfsCtx.Deny()) {
                    return this;
                }
                this.win.X_(n2);
            } else if (gfsCtx.Match(string, Invk_Y_)) {
                int n3 = gfoMsg.ReadInt("v");
                if (gfsCtx.Deny()) {
                    return this;
                }
                this.win.Y_(n3);
            } else if (gfsCtx.Match(string, Invk_Width_)) {
                int n4 = gfoMsg.ReadInt("v");
                if (gfsCtx.Deny()) {
                    return this;
                }
                this.win.Width_(n4);
            } else if (gfsCtx.Match(string, Invk_Height_)) {
                int n5 = gfoMsg.ReadInt("v");
                if (gfsCtx.Deny()) {
                    return this;
                }
                this.win.Height_(n5);
            } else if (gfsCtx.Match(string, Invk_Enabled_)) {
                boolean bl = gfoMsg.ReadBool("v");
                if (gfsCtx.Deny()) {
                    return this;
                }
                this.owner.Enabled_(bl);
            } else if (gfsCtx.Match(string, Invk_SaveUrl_)) {
                Io_url io_url = gfoMsg.ReadIoUrl("v");
                if (gfsCtx.Deny()) {
                    return this;
                }
                this.consoleFilBox.Text_(io_url.Xto_api());
                this.consoleBox.Text_(Io_mgr.Instance.LoadFilStr(io_url));
            } else {
                return this.win.Invk(gfsCtx, n, string, gfoMsg);
            }
        }
        return this;
    }

    public GfoConsoleWinCmds(GfoConsoleWin gfoConsoleWin) {
        this.owner = gfoConsoleWin;
    }
}

