/*
 * Decompiled with CFR 0.152.
 */
package gplx.gfui.controls.customs;

import gplx.GfoMsg;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.gfui.PointAdp;
import gplx.gfui.PointAdp_;
import gplx.gfui.SizeAdp;
import gplx.gfui.SizeAdp_;
import gplx.gfui.controls.customs.IptBndArgsBldr;
import gplx.gfui.controls.elems.GfuiElem;
import gplx.gfui.controls.windows.GfuiWin;
import gplx.gfui.ipts.IptBnd;
import gplx.gfui.ipts.IptBnd_;
import gplx.gfui.ipts.IptEventData;
import gplx.gfui.ipts.IptEventType;
import gplx.gfui.ipts.IptEventType_;
import gplx.gfui.ipts.IptKey_;
import gplx.gfui.ipts.IptMouseBtn_;
import gplx.gfui.ipts.IptMouseMove;
import gplx.gfui.layouts.GftGrid;

class GfuiResizeFormBnd
implements IptBnd {
    List_adp args = List_adp_.New();
    boolean active = false;
    PointAdp lastPos = PointAdp_.Zero;
    Hash_adp hash = Hash_adp_.New();

    @Override
    public String Key() {
        return "gplx.gfui.resizeForm";
    }

    @Override
    public List_adp Ipts() {
        return this.args;
    }

    @Override
    public IptEventType EventTypes() {
        return IptEventType_.KeyDown.Add(IptEventType_.MouseDown).Add(IptEventType_.MouseUp).Add(IptEventType_.MouseMove);
    }

    @Override
    public void Exec(IptEventData iptEventData) {
        int n = iptEventData.EventType().Val();
        if (n == IptEventType_.KeyDown.Val()) {
            this.ExecKeyDown(iptEventData);
        } else if (n == IptEventType_.MouseDown.Val()) {
            this.ExecMouseDown(iptEventData);
        } else if (n == IptEventType_.MouseUp.Val()) {
            this.ExecMouseUp(iptEventData);
        } else if (n == IptEventType_.MouseMove.Val()) {
            this.ExecMouseMove(iptEventData);
        }
    }

    void ExecMouseDown(IptEventData iptEventData) {
        this.active = true;
        this.lastPos = iptEventData.MousePos();
    }

    void ExecMouseMove(IptEventData iptEventData) {
        if (!this.active) {
            return;
        }
        PointAdp pointAdp = iptEventData.MousePos().Op_subtract(this.lastPos);
        if (pointAdp.Eq(PointAdp_.Zero)) {
            return;
        }
        this.ResizeForm(iptEventData.Sender(), GfuiResizeFormBnd.XtoSize(pointAdp));
    }

    void ExecMouseUp(IptEventData iptEventData) {
        this.active = false;
    }

    void ExecKeyDown(IptEventData iptEventData) {
        SizeAdp sizeAdp = (SizeAdp)this.hash.Get_by(iptEventData.EventArg());
        this.ResizeForm(iptEventData.Sender(), sizeAdp);
    }

    void ResizeForm(GfuiElem gfuiElem, SizeAdp sizeAdp) {
        GfuiWin gfuiWin = gfuiElem.OwnerWin();
        SizeAdp sizeAdp2 = GfuiResizeFormBnd.Op_add(gfuiWin.Size(), sizeAdp);
        gfuiWin.Size_(sizeAdp2);
        GftGrid.LytExecRecur(gfuiWin);
        gfuiWin.Redraw();
    }

    static SizeAdp XtoSize(PointAdp pointAdp) {
        return SizeAdp_.new_(pointAdp.X(), pointAdp.Y());
    }

    static SizeAdp Op_add(SizeAdp sizeAdp, SizeAdp sizeAdp2) {
        return SizeAdp_.new_(sizeAdp.Width() + sizeAdp2.Width(), sizeAdp.Height() + sizeAdp2.Height());
    }

    @Override
    public Object Srl(GfoMsg gfoMsg) {
        return IptBnd_.Srl(gfoMsg, this);
    }

    public static GfuiResizeFormBnd new_() {
        return new GfuiResizeFormBnd();
    }

    GfuiResizeFormBnd() {
        this.args.Add_many(IptMouseBtn_.Right, IptMouseMove.AnyDirection);
        IptBndArgsBldr.AddWithData(this.args, this.hash, IptKey_.Ctrl.Add(IptKey_.Shift).Add(IptKey_.Up), SizeAdp_.new_(0, -10));
        IptBndArgsBldr.AddWithData(this.args, this.hash, IptKey_.Ctrl.Add(IptKey_.Shift).Add(IptKey_.Down), SizeAdp_.new_(0, 10));
        IptBndArgsBldr.AddWithData(this.args, this.hash, IptKey_.Ctrl.Add(IptKey_.Shift).Add(IptKey_.Left), SizeAdp_.new_(-10, 0));
        IptBndArgsBldr.AddWithData(this.args, this.hash, IptKey_.Ctrl.Add(IptKey_.Shift).Add(IptKey_.Right), SizeAdp_.new_(10, 0));
    }
}

