/*
 * Decompiled with CFR 0.152.
 */
package gplx.gflucene.searchers;

import gplx.Err_;
import gplx.Ordered_hash;
import gplx.gflucene.analyzers.Gflucene_analyzer_mgr_;
import gplx.gflucene.core.Gflucene_doc_data;
import gplx.gflucene.core.Gflucene_index_data;
import gplx.gflucene.searchers.Gflucene_searcher_qry;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.CustomScoreQuery;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.lukhnos.portmobile.file.Path;
import org.lukhnos.portmobile.file.Paths;

public class Gflucene_searcher_mgr {
    private Analyzer analyzer;
    private Directory index;

    public void Init(Gflucene_index_data gflucene_index_data) {
        this.analyzer = Gflucene_analyzer_mgr_.New_analyzer(gflucene_index_data.analyzer_data.key);
        Path path = Paths.get((String)gflucene_index_data.index_dir);
        try {
            this.index = FSDirectory.open((Path)path);
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "lucene_index", "failed to init searcher", "dir", gflucene_index_data.index_dir);
        }
    }

    public void Exec(Ordered_hash ordered_hash, Gflucene_searcher_qry gflucene_searcher_qry) {
        try {
            DirectoryReader directoryReader = DirectoryReader.open((Directory)this.index);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)directoryReader);
            Query query = MultiFieldQueryParser.parse((String)gflucene_searcher_qry.query, (String[])new String[]{"body"}, (BooleanClause.Occur[])new BooleanClause.Occur[]{BooleanClause.Occur.SHOULD}, (Analyzer)this.analyzer);
            FunctionQuery functionQuery = new FunctionQuery((ValueSource)new LongFieldSource("page_score"));
            CustomScoreQuery customScoreQuery = new CustomScoreQuery(query, functionQuery);
            TopDocs topDocs = indexSearcher.search((Query)customScoreQuery, gflucene_searcher_qry.match_max);
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            for (int i = 0; i < scoreDocArray.length; ++i) {
                int n = scoreDocArray[i].doc;
                Document document = indexSearcher.doc(n);
                String string = document.get("title");
                Gflucene_doc_data gflucene_doc_data = (Gflucene_doc_data)ordered_hash.Get_by(string);
                if (gflucene_doc_data != null) continue;
                int n2 = Integer.parseInt(document.get("page_id"));
                gflucene_doc_data = new Gflucene_doc_data(n2, 0, string, "");
                gflucene_doc_data.lucene_score = scoreDocArray[i].score;
                ordered_hash.Add(n2, gflucene_doc_data);
            }
            directoryReader.close();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "lucene_index", "failed to exec seearch", "query", gflucene_searcher_qry.query);
        }
    }

    public void Term() {
    }
}

