/*
 * Decompiled with CFR 0.152.
 */
package gplx.gflucene.highlighters;

import gplx.Err_;
import gplx.gflucene.analyzers.Gflucene_analyzer_mgr_;
import gplx.gflucene.core.Gflucene_doc_data;
import gplx.gflucene.core.Gflucene_index_data;
import gplx.gflucene.highlighters.Gflucene_highlighter_item;
import gplx.gflucene.searchers.Gflucene_searcher_qry;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;

public class Gflucene_highlighter_mgr {
    private Analyzer analyzer;

    public void Init(Gflucene_index_data gflucene_index_data) {
        this.analyzer = Gflucene_analyzer_mgr_.New_analyzer(gflucene_index_data.analyzer_data.key);
    }

    public Gflucene_highlighter_item[] Exec(Gflucene_searcher_qry gflucene_searcher_qry, Gflucene_doc_data gflucene_doc_data) {
        TextFragment[] textFragmentArray;
        QueryParser queryParser = new QueryParser("body", this.analyzer);
        Query query = null;
        try {
            query = queryParser.parse(gflucene_searcher_qry.query);
        }
        catch (ParseException parseException) {
            throw Err_.new_exc((Exception)((Object)parseException), "lucene_index", "failed to parse", "query", gflucene_searcher_qry.query);
        }
        SimpleHTMLFormatter simpleHTMLFormatter = new SimpleHTMLFormatter("<span class='snip_highlight'>", "</span>");
        QueryScorer queryScorer = new QueryScorer(query);
        queryScorer.setExpandMultiTermQuery(false);
        Highlighter highlighter = new Highlighter((Formatter)simpleHTMLFormatter, (Scorer)queryScorer);
        SimpleFragmenter simpleFragmenter = new SimpleFragmenter(100);
        highlighter.setTextFragmenter((Fragmenter)simpleFragmenter);
        String string = gflucene_doc_data.body;
        TokenStream tokenStream = null;
        try {
            tokenStream = this.analyzer.tokenStream("body", string);
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "lucene_index", "failed to get stream", "query", gflucene_searcher_qry.query);
        }
        try {
            textFragmentArray = highlighter.getBestTextFragments(tokenStream, string, true, 10);
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "lucene_index", "failed to get best", "query", gflucene_searcher_qry.query);
        }
        catch (InvalidTokenOffsetsException invalidTokenOffsetsException) {
            throw Err_.new_exc((Exception)((Object)invalidTokenOffsetsException), "lucene_index", "failed to get best", "query", gflucene_searcher_qry.query);
        }
        int n = textFragmentArray.length;
        Gflucene_highlighter_item[] gflucene_highlighter_itemArray = new Gflucene_highlighter_item[n];
        for (int i = 0; i < n; ++i) {
            String string2 = textFragmentArray[i].toString();
            gflucene_highlighter_itemArray[i] = new Gflucene_highlighter_item(i, string2);
        }
        return gflucene_highlighter_itemArray;
    }

    public void Term() {
    }
}

