/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.qrys;

import gplx.DateAdp;
import gplx.Decimal_adp;
import gplx.Err_;
import gplx.String_;
import gplx.Virtual;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.stores.DataRdr;
import gplx.core.stores.DataRdr_;
import gplx.dbs.Db_qry;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.engines.Db_engine;
import gplx.dbs.qrys.Db_qry__select_in_tbl;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.Timestamp;

public class Db_stmt_cmd
implements Db_stmt {
    private static final String Key_na = "";
    private Db_engine engine;
    private PreparedStatement stmt = null;
    private String sql;
    private int val_idx = 0;

    public Db_stmt_cmd(Db_engine db_engine, Db_qry db_qry) {
        this.Ctor_stmt(db_engine, db_qry);
    }

    @Override
    public void Ctor_stmt(Db_engine db_engine, Db_qry db_qry) {
        this.engine = db_engine;
        this.sql = db_qry.Tid() == 5 ? ((Db_qry__select_in_tbl)db_qry).To_sql__exec(db_engine.Sql_wtr()) : db_engine.Sql_wtr().To_sql_str(db_qry, true);
        this.Reset_stmt();
    }

    @Override
    public Db_stmt Reset_stmt() {
        this.stmt = (PreparedStatement)this.engine.Stmt_by_sql(this.sql);
        return this;
    }

    @Override
    public Db_stmt Crt_bool_as_byte(String string, boolean bl) {
        return this.Add_byte_by_bool(true, string, bl);
    }

    @Override
    public Db_stmt Val_bool_as_byte(String string, boolean bl) {
        return this.Add_byte_by_bool(false, string, bl);
    }

    @Override
    public Db_stmt Val_bool_as_byte(boolean bl) {
        return this.Add_byte_by_bool(false, Key_na, bl);
    }

    private Db_stmt Add_byte_by_bool(boolean bl, String string, boolean bl2) {
        return this.Add_byte(bl, string, bl2 ? (byte)1 : 0);
    }

    @Override
    public Db_stmt Crt_byte(String string, byte by) {
        return this.Add_byte(true, string, by);
    }

    @Override
    public Db_stmt Val_byte(String string, byte by) {
        return this.Add_byte(false, string, by);
    }

    @Override
    public Db_stmt Val_byte(byte by) {
        return this.Add_byte(false, Key_na, by);
    }

    private Db_stmt Add_byte(boolean bl, String string, byte by) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setByte(++this.val_idx, by);
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "byte", "val", by, "sql", this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_int(String string, int n) {
        return this.Add_int(true, string, n);
    }

    @Override
    public Db_stmt Val_int_by_bool(String string, boolean bl) {
        return this.Add_int(false, string, bl ? 1 : 0);
    }

    @Override
    public Db_stmt Val_int(String string, int n) {
        return this.Add_int(false, string, n);
    }

    @Override
    public Db_stmt Val_int(int n) {
        return this.Add_int(false, Key_na, n);
    }

    private Db_stmt Add_int(boolean bl, String string, int n) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setInt(++this.val_idx, n);
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "int", "val", n, "sql", this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_long(String string, long l) {
        return this.Add_long(true, string, l);
    }

    @Override
    public Db_stmt Val_long(String string, long l) {
        return this.Add_long(false, string, l);
    }

    @Override
    public Db_stmt Val_long(long l) {
        return this.Add_long(false, Key_na, l);
    }

    private Db_stmt Add_long(boolean bl, String string, long l) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setLong(++this.val_idx, l);
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "long", "val", l, "sql", this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_float(String string, float f) {
        return this.Add_float(true, string, f);
    }

    @Override
    public Db_stmt Val_float(String string, float f) {
        return this.Add_float(false, string, f);
    }

    @Override
    public Db_stmt Val_float(float f) {
        return this.Add_float(false, Key_na, f);
    }

    private Db_stmt Add_float(boolean bl, String string, float f) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setFloat(++this.val_idx, f);
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "float", "val", Float.valueOf(f), "sql", this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_double(String string, double d) {
        return this.Add_double(true, string, d);
    }

    @Override
    public Db_stmt Val_double(String string, double d) {
        return this.Add_double(false, string, d);
    }

    @Override
    public Db_stmt Val_double(double d) {
        return this.Add_double(false, Key_na, d);
    }

    private Db_stmt Add_double(boolean bl, String string, double d) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setDouble(++this.val_idx, d);
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "double", "val", d, "sql", this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_decimal(String string, Decimal_adp decimal_adp) {
        return this.Add_decimal(true, string, decimal_adp);
    }

    @Override
    public Db_stmt Val_decimal(String string, Decimal_adp decimal_adp) {
        return this.Add_decimal(false, string, decimal_adp);
    }

    @Override
    public Db_stmt Val_decimal(Decimal_adp decimal_adp) {
        return this.Add_decimal(false, Key_na, decimal_adp);
    }

    private Db_stmt Add_decimal(boolean bl, String string, Decimal_adp decimal_adp) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setBigDecimal(++this.val_idx, decimal_adp.Under_as_native());
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "decimal", "val", decimal_adp, "sql", this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_bry(String string, byte[] byArray) {
        return this.Add_bry(true, string, byArray);
    }

    @Override
    public Db_stmt Val_bry(String string, byte[] byArray) {
        return this.Add_bry(false, string, byArray);
    }

    @Override
    public Db_stmt Val_bry(byte[] byArray) {
        return this.Add_bry(false, Key_na, byArray);
    }

    private Db_stmt Add_bry(boolean bl, String string, byte[] byArray) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setBytes(++this.val_idx, byArray);
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "byte[]", byArray.length, this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_bry_as_str(String string, byte[] byArray) {
        return this.Add_bry_as_str(true, string, byArray);
    }

    @Override
    public Db_stmt Val_bry_as_str(String string, byte[] byArray) {
        return this.Add_bry_as_str(false, string, byArray);
    }

    @Override
    public Db_stmt Val_bry_as_str(byte[] byArray) {
        return this.Add_bry_as_str(false, Key_na, byArray);
    }

    private Db_stmt Add_bry_as_str(boolean bl, String string, byte[] byArray) {
        return this.Add_str(bl, string, String_.new_u8(byArray));
    }

    @Override
    public Db_stmt Crt_str(String string, String string2) {
        return this.Add_str(true, string, string2);
    }

    @Override
    public Db_stmt Val_str(String string, String string2) {
        return this.Add_str(false, string, string2);
    }

    @Override
    public Db_stmt Val_str(String string) {
        return this.Add_str(false, Key_na, string);
    }

    @Virtual
    protected Db_stmt Add_str(boolean bl, String string, String string2) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setString(++this.val_idx, string2);
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "String", "val", string2, "sql", this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_date(String string, DateAdp dateAdp) {
        return this.Add_date(true, string, dateAdp);
    }

    @Override
    public Db_stmt Val_date(String string, DateAdp dateAdp) {
        return this.Add_date(false, string, dateAdp);
    }

    @Virtual
    protected Db_stmt Add_date(boolean bl, String string, DateAdp dateAdp) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setTimestamp(++this.val_idx, new Timestamp(dateAdp.UnderDateTime().getTime().getTime()));
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "date", "val", dateAdp, "sql", this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_text(String string, String string2) {
        return this.Add_text(true, string, string2);
    }

    @Override
    public Db_stmt Val_text(String string, String string2) {
        return this.Add_text(false, string, string2);
    }

    private Db_stmt Add_text(boolean bl, String string, String string2) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return this;
        }
        try {
            this.stmt.setString(++this.val_idx, string2);
        }
        catch (Exception exception) {
            this.Rls();
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "text", "val", string2, "sql", this.sql);
        }
        return this;
    }

    @Override
    public Db_stmt Val_rdr_(Io_stream_rdr io_stream_rdr, long l) {
        try {
            this.stmt.setBinaryStream(++this.val_idx, (InputStream)io_stream_rdr.Under(), (int)l);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "rdr", "val", io_stream_rdr);
        }
        return this;
    }

    @Override
    public boolean Exec_insert() {
        try {
            boolean bl = this.stmt.execute();
            return bl;
        }
        catch (Exception exception) {
            this.Rls();
            this.Reset_stmt();
            throw Err_.new_exc(exception, "db_stmt", "insert failed", "url", this.engine.Conn_info().Db_api(), "sql", this.sql);
        }
    }

    @Override
    public int Exec_update() {
        try {
            int n = this.stmt.executeUpdate();
            return n;
        }
        catch (Exception exception) {
            this.Rls();
            this.Reset_stmt();
            throw Err_.new_exc(exception, "db_stmt", "update failed", "url", this.engine.Conn_info().Db_api(), "sql", this.sql);
        }
    }

    @Override
    public int Exec_delete() {
        try {
            int n = this.stmt.executeUpdate();
            return n;
        }
        catch (Exception exception) {
            this.Rls();
            this.Reset_stmt();
            throw Err_.new_exc(exception, "db_stmt", "delete failed", "url", this.engine.Conn_info().Db_api(), "sql", this.sql);
        }
    }

    @Override
    public DataRdr Exec_select() {
        try {
            DataRdr dataRdr = this.engine.New_rdr(this.stmt.executeQuery(), this.sql);
            return dataRdr;
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to exec prepared statement", "sql", this.sql);
        }
    }

    @Override
    public Db_rdr Exec_select__rls_auto() {
        try {
            return this.engine.Exec_as_rdr__rls_auto(this, this.stmt.executeQuery(), this.sql);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "select failed", "sql", this.sql);
        }
    }

    @Override
    public Db_rdr Exec_select__rls_manual() {
        try {
            return this.engine.Exec_as_rdr__rls_manual(this.stmt.executeQuery(), this.sql);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "select failed", "sql", this.sql);
        }
    }

    @Override
    public Object Exec_select_val() {
        try {
            Object object = DataRdr_.Read_1st_row_and_1st_fld(this.engine.New_rdr(this.stmt.executeQuery(), this.sql));
            return object;
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to exec prepared statement", "sql", this.sql);
        }
    }

    @Override
    public Db_stmt Clear() {
        this.val_idx = 0;
        try {
            this.stmt.clearBatch();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to clear parameters", "sql", this.sql);
        }
        return this;
    }

    @Override
    public void Rls() {
        if (this.stmt == null) {
            return;
        }
        try {
            if (this.stmt.getConnection().isClosed()) {
                return;
            }
            this.stmt.close();
            this.stmt = null;
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to close command", "sql", this.sql);
        }
    }
}

