/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines.tdbs;

import gplx.Err_;
import gplx.Internal;
import gplx.Io_url;
import gplx.Ordered_hash_base;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoFldList_;
import gplx.core.stores.DataRdr;
import gplx.core.stores.DataWtr;
import gplx.core.type_xtns.IntClassXtn;
import gplx.core.type_xtns.StringClassXtn;
import gplx.dbs.engines.tdbs.TdbFile;
import gplx.dbs.engines.tdbs.TdbFileList;
import gplx.dbs.engines.tdbs.TdbStores;
import gplx.dbs.engines.tdbs.TdbTable;
import gplx.langs.dsvs.DsvStoreLayout;

public class TdbTableList
extends Ordered_hash_base {
    DsvStoreLayout layout;
    public static final String StoreTableName = "_tables";
    static final String Fld_id = "id";
    static final String Fld_name = "name";
    static final String Fld_file_id = "file_id";
    static final GfoFldList FldList = GfoFldList_.new_().Add("id", IntClassXtn.Instance).Add("name", StringClassXtn.Instance).Add("file_id", IntClassXtn.Instance);

    public TdbTable Get_by(String string) {
        return TdbTable.as_(this.Fetch_base(string));
    }

    public TdbTable Get_by_or_fail(String string) {
        TdbTable tdbTable = TdbTable.as_(this.Get_by(string));
        if (tdbTable == null) {
            throw Err_.new_wo_type("could not find table; database file may not exist", "table", string);
        }
        return tdbTable;
    }

    public void Add(TdbTable tdbTable) {
        this.Add_base(tdbTable.Name(), tdbTable);
    }

    public static TdbTableList new_(Io_url io_url) {
        TdbTableList tdbTableList = new TdbTableList();
        tdbTableList.layout = DsvStoreLayout.dsv_full_();
        return tdbTableList;
    }

    @Internal
    protected void DataObj_Wtr(DataWtr dataWtr) {
        dataWtr.InitWtr("StoreLayoutWtr", this.layout);
        dataWtr.WriteTableBgn(StoreTableName, FldList);
        for (Object e : this) {
            TdbTable tdbTable = (TdbTable)e;
            dataWtr.WriteLeafBgn("tbl");
            dataWtr.WriteData(Fld_id, tdbTable.Id());
            dataWtr.WriteData(Fld_name, tdbTable.Name());
            dataWtr.WriteData(Fld_file_id, tdbTable.File().Id());
            dataWtr.WriteLeafEnd();
        }
        dataWtr.WriteNodeEnd();
    }

    @Internal
    protected void DataObj_Rdr(DataRdr dataRdr, TdbFileList tdbFileList) {
        this.layout = TdbStores.FetchLayout(dataRdr);
        DataRdr dataRdr2 = dataRdr.Subs();
        this.Clear();
        while (dataRdr2.MoveNextPeer()) {
            int n = dataRdr2.ReadInt(Fld_id);
            String string = dataRdr2.ReadStr(Fld_name);
            int n2 = dataRdr2.ReadInt(Fld_file_id);
            TdbFile tdbFile = tdbFileList.Get_by_or_fail(n2);
            TdbTable tdbTable = TdbTable.load_(n, string, tdbFile);
            this.Add(tdbTable);
        }
    }
}

