/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines.tdbs;

import gplx.Internal;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Ordered_hash_base;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoFldList_;
import gplx.core.stores.DataRdr;
import gplx.core.stores.DataWtr;
import gplx.core.type_xtns.IntClassXtn;
import gplx.core.type_xtns.StringClassXtn;
import gplx.dbs.engines.tdbs.TdbFile;
import gplx.dbs.engines.tdbs.TdbStores;
import gplx.langs.dsvs.DsvStoreLayout;

public class TdbFileList
extends Ordered_hash_base {
    Io_url dbInfo;
    DsvStoreLayout layout;
    public static final String StoreTblName = "_files";
    static final String Fld_id = "id";
    static final String Fld_path = "url";
    static final GfoFldList FldList = GfoFldList_.new_().Add("id", IntClassXtn.Instance).Add("url", StringClassXtn.Instance).Add("format", StringClassXtn.Instance);

    public TdbFile Get_by_or_fail(int n) {
        return TdbFile.as_(this.Get_by_or_fail_base(n));
    }

    public void Add(TdbFile tdbFile) {
        this.Add_base(tdbFile.Id(), tdbFile);
    }

    public static TdbFileList new_(Io_url io_url, TdbFile tdbFile) {
        TdbFileList tdbFileList = new TdbFileList();
        tdbFileList.dbInfo = io_url;
        tdbFileList.Add(tdbFile);
        tdbFileList.layout = DsvStoreLayout.dsv_full_();
        return tdbFileList;
    }

    TdbFileList() {
    }

    @Internal
    protected void DataObj_Wtr(DataWtr dataWtr) {
        dataWtr.InitWtr("StoreLayoutWtr", this.layout);
        dataWtr.WriteTableBgn(StoreTblName, FldList);
        for (Object e : this) {
            TdbFile tdbFile = (TdbFile)e;
            dataWtr.WriteLeafBgn("fil");
            dataWtr.WriteData(Fld_id, tdbFile.Id());
            dataWtr.WriteData(Fld_path, tdbFile.Path());
            dataWtr.WriteData("format", "dsv");
            dataWtr.WriteLeafEnd();
        }
        dataWtr.WriteNodeEnd();
    }

    @Internal
    protected void DataObj_Rdr(DataRdr dataRdr) {
        this.layout = TdbStores.FetchLayout(dataRdr);
        this.Clear();
        DataRdr dataRdr2 = dataRdr.Subs();
        while (dataRdr2.MoveNextPeer()) {
            int n = dataRdr2.ReadInt(Fld_id);
            String string = dataRdr2.ReadStrOr(Fld_path, this.dbInfo.Raw());
            TdbFile tdbFile = n == 1 ? TdbFile.new_(1, this.dbInfo) : TdbFile.new_(n, Io_url_.new_any_(string));
            this.Add(tdbFile);
        }
    }
}

