/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines.sqlite;

import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.Internal;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Keyval;
import gplx.Keyval_;
import gplx.String_;
import gplx.core.ios.IoItmFil;
import gplx.core.stores.DataRdr;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_conn_info;
import gplx.dbs.Db_qry;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.engines.Db_engine;
import gplx.dbs.engines.Db_engine_sql_base;
import gplx.dbs.engines.sqlite.Db_rdr__sqlite;
import gplx.dbs.engines.sqlite.Sqlite_conn_info;
import gplx.dbs.engines.sqlite.Sqlite_engine_;
import gplx.dbs.engines.sqlite.Sqlite_rdr;
import gplx.dbs.engines.sqlite.Sqlite_schema_mgr;
import gplx.dbs.engines.sqlite.Sqlite_stmt;
import gplx.dbs.engines.sqlite.Sqlite_txn_mgr;
import gplx.dbs.metas.Dbmeta_tbl_mgr;
import gplx.dbs.sqls.Sql_qry_wtr;
import gplx.dbs.sqls.Sql_qry_wtr_;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlite.SQLiteConnection;

public class Sqlite_engine
extends Db_engine_sql_base {
    private final Sqlite_txn_mgr txn_mgr = new Sqlite_txn_mgr(this);
    private final Sqlite_schema_mgr schema_mgr = new Sqlite_schema_mgr(this);
    private static boolean loaded = false;
    public static final Sqlite_engine Instance = new Sqlite_engine();

    Sqlite_engine() {
    }

    @Override
    public String Tid() {
        return "sqlite";
    }

    @Override
    public Sql_qry_wtr Sql_wtr() {
        return Sql_qry_wtr_.New__sqlite();
    }

    @Override
    public Db_engine New_clone(Db_conn_info db_conn_info) {
        Sqlite_engine sqlite_engine = new Sqlite_engine();
        sqlite_engine.Ctor(db_conn_info);
        return sqlite_engine;
    }

    @Override
    public DataRdr New_rdr(ResultSet resultSet, String string) {
        return Sqlite_rdr.new_(resultSet, string);
    }

    @Override
    public Db_rdr New_rdr_clone() {
        return new Db_rdr__sqlite();
    }

    @Override
    public void Env_db_attach(String string, Db_conn db_conn) {
        Db_conn_info db_conn_info = db_conn.Conn_info();
        if (!String_.Eq(db_conn_info.Key(), "sqlite")) {
            throw Err_.new_("dbs", "must attach to sqlite databases", "conn", db_conn_info.Raw());
        }
        Sqlite_conn_info sqlite_conn_info = (Sqlite_conn_info)db_conn_info;
        this.Env_db_attach(string, sqlite_conn_info.Url());
    }

    @Override
    public void Env_db_attach(String string, Io_url io_url) {
        this.Exec_as_int(String_.Format("ATTACH '{0}' AS {1};", io_url.Raw(), string));
    }

    @Override
    public void Env_db_detach(String string) {
        this.Exec_as_int(String_.Format("DETACH {0};", string));
    }

    @Override
    public void Txn_bgn(String string) {
        this.txn_mgr.Txn_bgn(string);
    }

    @Override
    public String Txn_end() {
        return this.txn_mgr.Txn_end();
    }

    @Override
    public void Txn_cxl() {
        this.txn_mgr.Txn_cxl();
    }

    @Override
    public void Txn_sav() {
        this.txn_mgr.Txn_sav();
    }

    @Override
    public Dbmeta_tbl_mgr Meta_mgr() {
        return this.schema_mgr.Tbl_mgr();
    }

    @Override
    public boolean Meta_tbl_exists(String string) {
        return this.schema_mgr.Tbl_exists(string);
    }

    @Override
    public boolean Meta_fld_exists(String string, String string2) {
        return this.schema_mgr.Fld_exists(string, string2);
    }

    @Override
    public boolean Meta_idx_exists(String string) {
        return this.schema_mgr.Idx_exists(string);
    }

    @Override
    public Db_stmt Stmt_by_qry(Db_qry db_qry) {
        return new Sqlite_stmt(this, db_qry);
    }

    protected void Meta_tbl_gather_hook() {
        throw Err_.new_unimplemented();
    }

    @Override
    @Internal
    protected Connection Conn_make() {
        Keyval[] keyvalArray;
        if (!loaded) {
            try {
                Class.forName("org.sqlite.JDBC");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw Err_.new_exc(classNotFoundException, "db", "could not load sqlite jdbc driver", new Object[0]);
            }
            loaded = true;
        }
        Sqlite_conn_info sqlite_conn_info = (Sqlite_conn_info)this.conn_info;
        Io_url io_url = sqlite_conn_info.Url();
        String string = "jdbc:sqlite://" + String_.Replace(io_url.Raw(), "\\", "/");
        IoItmFil ioItmFil = Io_mgr.Instance.QueryFil(io_url);
        boolean bl = ioItmFil.Exists() && Io_mgr.Instance.Query_read_only(io_url, Sqlite_engine_.Read_only_detection);
        Keyval[] keyvalArray2 = keyvalArray = bl ? Keyval_.Ary(Keyval_.new_("open_mode", "1")) : Keyval_.Ary_empty;
        if (bl) {
            Gfo_usr_dlg_.Instance.Note_many("", "", "Sqlite db opened as read-only: url=~{0}", io_url.Xto_api());
        }
        Connection connection = this.Conn__new_by_url_and_props(string, keyvalArray);
        SQLiteConnection sQLiteConnection = (SQLiteConnection)connection;
        try {
            sQLiteConnection.setBusyTimeout(10000);
        }
        catch (SQLException sQLException) {
            Gfo_usr_dlg_.Instance.Warn_many("", "", "failed to set busy timeout; err=~{0}", Err_.Message_gplx_log(sQLException));
        }
        return connection;
    }
}

