/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.diffs.builds;

import gplx.dbs.Db_conn;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.Dbmeta_tbl_itm;
import gplx.dbs.diffs.Gdif_db;
import gplx.dbs.diffs.Gfdb_diff_tbl;
import gplx.dbs.diffs.Gfdb_rdr_utl_;
import gplx.dbs.diffs.builds.Gdif_bldr_ctx;
import gplx.dbs.diffs.builds.Gfdb_diff_wkr;
import gplx.dbs.diffs.builds.Gfdb_diff_wkr__db_;

public class Gfdb_diff_wkr__db
implements Gfdb_diff_wkr {
    private Dbmeta_fld_itm[] val_flds;
    private int val_flds_len;
    private Gfdb_diff_tbl tbl;
    private Db_rdr old_rdr;
    private Db_rdr new_rdr;
    private Gdif_bldr_ctx ctx;
    private Db_conn dif_conn;
    private Db_stmt stmt;
    private int uid;
    private int prog_interval;
    private int prog_count;
    private boolean cmd_create;

    public void Init_conn(Gdif_db gdif_db, int n) {
        this.dif_conn = gdif_db.Conn();
        this.prog_interval = n;
    }

    @Override
    public void Init_rdrs(Gdif_bldr_ctx gdif_bldr_ctx, Gfdb_diff_tbl gfdb_diff_tbl, Db_rdr db_rdr, Db_rdr db_rdr2) {
        this.ctx = gdif_bldr_ctx;
        this.tbl = gfdb_diff_tbl;
        this.old_rdr = db_rdr;
        this.new_rdr = db_rdr2;
        this.val_flds = gfdb_diff_tbl.Vals;
        this.val_flds_len = this.val_flds.length;
        this.uid = 0;
        this.prog_count = 0;
        String string = gfdb_diff_tbl.Name;
        Dbmeta_fld_itm[] dbmeta_fld_itmArray = Gfdb_diff_wkr__db_.New_dif_flds(gfdb_diff_tbl.Flds);
        if (!this.dif_conn.Meta_tbl_exists(string)) {
            this.dif_conn.Meta_tbl_create(Dbmeta_tbl_itm.New(string, dbmeta_fld_itmArray));
        }
        this.stmt = this.dif_conn.Stmt_insert(string, Gfdb_diff_wkr__db_.To_str_ary(dbmeta_fld_itmArray));
        this.dif_conn.Txn_bgn("dif_db_tbl_" + string);
        this.cmd_create = true;
    }

    @Override
    public void Term_tbls() {
        this.dif_conn.Txn_end();
    }

    @Override
    public void Handle_old_missing() {
        this.Insert((byte)0, ++this.uid, this.new_rdr, this.tbl.Flds);
    }

    @Override
    public void Handle_new_missing() {
        this.Insert((byte)2, ++this.uid, this.old_rdr, this.tbl.Flds);
    }

    @Override
    public void Handle_same() {
        if (Gfdb_rdr_utl_.Compare(this.val_flds, this.val_flds_len, this.old_rdr, this.new_rdr) != 0) {
            this.Insert((byte)1, ++this.uid, this.new_rdr, this.tbl.Flds);
        }
    }

    private void Insert(byte by, int n, Db_rdr db_rdr, Dbmeta_fld_itm[] dbmeta_fld_itmArray) {
        if (this.cmd_create) {
            this.cmd_create = false;
            this.ctx.Cur_cmd = this.ctx.Core.New_cmd(this.ctx, 1);
            this.ctx.Cur_txn = this.ctx.Core.New_txn(this.ctx, this.ctx.Cur_cmd.Cmd_id, 0);
        }
        this.stmt.Clear();
        this.stmt.Val_int("dif_txn", this.ctx.Cur_txn.Txn_id).Val_int("dif_uid", n).Val_int("dif_type", by).Val_int("dif_db_src", -1).Val_int("dif_db_trg", -1);
        Gfdb_rdr_utl_.Stmt_args(this.stmt, dbmeta_fld_itmArray, 0, dbmeta_fld_itmArray.length, db_rdr);
        this.stmt.Exec_insert();
        if (++this.prog_count % this.prog_interval == 0) {
            this.dif_conn.Txn_sav();
        }
    }
}

