/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.diffs.builds;

import gplx.Err_;
import gplx.dbs.Db_rdr;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.diffs.Gfdb_diff_tbl;
import gplx.dbs.diffs.Gfdb_rdr_utl_;

class Gfdb_diff_rdr_comparer {
    private Db_rdr old_rdr;
    private Db_rdr new_rdr;
    private boolean old_rdr_move;
    private boolean new_rdr_move;
    private boolean old_rdr_done;
    private boolean new_rdr_done;
    private Dbmeta_fld_itm[] key_flds;
    private int key_flds_len;
    public static final int Rslt__same = 0;
    public static final int Rslt__old_missing = 1;
    public static final int Rslt__new_missing = 2;
    public static final int Rslt__done = 3;

    Gfdb_diff_rdr_comparer() {
    }

    public void Init_rdrs(Gfdb_diff_tbl gfdb_diff_tbl, Db_rdr db_rdr, Db_rdr db_rdr2) {
        this.old_rdr = db_rdr;
        this.new_rdr = db_rdr2;
        this.new_rdr_move = true;
        this.old_rdr_move = true;
        this.new_rdr_done = false;
        this.old_rdr_done = false;
        this.key_flds = gfdb_diff_tbl.Keys;
        this.key_flds_len = this.key_flds.length;
    }

    public int Compare() {
        if (this.old_rdr_move) {
            this.old_rdr_move = this.old_rdr.Move_next();
            if (!this.old_rdr_move) {
                this.old_rdr_done = true;
            }
        }
        if (this.new_rdr_move) {
            this.new_rdr_move = this.new_rdr.Move_next();
            if (!this.new_rdr_move) {
                this.new_rdr_done = true;
            }
        }
        if (this.old_rdr_done && this.new_rdr_done) {
            return 3;
        }
        if (this.old_rdr_done) {
            this.new_rdr_move = true;
            return 1;
        }
        if (this.new_rdr_done) {
            this.old_rdr_move = true;
            return 2;
        }
        int n = Gfdb_rdr_utl_.Compare(this.key_flds, this.key_flds_len, this.old_rdr, this.new_rdr);
        switch (n) {
            case 0: {
                this.new_rdr_move = true;
                this.old_rdr_move = true;
                return 0;
            }
            case -1: {
                this.old_rdr_move = true;
                this.new_rdr_move = false;
                return 2;
            }
            case 1: {
                this.old_rdr_move = false;
                this.new_rdr_move = true;
                return 1;
            }
        }
        throw Err_.new_unhandled(n);
    }
}

