/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs;

import gplx.Err_;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_conn_info;
import gplx.dbs.Db_conn_info_;
import gplx.dbs.engines.Db_engine;
import gplx.dbs.engines.mems.Mem_engine;
import gplx.dbs.engines.mysql.Mysql_engine;
import gplx.dbs.engines.noops.Noop_engine;
import gplx.dbs.engines.postgres.Postgres_engine;
import gplx.dbs.engines.sqlite.Sqlite_engine;
import gplx.dbs.engines.tdbs.TdbEngine;
import gplx.dbs.qrys.bats.Db_batch_mgr;

public class Db_conn_pool {
    private final Ordered_hash hash = Ordered_hash_.New();
    private final Db_batch_mgr batch_mgr = new Db_batch_mgr();
    private final Hash_adp prime_hash = Hash_adp_.New();
    public static final Db_conn_pool Instance = new Db_conn_pool();

    public Db_batch_mgr Batch_mgr() {
        return this.batch_mgr;
    }

    public void Del(Db_conn_info db_conn_info) {
        this.hash.Del(db_conn_info.Db_api());
    }

    public Db_conn Get_or_new(String string) {
        return this.Get_or_new(Db_conn_info_.parse(string));
    }

    public Db_conn Get_or_new(Db_conn_info db_conn_info) {
        Db_conn db_conn = (Db_conn)this.hash.Get_by(db_conn_info.Db_api());
        if (db_conn == null) {
            Db_engine db_engine = (Db_engine)this.prime_hash.Get_by(db_conn_info.Key());
            if (db_engine == null) {
                Err_.new_wo_type("db engine prototype not found", "key", db_conn_info.Key());
            }
            Db_engine db_engine2 = db_engine.New_clone(db_conn_info);
            db_conn = new Db_conn(db_engine2);
            db_engine2.Batch_mgr().Copy(db_engine2.Tid(), this.batch_mgr);
            this.hash.Add(db_conn_info.Db_api(), db_conn);
        }
        return db_conn;
    }

    public void Add_existing(Db_conn db_conn) {
        this.hash.Add(db_conn.Conn_info().Db_api(), db_conn);
    }

    public void Rls_all() {
        int n;
        int n2 = this.hash.Len();
        Db_conn[] db_connArray = new Db_conn[n2];
        for (n = 0; n < n2; ++n) {
            db_connArray[n] = (Db_conn)this.hash.Get_at(n);
        }
        for (n = 0; n < n2; ++n) {
            db_connArray[n].Rls_conn();
        }
        this.hash.Clear();
    }

    Db_conn_pool() {
        this.Init();
    }

    public void Primes__add(Db_engine ... db_engineArray) {
        for (Db_engine db_engine : db_engineArray) {
            this.prime_hash.Add(db_engine.Tid(), db_engine);
        }
    }

    private void Init() {
        this.Primes__add(Noop_engine.Instance, Mem_engine.Instance, Sqlite_engine.Instance, Mysql_engine.Instance, Postgres_engine.Instance, TdbEngine.Instance);
    }
}

