/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs;

import gplx.Err_;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Keyval_hash;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.String_;
import gplx.dbs.Db_conn_info;
import gplx.dbs.engines.mems.Mem_conn_info;
import gplx.dbs.engines.mysql.Mysql_conn_info;
import gplx.dbs.engines.noops.Noop_conn_info;
import gplx.dbs.engines.postgres.Postgres_conn_info;
import gplx.dbs.engines.sqlite.Sqlite_conn_info;
import gplx.dbs.engines.tdbs.Tdb_conn_info;

class Db_conn_info_pool {
    private final Ordered_hash regy = Ordered_hash_.New();
    public static final Db_conn_info_pool Instance = new Db_conn_info_pool();

    public Db_conn_info_pool() {
        this.Add(Noop_conn_info.Instance).Add(Tdb_conn_info.Instance).Add(Mysql_conn_info.Instance).Add(Postgres_conn_info.Instance).Add(Sqlite_conn_info.Instance);
        this.Add(Mem_conn_info.Instance);
    }

    public Db_conn_info_pool Add(Db_conn_info db_conn_info) {
        this.regy.Add_if_dupe_use_nth(db_conn_info.Key(), db_conn_info);
        return this;
    }

    public Db_conn_info Parse(String string) {
        try {
            Keyval_hash keyval_hash = new Keyval_hash();
            String[] stringArray = String_.Split(string, ";");
            String string2 = "";
            for (String string3 : stringArray) {
                if (String_.Len(string3) == 0) continue;
                String[] stringArray2 = String_.Split(string3, "=");
                if (String_.Eq(stringArray2[0], "gplx_key")) {
                    string2 = stringArray2[1];
                    continue;
                }
                keyval_hash.Add(stringArray2[0], stringArray2[1]);
            }
            Db_conn_info db_conn_info = (Db_conn_info)this.regy.Get_by(string2);
            return db_conn_info.New_self(string, keyval_hash);
        }
        catch (Exception exception) {
            throw Err_.new_parse_exc(exception, Db_conn_info.class, string);
        }
    }

    public Db_conn_info Parse_or_sqlite_or_fail(String string) {
        Keyval_hash keyval_hash = new Keyval_hash();
        String[] stringArray = String_.Split(string, ";");
        String string2 = null;
        for (String string3 : stringArray) {
            if (String_.Len(string3) == 0) continue;
            String[] stringArray2 = String_.Split(string3, "=");
            String string4 = stringArray2[0];
            String string5 = stringArray2[1];
            if (String_.Eq(string4, "gplx_key")) {
                string2 = string5;
                continue;
            }
            keyval_hash.Add(string4, string5);
        }
        if (string2 == null) {
            Io_url io_url = null;
            try {
                io_url = Io_url_.new_any_(string);
            }
            catch (Exception exception) {
                throw Err_.new_exc(exception, "dbs", "invalid connection String", "raw", string);
            }
            keyval_hash.Clear();
            string2 = "sqlite";
            keyval_hash.Add("data source", io_url.Raw());
            keyval_hash.Add("version", "3");
        }
        Db_conn_info db_conn_info = (Db_conn_info)this.regy.Get_by(string2);
        return db_conn_info.New_self(string, keyval_hash);
    }
}

