/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs;

import gplx.Double_;
import gplx.Err_;
import gplx.Gfo_log_;
import gplx.Gfo_usr_dlg;
import gplx.Gfo_usr_dlg_;
import gplx.Int_;
import gplx.Io_url;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Rls_able;
import gplx.String_;
import gplx.core.stores.DataRdr;
import gplx.core.stores.DataRdr_;
import gplx.dbs.Db_conn_;
import gplx.dbs.Db_conn_info;
import gplx.dbs.Db_conn_pool;
import gplx.dbs.Db_crt_;
import gplx.dbs.Db_qry;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.Db_tbl;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.Dbmeta_fld_list;
import gplx.dbs.Dbmeta_fld_tid;
import gplx.dbs.Dbmeta_idx_itm;
import gplx.dbs.Dbmeta_tbl_itm;
import gplx.dbs.conn_props.Db_conn_props_mgr;
import gplx.dbs.engines.Db_engine;
import gplx.dbs.metas.Dbmeta_idx_fld;
import gplx.dbs.metas.Dbmeta_tbl_mgr;
import gplx.dbs.qrys.Db_qry__select_in_tbl;
import gplx.dbs.qrys.Db_qry_delete;
import gplx.dbs.qrys.Db_qry_insert;
import gplx.dbs.qrys.Db_qry_sql;
import gplx.dbs.qrys.Db_qry_update;
import gplx.dbs.qrys.bats.Db_batch_mgr;
import gplx.dbs.sys.Db_sys_mgr;

public class Db_conn {
    private final List_adp rls_list = List_adp_.New();
    private final Db_engine engine;
    private final Db_sys_mgr sys_mgr;

    public Db_conn(Db_engine db_engine) {
        this.engine = db_engine;
        this.sys_mgr = new Db_sys_mgr(this);
    }

    public Db_conn_info Conn_info() {
        return this.engine.Conn_info();
    }

    public Db_conn_props_mgr Props() {
        return this.engine.Props();
    }

    public Db_batch_mgr Batch_mgr() {
        return this.engine.Batch_mgr();
    }

    public Db_engine Engine() {
        return this.engine;
    }

    public Db_sys_mgr Sys_mgr() {
        return this.sys_mgr;
    }

    public boolean Eq(Db_conn db_conn) {
        return String_.Eq(this.engine.Conn_info().Db_api(), db_conn.Conn_info().Db_api());
    }

    public void Txn_bgn(String string) {
        this.engine.Txn_bgn(string);
    }

    public void Txn_end() {
        this.engine.Txn_end();
    }

    public void Txn_cxl() {
        this.engine.Txn_cxl();
    }

    public void Txn_sav() {
        this.engine.Txn_sav();
    }

    public void Env_db_attach(String string, Db_conn db_conn) {
        this.engine.Env_db_attach(string, db_conn);
    }

    public void Env_db_attach(String string, Io_url io_url) {
        this.engine.Env_db_attach(string, io_url);
    }

    public void Env_db_detach(String string) {
        this.engine.Env_db_detach(string);
    }

    public void Env_vacuum() {
        this.Exec_sql_plog_ntx("vacuuming: url=" + this.Conn_info().Db_api(), "VACUUM;");
    }

    public void Meta_tbl_create(Dbmeta_tbl_itm dbmeta_tbl_itm) {
        this.engine.Meta_tbl_create(dbmeta_tbl_itm);
        this.engine.Meta_idx_create(Gfo_usr_dlg_.Noop, dbmeta_tbl_itm.Idxs().To_ary());
    }

    public void Meta_tbl_delete(String string) {
        this.engine.Meta_tbl_delete(string);
    }

    public void Meta_tbl_remake_many(Db_tbl ... db_tblArray) {
        for (Db_tbl db_tbl : db_tblArray) {
            this.Meta_tbl_remake(db_tbl);
        }
    }

    public void Meta_tbl_remake(Db_tbl db_tbl) {
        this.engine.Meta_tbl_delete(db_tbl.Tbl_name());
        db_tbl.Create_tbl();
    }

    public void Meta_tbl_remake(Dbmeta_tbl_itm dbmeta_tbl_itm) {
        this.engine.Meta_tbl_delete(dbmeta_tbl_itm.Name());
        this.engine.Meta_tbl_create(dbmeta_tbl_itm);
    }

    public void Meta_idx_assert(String string, String string2, String ... stringArray) {
        if (this.engine.Meta_idx_exists(string + "__" + string2)) {
            return;
        }
        this.Meta_idx_create(string, string2, stringArray);
    }

    public void Meta_idx_assert(String string, String string2, Dbmeta_idx_fld ... dbmeta_idx_fldArray) {
        if (this.engine.Meta_idx_exists(string + "__" + string2)) {
            return;
        }
        this.Meta_idx_create(string, string2, dbmeta_idx_fldArray);
    }

    public void Meta_idx_create(String string, String string2, String ... stringArray) {
        this.engine.Meta_idx_create(Gfo_usr_dlg_.Instance, Dbmeta_idx_itm.new_normal_by_tbl(string, string2, stringArray));
    }

    public void Meta_idx_create(String string, String string2, Dbmeta_idx_fld ... dbmeta_idx_fldArray) {
        this.engine.Meta_idx_create(Gfo_usr_dlg_.Instance, Dbmeta_idx_itm.new_normal_by_tbl(string, string2, dbmeta_idx_fldArray));
    }

    public void Meta_idx_create(Dbmeta_idx_itm ... dbmeta_idx_itmArray) {
        this.engine.Meta_idx_create(Gfo_usr_dlg_.Instance, dbmeta_idx_itmArray);
    }

    public void Meta_idx_create(Gfo_usr_dlg gfo_usr_dlg, Dbmeta_idx_itm ... dbmeta_idx_itmArray) {
        this.engine.Meta_idx_create(gfo_usr_dlg, dbmeta_idx_itmArray);
    }

    public void Meta_idx_delete(String string) {
        this.engine.Meta_idx_delete(string);
    }

    public void Meta_idx_delete(String string, String string2) {
        this.engine.Meta_idx_delete(string + "__" + string2);
    }

    public void Meta_fld_append(String string, Dbmeta_fld_itm dbmeta_fld_itm) {
        this.engine.Meta_fld_append(string, dbmeta_fld_itm);
    }

    public void Meta_fld_assert(String string, String string2, Dbmeta_fld_tid dbmeta_fld_tid, Object object) {
        if (!this.Meta_fld_exists(string, string2)) {
            this.Meta_fld_append(string, new Dbmeta_fld_itm(string2, dbmeta_fld_tid).Default_(object));
        }
    }

    public boolean Meta_tbl_exists(String string) {
        return this.engine.Meta_tbl_exists(string);
    }

    public boolean Meta_fld_exists(String string, String string2) {
        return this.engine.Meta_fld_exists(string, string2);
    }

    public boolean Meta_idx_exists(String string) {
        return this.engine.Meta_idx_exists(string);
    }

    public boolean Meta_idx_exists(String string, String string2) {
        return this.engine.Meta_idx_exists(string + "__" + string2);
    }

    public void Meta_tbl_assert(Db_tbl ... db_tblArray) {
        boolean bl = false;
        for (Db_tbl db_tbl : db_tblArray) {
            if (this.Meta_tbl_exists(db_tbl.Tbl_name())) continue;
            db_tbl.Create_tbl();
            bl = true;
        }
        if (bl) {
            this.Meta_mgr().Load_all();
        }
    }

    public String Meta_fld_append_if_missing(String string, Dbmeta_fld_list dbmeta_fld_list, Dbmeta_fld_itm dbmeta_fld_itm) {
        String string2 = dbmeta_fld_itm.Name();
        if (this.Meta_tbl_exists(string) && !this.Meta_fld_exists(string, string2)) {
            try {
                this.Meta_fld_append(string, dbmeta_fld_itm);
            }
            catch (Exception exception) {
                Gfo_log_.Instance.Warn("failed to append fld", "conn", this.Conn_info().Db_api(), "tbl", string, "fld", string2, "err", Err_.Message_gplx_log(exception));
                string2 = Dbmeta_fld_itm.Key_null;
            }
        } else if (!dbmeta_fld_list.Has(dbmeta_fld_itm.Name())) {
            string2 = dbmeta_fld_list.Add(dbmeta_fld_itm);
        }
        return string2;
    }

    public Dbmeta_tbl_mgr Meta_mgr() {
        return this.engine.Meta_mgr();
    }

    public Db_stmt Stmt_insert(String string, Dbmeta_fld_list dbmeta_fld_list) {
        return this.engine.Stmt_by_qry(Db_qry_insert.new_(string, dbmeta_fld_list.To_str_ary_wo_autonum()));
    }

    public Db_stmt Stmt_insert(String string, String ... stringArray) {
        return this.engine.Stmt_by_qry(Db_qry_insert.new_(string, stringArray));
    }

    public Db_stmt Stmt_update(String string, String[] stringArray, String ... stringArray2) {
        return this.engine.Stmt_by_qry(Db_qry_update.New(string, stringArray, stringArray2));
    }

    public Db_stmt Stmt_update_exclude(String string, Dbmeta_fld_list dbmeta_fld_list, String ... stringArray) {
        return this.engine.Stmt_by_qry(Db_qry_update.New(string, stringArray, dbmeta_fld_list.To_str_ary_exclude(stringArray)));
    }

    public Db_stmt Stmt_delete(String string, String ... stringArray) {
        return this.engine.Stmt_by_qry(Db_qry_delete.new_(string, stringArray));
    }

    public Db_stmt Stmt_select_all(String string, Dbmeta_fld_list dbmeta_fld_list) {
        return this.engine.Stmt_by_qry(Db_qry__select_in_tbl.new_(string, String_.Ary_empty, dbmeta_fld_list.To_str_ary(), null));
    }

    public Db_stmt Stmt_select(String string, String[] stringArray, String ... stringArray2) {
        return this.engine.Stmt_by_qry(Db_qry__select_in_tbl.new_(string, stringArray2, stringArray, null));
    }

    public Db_stmt Stmt_select(String string, Dbmeta_fld_list dbmeta_fld_list, String ... stringArray) {
        return this.engine.Stmt_by_qry(Db_qry__select_in_tbl.new_(string, stringArray, dbmeta_fld_list.To_str_ary(), null));
    }

    public Db_stmt Stmt_select_order(String string, Dbmeta_fld_list dbmeta_fld_list, String[] stringArray, String ... stringArray2) {
        return this.engine.Stmt_by_qry(Db_qry__select_in_tbl.new_(string, stringArray, dbmeta_fld_list.To_str_ary(), stringArray2));
    }

    public Db_stmt Stmt_select_order(String string, String[] stringArray, String[] stringArray2, String ... stringArray3) {
        return this.engine.Stmt_by_qry(Db_qry__select_in_tbl.new_(string, stringArray2, stringArray, stringArray3));
    }

    public Db_stmt Stmt_new(Db_qry db_qry) {
        return this.engine.Stmt_by_qry(db_qry);
    }

    public Db_stmt Stmt_sql(String string) {
        return this.engine.Stmt_by_qry(Db_qry_sql.sql_(string));
    }

    public int Exec_qry(Db_qry db_qry) {
        return Int_.Cast(this.engine.Exec_as_obj(db_qry));
    }

    public int Exec_sql_concat(String ... stringArray) {
        return this.Exec_qry(Db_qry_sql.dml_(String_.Concat_lines_nl_skip_last(stringArray)));
    }

    public int Exec_sql_concat_w_msg(String string, String ... stringArray) {
        Gfo_usr_dlg_.Instance.Plog_many("", "", string, new Object[0]);
        return this.Exec_sql_concat(stringArray);
    }

    public int Exec_sql(String string) {
        return this.Exec_qry(Db_qry_sql.dml_(string));
    }

    public int Exec_sql(String string, String string2) {
        Gfo_usr_dlg_.Instance.Plog_many("", "", string, new Object[0]);
        return this.Exec_sql(string2);
    }

    public Db_rdr Exec_rdr(String string) {
        return this.Stmt_sql(string).Exec_select__rls_auto();
    }

    public void Exec_delete_all(String string) {
        this.Stmt_delete(string, new String[0]).Exec_delete();
    }

    public int Exec_sql_args(String string, Object ... objectArray) {
        return this.Exec_qry(Db_qry_sql.dml_(String_.Format(string, objectArray)));
    }

    public int Exec_sql_plog_ntx(String string, String string2) {
        return this.Exec_sql_plog(false, string, string2);
    }

    public int Exec_sql_plog_txn(String string, String string2) {
        return this.Exec_sql_plog(true, string, string2);
    }

    public int Exec_sql_plog(boolean bl, String string, String string2) {
        Gfo_usr_dlg_.Instance.Plog_many("", "", string, new Object[0]);
        if (bl) {
            this.Txn_bgn(string);
        }
        int n = this.Exec_sql(string2);
        if (bl) {
            this.Txn_end();
        }
        Gfo_usr_dlg_.Instance.Plog_many("", "", "done:" + string, new Object[0]);
        return n;
    }

    public int Exec_select_max_as_int(String string, String string2, int n) {
        Object object = this.Exec_select_as_obj(String_.Format("SELECT Max({0}) FROM {1}", string2, string));
        return object == null ? n : Int_.Cast(object);
    }

    public int Exec_select_count_as_int(String string, int n) {
        Object object = this.Exec_select_as_obj(String_.Format("SELECT Count(*) FROM {0}", string));
        return object == null ? n : Int_.Cast(object);
    }

    public int Exec_select_as_int(String string, int n) {
        Object object = this.Exec_select_as_obj(string);
        return object == null ? n : Int_.Cast(object);
    }

    public double Exec_select_as_double(String string, double d) {
        Object object = this.Exec_select_as_obj(string);
        return object == null ? d : Double_.cast(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object Exec_select_as_obj(String string) {
        Db_rdr db_rdr = this.Exec_rdr(string);
        try {
            Object object = db_rdr.Move_next() ? db_rdr.Read_at(0) : null;
            return object;
        }
        finally {
            db_rdr.Rls();
        }
    }

    public void Rls_reg(Rls_able rls_able) {
        if (this == Db_conn_.Noop) {
            return;
        }
        this.rls_list.Add(rls_able);
    }

    public void Rls_conn() {
        int n = this.rls_list.Count();
        for (int i = 0; i < n; ++i) {
            Rls_able rls_able = (Rls_able)this.rls_list.Get_at(i);
            rls_able.Rls();
        }
        this.engine.Conn_term();
        Db_conn_pool.Instance.Del(this.engine.Conn_info());
    }

    public void Reopen_conn() {
        this.engine.Conn_open();
        Db_conn_pool.Instance.Add_existing(this);
    }

    public Db_stmt Stmt_select_max(String string, String string2, String ... stringArray) {
        Db_qry__select_in_tbl db_qry__select_in_tbl = new Db_qry__select_in_tbl(string, String_.Ary(String_.Format("Max({0}) AS {0}", string2)), stringArray, null, null, null, null);
        db_qry__select_in_tbl.Where_(stringArray.length == 0 ? Db_crt_.Wildcard : Db_crt_.eq_many_(stringArray));
        return this.engine.Stmt_by_qry(db_qry__select_in_tbl);
    }

    public DataRdr Exec_sql_as_old_rdr(String string) {
        return DataRdr_.cast(this.engine.Exec_as_obj(Db_qry_sql.rdr_(string)));
    }

    public DataRdr Exec_qry_as_old_rdr(Db_qry db_qry) {
        return DataRdr_.cast(this.engine.Exec_as_obj(db_qry));
    }
}

