/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs;

import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.Io_url;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.String_;
import gplx.dbs.Db_attach_itm;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_conn_info_;
import gplx.dbs.Db_qry;
import gplx.dbs.Db_stmt;
import gplx.dbs.sqls.Sql_qry_wtr;
import gplx.dbs.sqls.itms.Sql_from_clause;
import gplx.dbs.sqls.itms.Sql_tbl_itm;

public class Db_attach_mgr {
    private Db_conn main_conn;
    private Io_url main_conn_url;
    private final Ordered_hash links_hash = Ordered_hash_.New();
    private final List_adp attach_list = List_adp_.New();
    private String attached_sql;

    public Db_attach_mgr() {
    }

    public Db_attach_mgr(Db_conn db_conn, Db_attach_itm ... db_attach_itmArray) {
        this.Conn_main_(db_conn);
        this.Conn_links_(db_attach_itmArray);
    }

    public Db_conn Conn_main() {
        return this.main_conn;
    }

    public Db_attach_mgr Conn_main_(Db_conn db_conn) {
        this.main_conn = db_conn;
        this.main_conn_url = Db_conn_info_.To_url(db_conn.Conn_info());
        return this;
    }

    public Db_attach_mgr Conn_links_(Db_attach_itm ... db_attach_itmArray) {
        this.links_hash.Clear();
        for (Db_attach_itm db_attach_itm : db_attach_itmArray) {
            this.links_hash.Add(db_attach_itm.Key, db_attach_itm);
        }
        return this;
    }

    public void Attach() {
        int n = this.attach_list.Len();
        for (int i = 0; i < n; ++i) {
            Db_attach_itm db_attach_itm = (Db_attach_itm)this.attach_list.Get_at(i);
            this.main_conn.Env_db_attach(db_attach_itm.Key, db_attach_itm.Url);
        }
    }

    public void Detach() {
        int n = this.attach_list.Len();
        for (int i = 0; i < n; ++i) {
            Db_attach_itm db_attach_itm = (Db_attach_itm)this.attach_list.Get_at(i);
            this.main_conn.Env_db_detach(db_attach_itm.Key);
        }
        this.attach_list.Clear();
    }

    public String Resolve_sql(String string) {
        this.attach_list.Clear();
        int n = this.links_hash.Count();
        for (int i = 0; i < n; ++i) {
            Db_attach_itm db_attach_itm = (Db_attach_itm)this.links_hash.Get_at(i);
            String string2 = "<" + db_attach_itm.Key + ">";
            if (!String_.Has(string, string2)) continue;
            Io_url io_url = db_attach_itm.Url;
            String string3 = "";
            if (!io_url.Eq(this.main_conn_url)) {
                string3 = db_attach_itm.Key + ".";
                this.attach_list.Add(db_attach_itm);
            }
            string = String_.Replace(string, string2, string3);
        }
        this.attached_sql = string;
        return string;
    }

    public Db_attach_mgr Exec_sql_w_msg(String string, String string2, Object ... objectArray) {
        Gfo_usr_dlg_.Instance.Plog_many("", "", string, new Object[0]);
        this.Exec_sql(string2, objectArray);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db_attach_mgr Exec_sql(String string, Object ... objectArray) {
        String string2 = String_.Format(this.Resolve_sql(string), objectArray);
        this.Attach();
        try {
            this.main_conn.Exec_sql(string2);
        }
        finally {
            this.Detach();
        }
        return this;
    }

    public String Test__attach_sql() {
        return this.attached_sql;
    }

    public String[] Test__attach_list_keys() {
        int n = this.attach_list.Count();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Db_attach_itm db_attach_itm = (Db_attach_itm)this.attach_list.Get_at(i);
            stringArray[i] = db_attach_itm.Key;
        }
        return stringArray;
    }

    public Db_stmt Test__make_stmt_and_attach(Db_qry db_qry, Sql_from_clause sql_from_clause) {
        Sql_tbl_itm sql_tbl_itm;
        int n;
        this.attach_list.Clear();
        Sql_qry_wtr sql_qry_wtr = this.main_conn.Engine().Sql_wtr();
        List_adp list_adp = sql_from_clause.Tbls;
        int n2 = list_adp.Count();
        for (n = 0; n < n2; ++n) {
            sql_tbl_itm = (Sql_tbl_itm)list_adp.Get_at(n);
            String string = sql_tbl_itm.Db;
            if (String_.Eq(Sql_tbl_itm.Db__null, string)) continue;
            Db_attach_itm db_attach_itm = (Db_attach_itm)this.links_hash.Get_by(string);
            if (db_attach_itm == null) {
                throw Err_.new_("dbs", "qry defines an unknown database for attach_wkr", "from_tbl_db", string, "sql", db_qry.To_sql__exec(sql_qry_wtr));
            }
            if (db_attach_itm.Url.Eq(this.main_conn_url)) {
                sql_tbl_itm.Db_enabled = false;
                continue;
            }
            this.attach_list.Add(db_attach_itm);
        }
        this.attached_sql = sql_qry_wtr.To_sql_str(db_qry, true);
        this.Attach();
        for (n = 0; n < n2; ++n) {
            sql_tbl_itm = (Sql_tbl_itm)list_adp.Get_at(n);
            sql_tbl_itm.Db_enabled = true;
        }
        return this.main_conn.Stmt_sql(this.attached_sql);
    }
}

