/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.threads;

import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.Gfo_usr_dlg;
import gplx.GfsCtx;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.Virtual;
import gplx.core.brys.fmtrs.Bry_fmtr_eval_mgr;
import gplx.core.brys.fmtrs.Bry_fmtr_eval_mgr_;
import gplx.core.envs.Process_adp;
import gplx.core.ios.Io_size_;
import gplx.core.threads.Gfo_thread_cmd;
import gplx.gfui.kits.core.Gfui_kit;
import gplx.xowa.bldrs.cmds.utils.Xob_unzip_wkr;

public class Gfo_thread_cmd_unzip
implements Gfo_thread_cmd {
    private Io_url src;
    private Io_url trg;
    private Gfui_kit kit;
    private Gfo_usr_dlg usr_dlg;
    private Xob_unzip_wkr unzip_wkr;
    Gfo_invk owner;
    Gfo_thread_cmd next_cmd;
    Bry_fmtr_eval_mgr url_eval_mgr;
    public static final byte Term_cmd_for_src_noop = 0;
    public static final byte Term_cmd_for_src_delete = 1;
    public static final byte Term_cmd_for_src_move = 2;
    boolean rename_dir = false;
    boolean trg_is_dir = false;
    boolean delete_trg_if_exists = true;
    private byte term_cmd_for_src = 1;
    Io_url term_cmd_for_src_url = Io_url_.Empty;
    private static final String Invk_owner = "owner";
    private static final String Invk_src_ = "src_";
    private static final String Invk_trg_ = "trg_";
    private static final String Invk_rename_dir_ = "rename_dir_";
    private static final String Invk_delete_trg_if_exists_ = "delete_trg_if_exists_";
    private static final String Invk_term_cmd_for_src_ = "term_cmd_for_src_";
    static final String GRP_KEY = "xowa.thread.file.unzip";
    public static final String KEY = "file.unzip";

    public Gfo_thread_cmd_unzip Init(Gfo_usr_dlg gfo_usr_dlg, Gfui_kit gfui_kit, Process_adp process_adp, Process_adp process_adp2, Process_adp process_adp3, Io_url io_url, Io_url io_url2) {
        this.src = io_url;
        this.trg = io_url2;
        this.kit = gfui_kit;
        this.usr_dlg = gfo_usr_dlg;
        this.unzip_wkr = new Xob_unzip_wkr().Init(process_adp, process_adp2, process_adp3).Process_run_mode_((byte)0);
        return this;
    }

    public Gfo_invk Owner() {
        return this.owner;
    }

    public Gfo_thread_cmd_unzip Owner_(Gfo_invk gfo_invk) {
        this.owner = gfo_invk;
        return this;
    }

    @Override
    public void Cmd_ctor() {
    }

    @Override
    @Virtual
    public String Async_key() {
        return KEY;
    }

    @Override
    public Gfo_thread_cmd Async_next_cmd() {
        return this.next_cmd;
    }

    @Override
    public void Async_next_cmd_(Gfo_thread_cmd gfo_thread_cmd) {
        this.next_cmd = gfo_thread_cmd;
    }

    public Bry_fmtr_eval_mgr Url_eval_mgr() {
        return this.url_eval_mgr;
    }

    public Gfo_thread_cmd_unzip Url_eval_mgr_(Bry_fmtr_eval_mgr bry_fmtr_eval_mgr) {
        this.url_eval_mgr = bry_fmtr_eval_mgr;
        return this;
    }

    @Override
    public int Async_sleep_interval() {
        return 1000;
    }

    @Override
    public boolean Async_prog_enabled() {
        return true;
    }

    @Override
    public void Async_prog_run(int n) {
        String string = " please wait...";
        if (this.trg.Type_fil()) {
            string = Io_size_.To_str(Io_mgr.Instance.QueryFil(this.trg).Size());
        }
        this.usr_dlg.Prog_many(GRP_KEY, "unzip", "unzipping: ~{0}", string);
    }

    @Override
    @Virtual
    public byte Async_init() {
        if (!Io_mgr.Instance.ExistsFil(this.src)) {
            this.kit.Ask_ok(GRP_KEY, "source_missing", "Source file does not exist: '~{0}'", this.src.Raw());
            return 1;
        }
        this.trg_is_dir = this.trg.Type_dir();
        if (this.delete_trg_if_exists && (this.trg_is_dir && Io_mgr.Instance.ExistsDir(this.trg) || !this.trg_is_dir && Io_mgr.Instance.ExistsFil(this.trg))) {
            int n = this.kit.Ask_yes_no_cancel(GRP_KEY, "target_exists", "Target file already exists: '~{0}'.\nDo you want to delete it?", this.trg.Raw());
            switch (n) {
                case 2: {
                    if (this.trg_is_dir) {
                        Io_mgr.Instance.DeleteDirDeep(this.trg);
                        break;
                    }
                    Io_mgr.Instance.DeleteFil(this.trg);
                    break;
                }
                case 3: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
        }
        return 0;
    }

    @Override
    public boolean Async_running() {
        return this.unzip_wkr.Process_exit_code() == -1;
    }

    @Override
    public void Async_run() {
        this.usr_dlg.Prog_many(GRP_KEY, "bgn", "unzipping", new Object[0]);
        this.unzip_wkr.Decompress(this.src, this.trg);
    }

    @Override
    public boolean Async_term() {
        if (this.rename_dir) {
            Io_url[] io_urlArray = Io_mgr.Instance.QueryDir_args(this.trg.OwnerDir()).DirOnly_().Recur_(false).ExecAsUrlAry();
            int n = io_urlArray.length;
            Io_url io_url = Io_url_.Empty;
            for (int i = 0; i < n; ++i) {
                Io_url io_url2 = io_urlArray[i];
                if (!String_.Has_at_bgn(String_.Lower(io_url2.NameOnly()), String_.Lower(this.trg.NameOnly()))) continue;
                io_url = io_url2;
                break;
            }
            if (io_url == Io_url_.Empty) {
                this.kit.Ask_ok(GRP_KEY, "rename.fail", "unable to find directory: trg=~{0}", this.trg.Raw());
                return false;
            }
            if (!String_.Eq(String_.Lower(io_url.Raw()), String_.Lower(this.trg.Raw()))) {
                Io_mgr.Instance.MoveDirDeep(io_url, this.trg);
            }
        }
        switch (this.term_cmd_for_src) {
            case 0: {
                break;
            }
            case 1: {
                Io_mgr.Instance.DeleteFil(this.src);
                break;
            }
            case 2: {
                if (this.term_cmd_for_src_url == Io_url_.Empty) {
                    throw Err_.new_wo_type("move specified, but no url", new Object[0]);
                }
                Io_mgr.Instance.MoveFil_args(this.src, this.term_cmd_for_src_url, true).Exec();
                break;
            }
            default: {
                throw Err_.new_unhandled(this.term_cmd_for_src);
            }
        }
        this.usr_dlg.Prog_many(GRP_KEY, "done", "", new Object[0]);
        return true;
    }

    public byte Term_cmd_for_src() {
        return this.term_cmd_for_src;
    }

    public void Term_cmd_for_src_(byte by) {
        this.term_cmd_for_src = by;
    }

    public Io_url Term_cmd_for_src_url() {
        return this.term_cmd_for_src_url;
    }

    public void Term_cmd_for_src_url_(Io_url io_url) {
        this.term_cmd_for_src_url = io_url;
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_owner)) {
            return this.owner;
        }
        if (gfsCtx.Match(string, Invk_src_)) {
            this.src = Bry_fmtr_eval_mgr_.Eval_url(this.url_eval_mgr, gfoMsg.ReadBry("v"));
        } else if (gfsCtx.Match(string, Invk_trg_)) {
            this.trg = Bry_fmtr_eval_mgr_.Eval_url(this.url_eval_mgr, gfoMsg.ReadBry("v"));
        } else if (gfsCtx.Match(string, Invk_rename_dir_)) {
            this.rename_dir = gfoMsg.ReadYn("v");
        } else if (gfsCtx.Match(string, Invk_delete_trg_if_exists_)) {
            this.delete_trg_if_exists = gfoMsg.ReadYn("v");
        } else if (gfsCtx.Match(string, Invk_term_cmd_for_src_)) {
            this.term_cmd_for_src = Gfo_thread_cmd_unzip.Term_cmd_for_src_parse_(gfoMsg.ReadStr("v"));
        } else {
            return Gfo_invk_.Rv_unhandled;
        }
        return this;
    }

    private static byte Term_cmd_for_src_parse_(String string) {
        if (String_.Eq(string, "noop")) {
            return 0;
        }
        if (String_.Eq(string, "delete")) {
            return 1;
        }
        if (String_.Eq(string, "move")) {
            return 2;
        }
        throw Err_.new_unhandled(string);
    }
}

